/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.finalization;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import org.jetbrains.annotations.NotNull;

public class NoExplicitFinalizeCallsInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("FinalizeCalledExplicitly" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/finalization/NoExplicitFinalizeCallsInspection.getID must not return null");
        }
        return "FinalizeCalledExplicitly";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("finalize.called.explicitly.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/finalization/NoExplicitFinalizeCallsInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("finalize.called.explicitly.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/finalization/NoExplicitFinalizeCallsInspection.buildErrorString must not return null");
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NoExplicitFinalizeCallsVisitor();
    }

    private static class NoExplicitFinalizeCallsVisitor
    extends BaseInspectionVisitor {
        private NoExplicitFinalizeCallsVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/finalization/NoExplicitFinalizeCallsInspection$NoExplicitFinalizeCallsVisitor.visitMethodCallExpression must not be null");
            }
            super.visitMethodCallExpression(expression);
            if (!MethodCallUtils.isCallToMethod(expression, null, PsiType.VOID, "finalize", new PsiType[0])) {
                return;
            }
            PsiMethod containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMethod.class);
            if (containingMethod == null) {
                return;
            }
            if (MethodUtils.methodMatches(containingMethod, null, PsiType.VOID, "finalize", new PsiType[0])) {
                return;
            }
            this.registerMethodCallError(expression, new Object[0]);
        }
    }
}

