/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.GuiUtils;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ClassUtils;
import java.lang.reflect.InvocationTargetException;
import org.jetbrains.annotations.NotNull;

class StaticInheritanceFix
extends InspectionGadgetsFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.siyeh.ig.inheritance.StaticInheritanceFix");
    private final boolean myReplaceInWholeProject;

    StaticInheritanceFix(boolean replaceInWholeProject) {
        this.myReplaceInWholeProject = replaceInWholeProject;
    }

    @NotNull
    public String getName() {
        String scope = this.myReplaceInWholeProject ? InspectionGadgetsBundle.message("the.whole.project", new Object[0]) : InspectionGadgetsBundle.message("this.class", new Object[0]);
        String string = InspectionGadgetsBundle.message("static.inheritance.replace.quickfix", scope);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/inheritance/StaticInheritanceFix.getName must not return null");
        }
        return string;
    }

    @Override
    public void doFix(final Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
        PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)descriptor.getPsiElement();
        final PsiClass iface = (PsiClass)referenceElement.resolve();
        assert (iface != null);
        final PsiField[] allFields = iface.getAllFields();
        final PsiClass implementingClass = ClassUtils.getContainingClass((PsiElement)referenceElement);
        final PsiManager manager = referenceElement.getManager();
        assert (implementingClass != null);
        ProgressManager.getInstance().run((Task)new Task.Modal(project, "Replacing usages of " + iface.getName(), false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/inheritance/StaticInheritanceFix$1.run must not be null");
                }
                for (final PsiField field : allFields) {
                    Query search = ReferencesSearch.search((PsiElement)field, (SearchScope)implementingClass.getUseScope(), (boolean)false);
                    for (PsiReference reference : search) {
                        if (!(reference instanceof PsiReferenceExpression)) continue;
                        final PsiReferenceExpression referenceExpression = (PsiReferenceExpression)reference;
                        if (!StaticInheritanceFix.this.myReplaceInWholeProject) {
                            PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)referenceExpression, PsiClass.class);
                            boolean isInheritor = false;
                            while (aClass != null && !(isInheritor = InheritanceUtil.isInheritorOrSelf((PsiClass)aClass, (PsiClass)implementingClass, (boolean)true))) {
                                aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiClass.class);
                            }
                            if (!isInheritor) continue;
                        }
                        Runnable runnable = new Runnable(){

                            @Override
                            public void run() {
                                if (StaticInheritanceFix.isQuickFixOnReadOnlyFile((PsiElement)referenceExpression)) {
                                    return;
                                }
                                PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
                                PsiReferenceExpression qualified = (PsiReferenceExpression)elementFactory.createExpressionFromText("xxx." + referenceExpression.getText(), (PsiElement)referenceExpression);
                                PsiReferenceExpression newReference = (PsiReferenceExpression)referenceExpression.replace((PsiElement)qualified);
                                PsiReferenceExpression qualifier = (PsiReferenceExpression)newReference.getQualifierExpression();
                                assert (qualifier != null) : DebugUtil.psiToString((PsiElement)newReference, (boolean)false);
                                PsiClass containingClass = field.getContainingClass();
                                qualifier.bindToElement((PsiElement)containingClass);
                            }
                        };
                        try {
                            GuiUtils.runOrInvokeAndWait((Runnable)runnable);
                        }
                        catch (InvocationTargetException e) {
                            LOG.error((Throwable)e);
                        }
                        catch (InterruptedException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                }
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        PsiClassType classType = JavaPsiFacade.getInstance((Project)project).getElementFactory().createType(iface);
                        IntentionAction fix = QuickFixFactory.getInstance().createExtendsListFix(implementingClass, classType, false);
                        fix.invoke(project, null, implementingClass.getContainingFile());
                    }
                };
                try {
                    GuiUtils.runOrInvokeAndWait((Runnable)runnable);
                }
                catch (InvocationTargetException e) {
                    LOG.error((Throwable)e);
                }
                catch (InterruptedException e) {
                    LOG.error((Throwable)e);
                }
            }
        });
    }
}

