/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.methodmetrics;

import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.methodmetrics.CouplingVisitor;
import com.siyeh.ig.methodmetrics.MethodMetricInspection;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;

public class MethodCouplingInspection
extends MethodMetricInspection {
    public boolean m_includeJavaClasses = false;
    public boolean m_includeLibraryClasses = false;

    @NotNull
    public String getID() {
        if ("OverlyCoupledMethod" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/methodmetrics/MethodCouplingInspection.getID must not return null");
        }
        return "OverlyCoupledMethod";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("method.coupling.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/methodmetrics/MethodCouplingInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Integer coupling = (Integer)infos[0];
        String string = InspectionGadgetsBundle.message("method.coupling.problem.descriptor", coupling);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/methodmetrics/MethodCouplingInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    protected int getDefaultLimit() {
        return 10;
    }

    @Override
    protected String getConfigurationLabel() {
        return InspectionGadgetsBundle.message("method.coupling.limit.option", new Object[0]);
    }

    @Override
    public JComponent createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        String configurationLabel = this.getConfigurationLabel();
        JLabel label = new JLabel(configurationLabel);
        JFormattedTextField valueField = this.prepareNumberEditor("m_limit");
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 17;
        constraints.fill = 0;
        panel.add((Component)label, constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 17;
        constraints.fill = 0;
        panel.add((Component)valueField, constraints);
        JCheckBox arrayCheckBox = new JCheckBox(InspectionGadgetsBundle.message("include.java.system.classes.option", new Object[0]), this.m_includeJavaClasses);
        final ButtonModel arrayModel = arrayCheckBox.getModel();
        arrayModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                MethodCouplingInspection.this.m_includeJavaClasses = arrayModel.isSelected();
            }
        });
        JCheckBox objectCheckBox = new JCheckBox(InspectionGadgetsBundle.message("include.library.classes.option", new Object[0]), this.m_includeLibraryClasses);
        final ButtonModel model = objectCheckBox.getModel();
        model.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                MethodCouplingInspection.this.m_includeLibraryClasses = model.isSelected();
            }
        });
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 2;
        constraints.fill = 2;
        panel.add((Component)arrayCheckBox, constraints);
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 2;
        panel.add((Component)objectCheckBox, constraints);
        return panel;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MethodCouplingVisitor();
    }

    private class MethodCouplingVisitor
    extends BaseInspectionVisitor {
        private MethodCouplingVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/methodmetrics/MethodCouplingInspection$MethodCouplingVisitor.visitMethod must not be null");
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            CouplingVisitor visitor = new CouplingVisitor(method, MethodCouplingInspection.this.m_includeJavaClasses, MethodCouplingInspection.this.m_includeLibraryClasses);
            method.accept((PsiElementVisitor)visitor);
            int coupling = visitor.getNumDependencies();
            if (coupling <= MethodCouplingInspection.this.getLimit()) {
                return;
            }
            this.registerMethodError(method, coupling);
        }
    }
}

