/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.methodmetrics;

import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.methodmetrics.LoopCountVisitor;
import org.jetbrains.annotations.NotNull;

public class MethodWithMultipleLoopsInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("method.with.multiple.loops.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/methodmetrics/MethodWithMultipleLoopsInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Integer negationCount = (Integer)infos[0];
        String string = InspectionGadgetsBundle.message("method.with.multiple.loops.problem.descriptor", negationCount);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/methodmetrics/MethodWithMultipleLoopsInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MethodWithMultipleLoopsVisitor();
    }

    private static class MethodWithMultipleLoopsVisitor
    extends BaseInspectionVisitor {
        private MethodWithMultipleLoopsVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/methodmetrics/MethodWithMultipleLoopsInspection$MethodWithMultipleLoopsVisitor.visitMethod must not be null");
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            LoopCountVisitor visitor = new LoopCountVisitor();
            method.accept((PsiElementVisitor)visitor);
            int negationCount = visitor.getCount();
            if (negationCount <= 1) {
                return;
            }
            this.registerMethodError(method, negationCount);
        }
    }
}

