/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.psi.PsiClass;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import com.siyeh.ig.naming.ConventionInspection;
import org.jetbrains.annotations.NotNull;

public class InterfaceNamingConventionInspection
extends ConventionInspection {
    private static final int DEFAULT_MIN_LENGTH = 8;
    private static final int DEFAULT_MAX_LENGTH = 64;

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("interface.naming.convention.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/naming/InterfaceNamingConventionInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new RenameFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string;
        String interfaceName = (String)infos[0];
        if (interfaceName.length() < this.getMinLength()) {
            string = InspectionGadgetsBundle.message("interface.name.convention.problem.descriptor.short", new Object[0]);
            if (string == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/naming/InterfaceNamingConventionInspection.buildErrorString must not return null");
            return string;
        }
        if (interfaceName.length() > this.getMaxLength()) {
            string = InspectionGadgetsBundle.message("interface.name.convention.problem.descriptor.long", new Object[0]);
            if (string == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/naming/InterfaceNamingConventionInspection.buildErrorString must not return null");
            return string;
        }
        string = InspectionGadgetsBundle.message("interface.name.convention.problem.descriptor.regex.mismatch", this.getRegex());
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/siyeh/ig/naming/InterfaceNamingConventionInspection.buildErrorString must not return null");
    }

    @Override
    protected String getDefaultRegex() {
        return "[A-Z][A-Za-z\\d]*";
    }

    @Override
    protected int getDefaultMinLength() {
        return 8;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 64;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NamingConventionsVisitor();
    }

    private class NamingConventionsVisitor
    extends BaseInspectionVisitor {
        private NamingConventionsVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/naming/InterfaceNamingConventionInspection$NamingConventionsVisitor.visitClass must not be null");
            }
            if (!aClass.isInterface() || aClass.isAnnotationType()) {
                return;
            }
            String name = aClass.getName();
            if (name == null) {
                return;
            }
            if (InterfaceNamingConventionInspection.this.isValid(name)) {
                return;
            }
            this.registerClassError(aClass, name);
        }
    }
}

