/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import com.siyeh.ig.psiutils.ClassUtils;
import org.jetbrains.annotations.NotNull;

public class NonExceptionNameEndsWithExceptionInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("non.exception.name.ends.with.exception.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/naming/NonExceptionNameEndsWithExceptionInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("non.exception.name.ends.with.exception.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/naming/NonExceptionNameEndsWithExceptionInspection.buildErrorString must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        InspectionGadgetsFix[] inspectionGadgetsFixArray;
        String name = (String)infos[0];
        Boolean onTheFly = (Boolean)infos[1];
        if (onTheFly.booleanValue()) {
            inspectionGadgetsFixArray = new InspectionGadgetsFix[]{new RenameFix(), new ExtendExceptionFix(name)};
            if (inspectionGadgetsFixArray == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/naming/NonExceptionNameEndsWithExceptionInspection.buildFixes must not return null");
            return inspectionGadgetsFixArray;
        }
        inspectionGadgetsFixArray = new InspectionGadgetsFix[]{new ExtendExceptionFix(name)};
        if (inspectionGadgetsFixArray != null) return inspectionGadgetsFixArray;
        throw new IllegalStateException("@NotNull method com/siyeh/ig/naming/NonExceptionNameEndsWithExceptionInspection.buildFixes must not return null");
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NonExceptionNameEndsWithExceptionVisitor();
    }

    private static class NonExceptionNameEndsWithExceptionVisitor
    extends BaseInspectionVisitor {
        private NonExceptionNameEndsWithExceptionVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/naming/NonExceptionNameEndsWithExceptionInspection$NonExceptionNameEndsWithExceptionVisitor.visitClass must not be null");
            }
            String className = aClass.getName();
            if (className == null) {
                return;
            }
            String exception = "Exception";
            if (!className.endsWith("Exception")) {
                return;
            }
            if (ClassUtils.isSubclass(aClass, "java.lang.Exception")) {
                return;
            }
            this.registerClassError(aClass, className, this.isOnTheFly());
        }
    }

    private static class ExtendExceptionFix
    extends InspectionGadgetsFix {
        private final String name;

        ExtendExceptionFix(String name) {
            this.name = name;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("non.exception.name.ends.with.exception.quickfix", this.name);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/naming/NonExceptionNameEndsWithExceptionInspection$ExtendExceptionFix.getName must not return null");
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiJavaCodeReferenceElement[] referenceElements;
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiClass)) {
                return;
            }
            PsiClass aClass = (PsiClass)parent;
            PsiReferenceList extendsList = aClass.getExtendsList();
            if (extendsList == null) {
                return;
            }
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
            PsiElementFactory factory = facade.getElementFactory();
            GlobalSearchScope scope = aClass.getResolveScope();
            PsiJavaCodeReferenceElement reference = factory.createReferenceElementByFQClassName("java.lang.Exception", scope);
            for (PsiJavaCodeReferenceElement referenceElement : referenceElements = extendsList.getReferenceElements()) {
                referenceElement.delete();
            }
            extendsList.add((PsiElement)reference);
        }
    }
}

