/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class IntLiteralMayBeLongLiteralInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("int.literal.may.be.long.literal.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/numeric/IntLiteralMayBeLongLiteralInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiLiteralExpression literalExpression = (PsiLiteralExpression)infos[0];
        String replacementString = literalExpression.getText() + 'L';
        String string = InspectionGadgetsBundle.message("int.literal.may.be.long.literal.problem.descriptor", replacementString);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/numeric/IntLiteralMayBeLongLiteralInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiLiteralExpression literalExpression = (PsiLiteralExpression)infos[0];
        String replacementString = literalExpression.getText() + 'L';
        return new IntLiteralMayBeLongLiteralFix(replacementString);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new IntLiteralMayBeLongLiteralVisitor();
    }

    private static class IntLiteralMayBeLongLiteralVisitor
    extends BaseInspectionVisitor {
        private IntLiteralMayBeLongLiteralVisitor() {
        }

        public void visitLiteralExpression(PsiLiteralExpression expression) {
            super.visitLiteralExpression(expression);
            PsiType type = expression.getType();
            if (PsiType.INT != type) {
                return;
            }
            PsiElement parent = expression.getParent();
            if (!(parent instanceof PsiTypeCastExpression)) {
                return;
            }
            PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)parent;
            PsiType castType = typeCastExpression.getType();
            if (PsiType.LONG != castType) {
                return;
            }
            this.registerError((PsiElement)typeCastExpression, expression);
        }
    }

    private static class IntLiteralMayBeLongLiteralFix
    extends InspectionGadgetsFix {
        private final String replacementString;

        public IntLiteralMayBeLongLiteralFix(String replacementString) {
            this.replacementString = replacementString;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("int.literal.may.be.long.literal.quickfix", this.replacementString);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/numeric/IntLiteralMayBeLongLiteralInspection$IntLiteralMayBeLongLiteralFix.getName must not return null");
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiTypeCastExpression)) {
                return;
            }
            PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)element;
            IntLiteralMayBeLongLiteralFix.replaceExpression((PsiExpression)typeCastExpression, this.replacementString);
        }
    }
}

