/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.ConstantExpressionUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.CollectionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpressionUtils {
    private ExpressionUtils() {
    }

    public static Object computeConstantExpression(PsiExpression expression) {
        return ExpressionUtils.computeConstantExpression(expression, false);
    }

    public static Object computeConstantExpression(PsiExpression expression, boolean throwExceptionOnOverflow) {
        Project project = expression.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiConstantEvaluationHelper constantEvaluationHelper = psiFacade.getConstantEvaluationHelper();
        return constantEvaluationHelper.computeConstantExpression((PsiElement)expression, throwExceptionOnOverflow);
    }

    public static boolean isConstant(PsiField field) {
        if (!field.hasModifierProperty("final") || !field.hasModifierProperty("static")) {
            return false;
        }
        if (CollectionUtils.isEmptyArray(field)) {
            return true;
        }
        PsiType type = field.getType();
        return ClassUtils.isImmutable(type);
    }

    public static boolean isEvaluatedAtCompileTime(@Nullable PsiExpression expression) {
        if (expression instanceof PsiLiteralExpression) {
            return true;
        }
        if (expression instanceof PsiBinaryExpression) {
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiExpression rhs = binaryExpression.getROperand();
            return ExpressionUtils.isEvaluatedAtCompileTime(lhs) && ExpressionUtils.isEvaluatedAtCompileTime(rhs);
        }
        if (expression instanceof PsiPrefixExpression) {
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression;
            PsiExpression operand = prefixExpression.getOperand();
            return ExpressionUtils.isEvaluatedAtCompileTime(operand);
        }
        if (expression instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
            PsiElement qualifier = referenceExpression.getQualifier();
            if (qualifier instanceof PsiThisExpression) {
                return false;
            }
            PsiElement element = referenceExpression.resolve();
            if (element instanceof PsiField) {
                PsiField field = (PsiField)element;
                PsiExpression initializer = field.getInitializer();
                return field.hasModifierProperty("final") && ExpressionUtils.isEvaluatedAtCompileTime(initializer);
            }
            if (element instanceof PsiVariable) {
                PsiVariable variable = (PsiVariable)element;
                if (PsiTreeUtil.isAncestor((PsiElement)variable, (PsiElement)expression, (boolean)true)) {
                    return false;
                }
                PsiExpression initializer = variable.getInitializer();
                return variable.hasModifierProperty("final") && ExpressionUtils.isEvaluatedAtCompileTime(initializer);
            }
        }
        if (expression instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression;
            PsiExpression unparenthesizedExpression = parenthesizedExpression.getExpression();
            return ExpressionUtils.isEvaluatedAtCompileTime(unparenthesizedExpression);
        }
        if (expression instanceof PsiConditionalExpression) {
            PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)expression;
            PsiExpression condition = conditionalExpression.getCondition();
            PsiExpression thenExpression = conditionalExpression.getThenExpression();
            PsiExpression elseExpression = conditionalExpression.getElseExpression();
            return ExpressionUtils.isEvaluatedAtCompileTime(condition) && ExpressionUtils.isEvaluatedAtCompileTime(thenExpression) && ExpressionUtils.isEvaluatedAtCompileTime(elseExpression);
        }
        if (expression instanceof PsiTypeCastExpression) {
            PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)expression;
            PsiTypeElement castType = typeCastExpression.getCastType();
            if (castType == null) {
                return false;
            }
            PsiType type = castType.getType();
            return TypeUtils.typeEquals("java.lang.String", type);
        }
        return false;
    }

    public static boolean isEmptyStringLiteral(@Nullable PsiExpression expression) {
        if (!(expression instanceof PsiLiteralExpression)) {
            return false;
        }
        String text = expression.getText();
        return "\"\"".equals(text);
    }

    public static boolean isNullLiteral(@Nullable PsiExpression expression) {
        if (!(expression instanceof PsiLiteralExpression)) {
            return false;
        }
        String text = expression.getText();
        return "null".equals(text);
    }

    public static boolean isZero(@Nullable PsiExpression expression) {
        if (expression == null) {
            return false;
        }
        PsiType expressionType = expression.getType();
        Object value = ConstantExpressionUtil.computeCastTo((PsiExpression)expression, (PsiType)expressionType);
        if (value == null) {
            return false;
        }
        if (value instanceof Double && (Double)value == 0.0) {
            return true;
        }
        if (value instanceof Float && ((Float)value).floatValue() == 0.0f) {
            return true;
        }
        if (value instanceof Integer && (Integer)value == 0) {
            return true;
        }
        if (value instanceof Long && (Long)value == 0L) {
            return true;
        }
        if (value instanceof Short && (Short)value == 0) {
            return true;
        }
        if (value instanceof Character && ((Character)value).charValue() == '\u0000') {
            return true;
        }
        return value instanceof Byte && (Byte)value == 0;
    }

    public static boolean isOne(@Nullable PsiExpression expression) {
        if (expression == null) {
            return false;
        }
        PsiType expressionType = expression.getType();
        Object value = ConstantExpressionUtil.computeCastTo((PsiExpression)expression, (PsiType)expressionType);
        if (value == null) {
            return false;
        }
        if (value instanceof Double && (Double)value == 1.0) {
            return true;
        }
        if (value instanceof Float && ((Float)value).floatValue() == 1.0f) {
            return true;
        }
        if (value instanceof Integer && (Integer)value == 1) {
            return true;
        }
        if (value instanceof Long && (Long)value == 1L) {
            return true;
        }
        if (value instanceof Short && (Short)value == 1) {
            return true;
        }
        if (value instanceof Character && ((Character)value).charValue() == '\u0001') {
            return true;
        }
        return value instanceof Byte && (Byte)value == 1;
    }

    public static boolean isNegation(@Nullable PsiExpression condition, boolean ignoreNegatedNullComparison) {
        if ((condition = ParenthesesUtils.stripParentheses(condition)) instanceof PsiPrefixExpression) {
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)condition;
            PsiJavaToken sign = prefixExpression.getOperationSign();
            IElementType tokenType = sign.getTokenType();
            return tokenType.equals(JavaTokenType.EXCL);
        }
        if (condition instanceof PsiBinaryExpression) {
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)condition;
            PsiJavaToken sign = binaryExpression.getOperationSign();
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiExpression rhs = binaryExpression.getROperand();
            if (rhs == null) {
                return false;
            }
            IElementType tokenType = sign.getTokenType();
            if (tokenType.equals(JavaTokenType.NE)) {
                if (ignoreNegatedNullComparison) {
                    String lhsText = lhs.getText();
                    String rhsText = rhs.getText();
                    return !"null".equals(lhsText) && !"null".equals(rhsText);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean isOffsetArrayAccess(@Nullable PsiExpression expression, @NotNull PsiVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/psiutils/ExpressionUtils.isOffsetArrayAccess must not be null");
        }
        PsiExpression strippedExpression = ParenthesesUtils.stripParentheses(expression);
        if (!(strippedExpression instanceof PsiArrayAccessExpression)) {
            return false;
        }
        PsiArrayAccessExpression arrayExpression = (PsiArrayAccessExpression)strippedExpression;
        PsiExpression index = arrayExpression.getIndexExpression();
        if (index == null) {
            return false;
        }
        return ExpressionUtils.expressionIsOffsetVariableLookup(index, variable);
    }

    private static boolean expressionIsOffsetVariableLookup(@Nullable PsiExpression expression, @NotNull PsiVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/psiutils/ExpressionUtils.expressionIsOffsetVariableLookup must not be null");
        }
        PsiExpression strippedExpression = ParenthesesUtils.stripParentheses(expression);
        if (VariableAccessUtils.evaluatesToVariable(strippedExpression, variable)) {
            return true;
        }
        if (!(strippedExpression instanceof PsiBinaryExpression)) {
            return false;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)strippedExpression;
        PsiJavaToken sign = binaryExpression.getOperationSign();
        IElementType tokenType = sign.getTokenType();
        if (!JavaTokenType.PLUS.equals(tokenType) && !JavaTokenType.MINUS.equals(tokenType)) {
            return false;
        }
        PsiExpression lhs = binaryExpression.getLOperand();
        if (ExpressionUtils.expressionIsOffsetVariableLookup(lhs, variable)) {
            return true;
        }
        PsiExpression rhs = binaryExpression.getROperand();
        return ExpressionUtils.expressionIsOffsetVariableLookup(rhs, variable) && !JavaTokenType.MINUS.equals(tokenType);
    }

    public static boolean isComparison(@Nullable PsiExpression expression, @NotNull PsiLocalVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/psiutils/ExpressionUtils.isComparison must not be null");
        }
        if (!((expression = ParenthesesUtils.stripParentheses(expression)) instanceof PsiBinaryExpression)) {
            return false;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
        PsiJavaToken sign = binaryExpression.getOperationSign();
        IElementType tokenType = sign.getTokenType();
        if (tokenType.equals(JavaTokenType.LT)) {
            PsiExpression lhs = binaryExpression.getLOperand();
            lhs = ParenthesesUtils.stripParentheses(lhs);
            return VariableAccessUtils.evaluatesToVariable(lhs, (PsiVariable)variable);
        }
        if (tokenType.equals(JavaTokenType.GT)) {
            PsiExpression rhs = binaryExpression.getROperand();
            rhs = ParenthesesUtils.stripParentheses(rhs);
            return VariableAccessUtils.evaluatesToVariable(rhs, (PsiVariable)variable);
        }
        return false;
    }

    public static boolean isZeroLengthArrayConstruction(@Nullable PsiExpression expression) {
        if (!(expression instanceof PsiNewExpression)) {
            return false;
        }
        PsiNewExpression newExpression = (PsiNewExpression)expression;
        PsiExpression[] dimensions = newExpression.getArrayDimensions();
        if (dimensions.length == 0) {
            PsiArrayInitializerExpression arrayInitializer = newExpression.getArrayInitializer();
            if (arrayInitializer == null) {
                return false;
            }
            PsiExpression[] initializers = arrayInitializer.getInitializers();
            return initializers.length == 0;
        }
        for (PsiExpression dimension : dimensions) {
            String dimensionText = dimension.getText();
            if ("0".equals(dimensionText)) continue;
            return false;
        }
        return true;
    }
}

