/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.ClassUtils;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ImportUtils {
    private ImportUtils() {
    }

    public static boolean nameCanBeStaticallyImported(@NotNull String fqName, @NotNull String memberName, @NotNull PsiElement context) {
        if (fqName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ImportUtils.nameCanBeStaticallyImported must not be null");
        }
        if (memberName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/psiutils/ImportUtils.nameCanBeStaticallyImported must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/siyeh/ig/psiutils/ImportUtils.nameCanBeStaticallyImported must not be null");
        }
        PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)context, PsiClass.class);
        if (containingClass == null) {
            return false;
        }
        if (ClassUtils.isSubclass(containingClass, fqName)) {
            return true;
        }
        PsiField field = containingClass.findFieldByName(memberName, true);
        if (field != null) {
            return false;
        }
        PsiMethod[] methods = containingClass.findMethodsByName(memberName, true);
        if (methods.length > 0) {
            return false;
        }
        if (ImportUtils.hasOnDemandImportStaticConflict(fqName, memberName, context, true)) {
            return false;
        }
        return !ImportUtils.hasExactImportStaticConflict(fqName, memberName, context);
    }

    public static boolean nameCanBeImported(@NotNull String fqName, @NotNull PsiElement context) {
        PsiJavaFile file;
        if (fqName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ImportUtils.nameCanBeImported must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/psiutils/ImportUtils.nameCanBeImported must not be null");
        }
        PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)context, PsiClass.class);
        if (containingClass != null) {
            PsiClass[] innerClasses;
            if (fqName.equals(containingClass.getQualifiedName())) {
                return true;
            }
            String shortName = ClassUtil.extractClassName((String)fqName);
            for (PsiClass innerClass : innerClasses = containingClass.getAllInnerClasses()) {
                String className;
                if (innerClass.hasModifierProperty("private") || innerClass.hasModifierProperty("packageLocal") && !ClassUtils.inSamePackage((PsiElement)innerClass, (PsiElement)containingClass) || !shortName.equals(className = innerClass.getName())) continue;
                return false;
            }
        }
        if ((file = (PsiJavaFile)PsiTreeUtil.getParentOfType((PsiElement)context, PsiJavaFile.class)) == null) {
            return false;
        }
        if (ImportUtils.hasExactImportConflict(fqName, file)) {
            return false;
        }
        if (ImportUtils.hasOnDemandImportConflict(fqName, file, true)) {
            return false;
        }
        if (ImportUtils.containsConflictingClass(fqName, file)) {
            return false;
        }
        return !ImportUtils.containsConflictingClassName(fqName, file);
    }

    private static boolean containsConflictingClassName(String fqName, PsiJavaFile file) {
        PsiClass[] classes;
        int lastDotIndex = fqName.lastIndexOf(46);
        String shortName = fqName.substring(lastDotIndex + 1);
        for (PsiClass aClass : classes = file.getClasses()) {
            if (!shortName.equals(aClass.getName())) continue;
            return true;
        }
        return false;
    }

    private static boolean hasExactImportConflict(String fqName, PsiJavaFile file) {
        PsiImportList imports = file.getImportList();
        if (imports == null) {
            return false;
        }
        PsiImportStatement[] importStatements = imports.getImportStatements();
        int lastDotIndex = fqName.lastIndexOf(46);
        String shortName = fqName.substring(lastDotIndex + 1);
        String dottedShortName = '.' + shortName;
        for (PsiImportStatement importStatement : importStatements) {
            if (importStatement.isOnDemand()) continue;
            String importName = importStatement.getQualifiedName();
            if (importName == null) {
                return false;
            }
            if (importName.equals(fqName) || !importName.endsWith(dottedShortName)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasExactImportStaticConflict(String qualifierClass, String memberName, PsiElement context) {
        PsiImportStaticStatement[] importStaticStatements;
        PsiFile file = context.getContainingFile();
        if (!(file instanceof PsiJavaFile)) {
            return false;
        }
        PsiJavaFile javaFile = (PsiJavaFile)file;
        PsiImportList importList = javaFile.getImportList();
        if (importList == null) {
            return false;
        }
        for (PsiImportStaticStatement importStaticStatement : importStaticStatements = importList.getImportStaticStatements()) {
            String qualifierText;
            PsiElement qualifier;
            PsiJavaCodeReferenceElement importReference;
            String name;
            if (importStaticStatement.isOnDemand() || !memberName.equals(name = importStaticStatement.getReferenceName()) || (importReference = importStaticStatement.getImportReference()) == null || (qualifier = importReference.getQualifier()) == null || qualifierClass.equals(qualifierText = qualifier.getText())) continue;
            return true;
        }
        return false;
    }

    public static boolean hasOnDemandImportConflict(@NotNull String fqName, @NotNull PsiJavaFile file) {
        if (fqName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ImportUtils.hasOnDemandImportConflict must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/psiutils/ImportUtils.hasOnDemandImportConflict must not be null");
        }
        return ImportUtils.hasOnDemandImportConflict(fqName, file, false);
    }

    private static boolean hasOnDemandImportConflict(@NotNull String fqName, @NotNull PsiJavaFile file, boolean strict) {
        if (fqName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ImportUtils.hasOnDemandImportConflict must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/psiutils/ImportUtils.hasOnDemandImportConflict must not be null");
        }
        PsiImportList imports = file.getImportList();
        if (imports == null) {
            return false;
        }
        PsiImportStatement[] importStatements = imports.getImportStatements();
        String shortName = ClassUtil.extractClassName((String)fqName);
        String packageName = ClassUtil.extractPackageName((String)fqName);
        for (PsiImportStatement importStatement : importStatements) {
            PsiClass[] classes;
            PsiElement element;
            String packageText;
            PsiJavaCodeReferenceElement importReference;
            if (!importStatement.isOnDemand() || (importReference = importStatement.getImportReference()) == null || (packageText = importReference.getText()).equals(packageName) || (element = importReference.resolve()) == null || !(element instanceof PsiPackage)) continue;
            PsiPackage aPackage = (PsiPackage)element;
            for (PsiClass aClass : classes = aPackage.getClasses()) {
                String className = aClass.getName();
                if (!shortName.equals(className)) continue;
                if (!strict) {
                    return true;
                }
                String qualifiedClassName = aClass.getQualifiedName();
                ClassReferenceVisitor visitor = new ClassReferenceVisitor(qualifiedClassName);
                file.accept((PsiElementVisitor)visitor);
                return visitor.isReferenceFound();
            }
        }
        return ImportUtils.hasJavaLangImportConflict(fqName, file);
    }

    public static boolean hasOnDemandImportStaticConflict(String fqName, String memberName, PsiElement context) {
        return ImportUtils.hasOnDemandImportStaticConflict(fqName, memberName, context, false);
    }

    private static boolean hasOnDemandImportStaticConflict(String fqName, String memberName, PsiElement context, boolean strict) {
        PsiImportStaticStatement[] importStaticStatements;
        PsiFile file = context.getContainingFile();
        if (!(file instanceof PsiJavaFile)) {
            return false;
        }
        PsiJavaFile javaFile = (PsiJavaFile)file;
        PsiImportList importList = javaFile.getImportList();
        if (importList == null) {
            return false;
        }
        for (PsiImportStaticStatement importStaticStatement : importStaticStatements = importList.getImportStaticStatements()) {
            String name;
            PsiClass targetClass;
            if (!importStaticStatement.isOnDemand() || (targetClass = importStaticStatement.resolveTargetClass()) == null || fqName.equals(name = targetClass.getQualifiedName())) continue;
            PsiField field = targetClass.findFieldByName(memberName, true);
            if (field != null && (!strict || ImportUtils.memberReferenced(field, javaFile))) {
                return true;
            }
            PsiMethod[] methods = targetClass.findMethodsByName(memberName, true);
            if (methods.length <= 0 || strict && !ImportUtils.membersReferenced(methods, javaFile)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasDefaultImportConflict(String fqName, PsiJavaFile file) {
        PsiClass[] classes;
        String shortName = ClassUtil.extractClassName((String)fqName);
        String packageName = ClassUtil.extractPackageName((String)fqName);
        String filePackageName = file.getPackageName();
        if (filePackageName.equals(packageName)) {
            return false;
        }
        Project project = file.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiPackage filePackage = psiFacade.findPackage(filePackageName);
        if (filePackage == null) {
            return false;
        }
        for (PsiClass aClass : classes = filePackage.getClasses()) {
            String className = aClass.getName();
            if (!shortName.equals(className)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasJavaLangImportConflict(String fqName, PsiJavaFile file) {
        PsiClass[] classes;
        String shortName = ClassUtil.extractClassName((String)fqName);
        String packageName = ClassUtil.extractPackageName((String)fqName);
        if ("java.lang".equals(packageName)) {
            return false;
        }
        Project project = file.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiPackage javaLangPackage = psiFacade.findPackage("java.lang");
        if (javaLangPackage == null) {
            return false;
        }
        for (PsiClass aClass : classes = javaLangPackage.getClasses()) {
            String className = aClass.getName();
            if (!shortName.equals(className)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsConflictingClass(String fqName, PsiJavaFile file) {
        PsiClass[] classes;
        for (PsiClass aClass : classes = file.getClasses()) {
            if (!ImportUtils.containsConflictingInnerClass(fqName, aClass)) continue;
            return true;
        }
        ClassReferenceVisitor visitor = new ClassReferenceVisitor(fqName);
        file.accept((PsiElementVisitor)visitor);
        return visitor.isReferenceFound();
    }

    private static boolean containsConflictingInnerClass(String fqName, PsiClass aClass) {
        PsiClass[] classes;
        String shortName = ClassUtil.extractClassName((String)fqName);
        if (shortName.equals(aClass.getName()) && !fqName.equals(aClass.getQualifiedName())) {
            return true;
        }
        for (PsiClass innerClass : classes = aClass.getInnerClasses()) {
            if (!ImportUtils.containsConflictingInnerClass(fqName, innerClass)) continue;
            return true;
        }
        return false;
    }

    public static void addStaticImport(@NotNull String qualifierClass, @NotNull String memberName, @NotNull PsiElement context) throws IncorrectOperationException {
        if (qualifierClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ImportUtils.addStaticImport must not be null");
        }
        if (memberName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/psiutils/ImportUtils.addStaticImport must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/siyeh/ig/psiutils/ImportUtils.addStaticImport must not be null");
        }
        PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)context, PsiClass.class);
        if (ClassUtils.isSubclass(containingClass, qualifierClass)) {
            return;
        }
        PsiFile psiFile = context.getContainingFile();
        if (!(psiFile instanceof PsiJavaFile)) {
            return;
        }
        PsiJavaFile javaFile = (PsiJavaFile)psiFile;
        PsiImportList importList = javaFile.getImportList();
        if (importList == null) {
            return;
        }
        PsiImportStatementBase existingImportStatement = importList.findSingleImportStatement(memberName);
        if (existingImportStatement != null) {
            return;
        }
        PsiImportStaticStatement onDemandImportStatement = ImportUtils.findOnDemandImportStaticStatement(importList, qualifierClass);
        if (onDemandImportStatement != null && !ImportUtils.hasOnDemandImportStaticConflict(qualifierClass, memberName, context)) {
            return;
        }
        Project project = context.getProject();
        GlobalSearchScope scope = context.getResolveScope();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiClass aClass = psiFacade.findClass(qualifierClass, scope);
        if (aClass == null) {
            return;
        }
        String qualifiedName = aClass.getQualifiedName();
        if (qualifiedName == null) {
            return;
        }
        List<PsiImportStaticStatement> imports = ImportUtils.getMatchingImports(importList, qualifiedName);
        CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getSettings((Project)project);
        PsiElementFactory elementFactory = psiFacade.getElementFactory();
        if (imports.size() < codeStyleSettings.NAMES_COUNT_TO_USE_IMPORT_ON_DEMAND) {
            importList.add((PsiElement)elementFactory.createImportStaticStatement(aClass, memberName));
        } else {
            for (PsiImportStaticStatement importStatement : imports) {
                importStatement.delete();
            }
            importList.add((PsiElement)elementFactory.createImportStaticStatement(aClass, "*"));
        }
    }

    private static PsiImportStaticStatement findOnDemandImportStaticStatement(PsiImportList importList, String qualifierClass) {
        PsiImportStaticStatement[] importStaticStatements;
        for (PsiImportStaticStatement importStaticStatement : importStaticStatements = importList.getImportStaticStatements()) {
            String text;
            PsiJavaCodeReferenceElement importReference;
            if (!importStaticStatement.isOnDemand() || (importReference = importStaticStatement.getImportReference()) == null || !qualifierClass.equals(text = importReference.getText())) continue;
            return importStaticStatement;
        }
        return null;
    }

    private static List<PsiImportStaticStatement> getMatchingImports(@NotNull PsiImportList importList, @NotNull String className) {
        if (importList == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/ImportUtils.getMatchingImports must not be null");
        }
        if (className == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/siyeh/ig/psiutils/ImportUtils.getMatchingImports must not be null");
        }
        ArrayList<PsiImportStaticStatement> imports = new ArrayList<PsiImportStaticStatement>();
        for (PsiImportStaticStatement staticStatement : importList.getImportStaticStatements()) {
            PsiClass psiClass = staticStatement.resolveTargetClass();
            if (psiClass == null || !className.equals(psiClass.getQualifiedName())) continue;
            imports.add(staticStatement);
        }
        return imports;
    }

    private static boolean memberReferenced(PsiField field, PsiJavaFile javaFile) {
        MemberReferenceVisitor visitor = new MemberReferenceVisitor(field);
        javaFile.accept((PsiElementVisitor)visitor);
        return visitor.isReferenceFound();
    }

    private static boolean membersReferenced(PsiMethod[] methods, PsiJavaFile javaFile) {
        MemberReferenceVisitor visitor = new MemberReferenceVisitor(methods);
        javaFile.accept((PsiElementVisitor)visitor);
        return visitor.isReferenceFound();
    }

    private static class ClassReferenceVisitor
    extends JavaRecursiveElementVisitor {
        private final String name;
        private final String fullyQualifiedName;
        private boolean referenceFound = false;

        private ClassReferenceVisitor(String fullyQualifiedName) {
            this.name = ClassUtil.extractClassName((String)fullyQualifiedName);
            this.fullyQualifiedName = fullyQualifiedName;
        }

        public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
            super.visitReferenceElement(reference);
            if (this.referenceFound) {
                return;
            }
            String text = reference.getText();
            if (text.indexOf(46) >= 0 || !this.name.equals(text)) {
                return;
            }
            PsiElement element = reference.resolve();
            if (!(element instanceof PsiClass) || element instanceof PsiTypeParameter) {
                return;
            }
            PsiClass aClass = (PsiClass)element;
            String testClassName = aClass.getName();
            String testClassQualifiedName = aClass.getQualifiedName();
            if (testClassQualifiedName == null || testClassName == null || testClassQualifiedName.equals(this.fullyQualifiedName) || !testClassName.equals(this.name)) {
                return;
            }
            this.referenceFound = true;
        }

        public boolean isReferenceFound() {
            return this.referenceFound;
        }
    }

    private static class MemberReferenceVisitor
    extends JavaRecursiveElementVisitor {
        private final PsiMember[] members;
        private boolean referenceFound = false;

        public MemberReferenceVisitor(PsiField field) {
            this.members = new PsiMember[]{field};
        }

        public MemberReferenceVisitor(PsiMethod[] methods) {
            this.members = methods;
        }

        public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
            if (this.referenceFound) {
                return;
            }
            super.visitReferenceElement(reference);
            if (reference.isQualified()) {
                return;
            }
            PsiElement target = reference.resolve();
            for (PsiMember member : this.members) {
                if (!member.equals(target)) continue;
                this.referenceFound = true;
                return;
            }
        }

        public boolean isReferenceFound() {
            return this.referenceFound;
        }
    }
}

