/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Query;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodUtils {
    private MethodUtils() {
    }

    public static boolean isCompareTo(@Nullable PsiMethod method) {
        if (method == null) {
            return false;
        }
        return MethodUtils.methodMatches(method, null, PsiType.INT, "compareTo", PsiType.NULL);
    }

    public static boolean isHashCode(@Nullable PsiMethod method) {
        if (method == null) {
            return false;
        }
        return MethodUtils.methodMatches(method, null, PsiType.INT, "hashCode", new PsiType[0]);
    }

    public static boolean isToString(@Nullable PsiMethod method) {
        if (method == null) {
            return false;
        }
        return MethodUtils.methodMatches(method, null, (PsiType)PsiType.getJavaLangString((PsiManager)method.getManager(), (GlobalSearchScope)method.getResolveScope()), "toString", new PsiType[0]);
    }

    public static boolean isEquals(@Nullable PsiMethod method) {
        if (method == null) {
            return false;
        }
        PsiManager manager = method.getManager();
        Project project = method.getProject();
        PsiClassType objectType = PsiType.getJavaLangObject((PsiManager)manager, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
        return MethodUtils.methodMatches(method, null, PsiType.BOOLEAN, "equals", new PsiType[]{objectType});
    }

    public static boolean methodMatches(@NotNull PsiMethod method, @NonNls @Nullable String containingClassName, @Nullable PsiType returnType, @Nullable Pattern methodNamePattern, PsiType ... parameterTypes) {
        PsiType methodReturnType;
        String name;
        Matcher matcher;
        if (method == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/MethodUtils.methodMatches must not be null");
        }
        if (methodNamePattern != null && !(matcher = methodNamePattern.matcher(name = method.getName())).matches()) {
            return false;
        }
        if (parameterTypes != null) {
            PsiParameterList parameterList = method.getParameterList();
            if (parameterList.getParametersCount() != parameterTypes.length) {
                return false;
            }
            PsiParameter[] parameters = parameterList.getParameters();
            for (int i = 0; i < parameters.length; ++i) {
                PsiParameter parameter = parameters[i];
                PsiType type = parameter.getType();
                PsiType parameterType = parameterTypes[i];
                if (PsiType.NULL.equals(parameterType) || parameterType == null || EquivalenceChecker.typesAreEquivalent(type, parameterType)) continue;
                return false;
            }
        }
        if (returnType != null && !EquivalenceChecker.typesAreEquivalent(returnType, methodReturnType = method.getReturnType())) {
            return false;
        }
        if (containingClassName != null) {
            PsiClass containingClass = method.getContainingClass();
            return ClassUtils.isSubclass(containingClass, containingClassName);
        }
        return true;
    }

    public static boolean methodMatches(@NotNull PsiMethod method, @NonNls @Nullable String containingClassName, @Nullable PsiType returnType, @NonNls @Nullable String methodName, PsiType ... parameterTypes) {
        PsiType methodReturnType;
        if (method == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/MethodUtils.methodMatches must not be null");
        }
        String name = method.getName();
        if (methodName != null && !methodName.equals(name)) {
            return false;
        }
        if (parameterTypes != null) {
            PsiParameterList parameterList = method.getParameterList();
            if (parameterList.getParametersCount() != parameterTypes.length) {
                return false;
            }
            PsiParameter[] parameters = parameterList.getParameters();
            for (int i = 0; i < parameters.length; ++i) {
                PsiParameter parameter = parameters[i];
                PsiType type = parameter.getType();
                PsiType parameterType = parameterTypes[i];
                if (PsiType.NULL.equals(parameterType) || parameterType == null || EquivalenceChecker.typesAreEquivalent(type, parameterType)) continue;
                return false;
            }
        }
        if (returnType != null && !EquivalenceChecker.typesAreEquivalent(returnType, methodReturnType = method.getReturnType())) {
            return false;
        }
        if (containingClassName != null) {
            PsiClass containingClass = method.getContainingClass();
            return ClassUtils.isSubclass(containingClass, containingClassName);
        }
        return true;
    }

    public static boolean simpleMethodMatches(@NotNull PsiMethod method, @NonNls @Nullable String containingClassName, @NonNls @Nullable String returnTypeString, @NonNls @Nullable String methodName, String ... parameterTypeStrings) {
        if (method == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/MethodUtils.simpleMethodMatches must not be null");
        }
        PsiManager manager = method.getManager();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        try {
            if (parameterTypeStrings != null) {
                PsiType[] parameterTypes = new PsiType[parameterTypeStrings.length];
                for (int i = 0; i < parameterTypeStrings.length; ++i) {
                    String parameterTypeString = parameterTypeStrings[i];
                    parameterTypes[i] = factory.createTypeFromText(parameterTypeString, (PsiElement)method);
                }
                if (returnTypeString != null) {
                    PsiType returnType = factory.createTypeFromText(returnTypeString, (PsiElement)method);
                    return MethodUtils.methodMatches(method, containingClassName, returnType, methodName, parameterTypes);
                }
                return MethodUtils.methodMatches(method, containingClassName, null, methodName, parameterTypes);
            }
            if (returnTypeString != null) {
                PsiType returnType = factory.createTypeFromText(returnTypeString, (PsiElement)method);
                return MethodUtils.methodMatches(method, containingClassName, returnType, methodName, new PsiType[0]);
            }
            return MethodUtils.methodMatches(method, containingClassName, null, methodName, new PsiType[0]);
        }
        catch (IncorrectOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isOverridden(PsiMethod method) {
        Query overridingMethodQuery = OverridingMethodsSearch.search((PsiMethod)method);
        PsiMethod result = (PsiMethod)overridingMethodQuery.findFirst();
        return result != null;
    }

    public static boolean isOverriddenInHierarchy(PsiMethod method, PsiClass baseClass) {
        Query search = ClassInheritorsSearch.search((PsiClass)baseClass, (SearchScope)baseClass.getUseScope(), (boolean)true, (boolean)true, (boolean)true);
        for (PsiClass inheritor : search) {
            PsiMethod overridingMethod = inheritor.findMethodBySignature(method, false);
            if (overridingMethod == null) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmpty(PsiMethod method) {
        PsiCodeBlock body = method.getBody();
        if (body == null) {
            return true;
        }
        PsiStatement[] statements = body.getStatements();
        return statements.length == 0;
    }

    @Nullable
    public static PsiField getFieldOfGetter(PsiMethod method) {
        if (method == null) {
            return null;
        }
        PsiParameterList parameterList = method.getParameterList();
        if (parameterList.getParametersCount() != 0) {
            return null;
        }
        String name = method.getName();
        if (!name.startsWith("get") && !name.startsWith("is")) {
            return null;
        }
        if (method.hasModifierProperty("synchronized")) {
            return null;
        }
        PsiCodeBlock body = method.getBody();
        if (body == null) {
            return null;
        }
        PsiStatement[] statements = body.getStatements();
        if (statements.length != 1) {
            return null;
        }
        PsiStatement statement = statements[0];
        if (!(statement instanceof PsiReturnStatement)) {
            return null;
        }
        PsiReturnStatement returnStatement = (PsiReturnStatement)statement;
        PsiExpression value = returnStatement.getReturnValue();
        if (value == null) {
            return null;
        }
        if (!(value instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiReferenceExpression reference = (PsiReferenceExpression)value;
        PsiExpression qualifier = reference.getQualifierExpression();
        if (qualifier != null && !(qualifier instanceof PsiThisExpression) && !(qualifier instanceof PsiSuperExpression)) {
            return null;
        }
        PsiElement referent = reference.resolve();
        if (referent == null) {
            return null;
        }
        if (!(referent instanceof PsiField)) {
            return null;
        }
        PsiField field = (PsiField)referent;
        PsiType fieldType = field.getType();
        PsiType returnType = method.getReturnType();
        if (returnType == null) {
            return null;
        }
        if (!fieldType.equalsToText(returnType.getCanonicalText())) {
            return null;
        }
        PsiClass fieldContainingClass = field.getContainingClass();
        PsiClass methodContainingClass = method.getContainingClass();
        if (InheritanceUtil.isCorrectDescendant((PsiClass)methodContainingClass, (PsiClass)fieldContainingClass, (boolean)true)) {
            return field;
        }
        return null;
    }

    public static boolean isSimpleGetter(PsiMethod method) {
        return MethodUtils.getFieldOfGetter(method) != null;
    }

    @Nullable
    public static PsiField getFieldOfSetter(PsiMethod method) {
        PsiType parameterType;
        if (method == null) {
            return null;
        }
        PsiParameterList parameterList = method.getParameterList();
        if (parameterList.getParametersCount() != 1) {
            return null;
        }
        String name = method.getName();
        if (!name.startsWith("set")) {
            return null;
        }
        if (method.hasModifierProperty("synchronized")) {
            return null;
        }
        PsiCodeBlock body = method.getBody();
        if (body == null) {
            return null;
        }
        PsiStatement[] statements = body.getStatements();
        if (statements.length != 1) {
            return null;
        }
        PsiStatement statement = statements[0];
        if (!(statement instanceof PsiExpressionStatement)) {
            return null;
        }
        PsiExpressionStatement possibleAssignmentStatement = (PsiExpressionStatement)statement;
        PsiExpression possibleAssignment = possibleAssignmentStatement.getExpression();
        if (!(possibleAssignment instanceof PsiAssignmentExpression)) {
            return null;
        }
        PsiAssignmentExpression assignment = (PsiAssignmentExpression)possibleAssignment;
        PsiJavaToken sign = assignment.getOperationSign();
        if (!JavaTokenType.EQ.equals(sign.getTokenType())) {
            return null;
        }
        PsiExpression lhs = assignment.getLExpression();
        if (!(lhs instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiReferenceExpression reference = (PsiReferenceExpression)lhs;
        PsiExpression qualifier = reference.getQualifierExpression();
        if (qualifier != null && !(qualifier instanceof PsiThisExpression) && !(qualifier instanceof PsiSuperExpression)) {
            return null;
        }
        PsiElement referent = reference.resolve();
        if (referent == null) {
            return null;
        }
        if (!(referent instanceof PsiField)) {
            return null;
        }
        PsiField field = (PsiField)referent;
        PsiClass fieldContainingClass = field.getContainingClass();
        PsiClass methodContainingClass = method.getContainingClass();
        if (!InheritanceUtil.isCorrectDescendant((PsiClass)methodContainingClass, (PsiClass)fieldContainingClass, (boolean)true)) {
            return null;
        }
        PsiExpression rhs = assignment.getRExpression();
        if (!(rhs instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiReferenceExpression rReference = (PsiReferenceExpression)rhs;
        PsiExpression rQualifier = rReference.getQualifierExpression();
        if (rQualifier != null) {
            return null;
        }
        PsiElement rReferent = rReference.resolve();
        if (rReferent == null) {
            return null;
        }
        if (!(rReferent instanceof PsiParameter)) {
            return null;
        }
        PsiType fieldType = field.getType();
        if (fieldType.equalsToText((parameterType = ((PsiVariable)rReferent).getType()).getCanonicalText())) {
            return field;
        }
        return null;
    }

    public static boolean isSimpleSetter(PsiMethod method) {
        return MethodUtils.getFieldOfSetter(method) != null;
    }
}

