/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestUtils {
    private TestUtils() {
    }

    public static boolean isTest(@Nullable PsiClass aClass) {
        if (aClass == null) {
            return false;
        }
        PsiManager manager = aClass.getManager();
        PsiFile file = aClass.getContainingFile();
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return true;
        }
        Project project = manager.getProject();
        ProjectRootManager rootManager = ProjectRootManager.getInstance((Project)project);
        ProjectFileIndex fileIndex = rootManager.getFileIndex();
        return fileIndex.isInTestSourceContent(virtualFile);
    }

    public static boolean isPartOfJUnitTestMethod(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/TestUtils.isPartOfJUnitTestMethod must not be null");
        }
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
        return method != null && TestUtils.isJUnitTestMethod(method);
    }

    public static boolean isJUnit4BeforeOrAfterMethod(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/TestUtils.isJUnit4BeforeOrAfterMethod must not be null");
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"org.junit.Before", (boolean)true) || AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"org.junit.After", (boolean)true);
    }

    public static boolean isJUnit4BeforeClassOrAfterClassMethod(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/TestUtils.isJUnit4BeforeClassOrAfterClassMethod must not be null");
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"org.junit.BeforeClass", (boolean)true) || AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"org.junit.AfterClass", (boolean)true);
    }

    public static boolean isJUnitTestMethod(@Nullable PsiMethod method) {
        if (method == null) {
            return false;
        }
        if (TestUtils.isJUnit4TestMethod(method)) {
            return true;
        }
        String methodName = method.getName();
        String test = "test";
        if (!methodName.startsWith("test")) {
            return false;
        }
        if (method.hasModifierProperty("abstract") || !method.hasModifierProperty("public")) {
            return false;
        }
        PsiType returnType = method.getReturnType();
        if (returnType == null) {
            return false;
        }
        if (!returnType.equals(PsiType.VOID)) {
            return false;
        }
        PsiParameterList parameterList = method.getParameterList();
        if (parameterList.getParametersCount() != 0) {
            return false;
        }
        PsiClass targetClass = method.getContainingClass();
        return TestUtils.isJUnitTestClass(targetClass);
    }

    public static boolean isJUnit4TestMethod(@Nullable PsiMethod method) {
        return method != null && AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"org.junit.Test", (boolean)true);
    }

    public static boolean isJUnitTestClass(@Nullable PsiClass targetClass) {
        return targetClass != null && ClassUtils.isSubclass(targetClass, "junit.framework.TestCase");
    }
}

