/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.NotNull;

public class VariableAssignedVisitor
extends JavaRecursiveElementVisitor {
    @NotNull
    private final PsiVariable variable;
    private final boolean recurseIntoClasses;
    private final boolean checkUnaryExpressions;
    private boolean assigned;

    public VariableAssignedVisitor(@NotNull PsiVariable variable, boolean recurseIntoClasses) {
        if (variable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/VariableAssignedVisitor.<init> must not be null");
        }
        this.assigned = false;
        this.variable = variable;
        PsiType type = variable.getType();
        this.checkUnaryExpressions = TypeConversionUtil.isNumericType((PsiType)type);
        this.recurseIntoClasses = recurseIntoClasses;
    }

    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/VariableAssignedVisitor.visitElement must not be null");
        }
        if (this.assigned) {
            return;
        }
        super.visitElement(element);
    }

    public void visitAssignmentExpression(@NotNull PsiAssignmentExpression assignment) {
        if (assignment == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/VariableAssignedVisitor.visitAssignmentExpression must not be null");
        }
        if (this.assigned) {
            return;
        }
        super.visitAssignmentExpression(assignment);
        PsiExpression arg = assignment.getLExpression();
        if (VariableAccessUtils.mayEvaluateToVariable(arg, this.variable)) {
            this.assigned = true;
        }
    }

    public void visitClass(PsiClass aClass) {
        if (!this.recurseIntoClasses) {
            return;
        }
        if (this.assigned) {
            return;
        }
        super.visitClass(aClass);
    }

    public void visitPrefixExpression(@NotNull PsiPrefixExpression prefixExpression) {
        if (prefixExpression == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/VariableAssignedVisitor.visitPrefixExpression must not be null");
        }
        if (this.assigned) {
            return;
        }
        if (!this.checkUnaryExpressions) {
            return;
        }
        super.visitPrefixExpression(prefixExpression);
        PsiJavaToken operationSign = prefixExpression.getOperationSign();
        IElementType tokenType = operationSign.getTokenType();
        if (!tokenType.equals(JavaTokenType.PLUSPLUS) && !tokenType.equals(JavaTokenType.MINUSMINUS)) {
            return;
        }
        PsiExpression operand = prefixExpression.getOperand();
        if (VariableAccessUtils.mayEvaluateToVariable(operand, this.variable)) {
            this.assigned = true;
        }
    }

    public void visitPostfixExpression(@NotNull PsiPostfixExpression postfixExpression) {
        if (postfixExpression == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/VariableAssignedVisitor.visitPostfixExpression must not be null");
        }
        if (this.assigned) {
            return;
        }
        if (!this.checkUnaryExpressions) {
            return;
        }
        super.visitPostfixExpression(postfixExpression);
        PsiJavaToken operationSign = postfixExpression.getOperationSign();
        IElementType tokenType = operationSign.getTokenType();
        if (!tokenType.equals(JavaTokenType.PLUSPLUS) && !tokenType.equals(JavaTokenType.MINUSMINUS)) {
            return;
        }
        PsiExpression operand = postfixExpression.getOperand();
        if (VariableAccessUtils.mayEvaluateToVariable(operand, this.variable)) {
            this.assigned = true;
        }
    }

    public boolean isAssigned() {
        return this.assigned;
    }
}

