/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiVariable;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.NotNull;

public class VariableReturnedVisitor
extends JavaRecursiveElementVisitor {
    private boolean returned;
    @NotNull
    private final PsiVariable variable;

    public VariableReturnedVisitor(@NotNull PsiVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/VariableReturnedVisitor.<init> must not be null");
        }
        this.returned = false;
        this.variable = variable;
    }

    public void visitReturnStatement(@NotNull PsiReturnStatement returnStatement) {
        if (returnStatement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/psiutils/VariableReturnedVisitor.visitReturnStatement must not be null");
        }
        if (this.returned) {
            return;
        }
        super.visitReturnStatement(returnStatement);
        PsiExpression returnValue = returnStatement.getReturnValue();
        if (VariableAccessUtils.mayEvaluateToVariable(returnValue, this.variable)) {
            this.returned = true;
        }
    }

    public boolean isReturned() {
        return this.returned;
    }
}

