/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.resources;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.resources.ResourceInspection;
import org.jetbrains.annotations.NotNull;

public class HibernateResourceInspection
extends ResourceInspection {
    @NotNull
    public String getID() {
        if ("HibernateResourceOpenedButNotSafelyClosed" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/resources/HibernateResourceInspection.getID must not return null");
        }
        return "HibernateResourceOpenedButNotSafelyClosed";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("hibernate.resource.opened.not.closed.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/resources/HibernateResourceInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiExpression expression = (PsiExpression)infos[0];
        PsiType type = expression.getType();
        assert (type != null);
        String text = type.getPresentableText();
        String string = InspectionGadgetsBundle.message("hibernate.resource.opened.not.closed.problem.descriptor", text);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/resources/HibernateResourceInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new HibernateResourceVisitor();
    }

    private static class HibernateResourceVisitor
    extends BaseInspectionVisitor {
        private HibernateResourceVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/resources/HibernateResourceInspection$HibernateResourceVisitor.visitMethodCallExpression must not be null");
            }
            super.visitMethodCallExpression(expression);
            if (!HibernateResourceVisitor.isHibernateFactoryMethod(expression)) {
                return;
            }
            PsiElement parent = ResourceInspection.getExpressionParent((PsiExpression)expression);
            if (parent instanceof PsiReturnStatement) {
                return;
            }
            PsiVariable boundVariable = ResourceInspection.getVariable(parent);
            if (ResourceInspection.isSafelyClosed(boundVariable, (PsiExpression)expression)) {
                return;
            }
            if (ResourceInspection.isResourceEscapedFromMethod(boundVariable, (PsiElement)expression)) {
                return;
            }
            this.registerError((PsiElement)expression, expression);
        }

        private static boolean isHibernateFactoryMethod(PsiMethodCallExpression expression) {
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"openSession".equals(methodName)) {
                return false;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return false;
            }
            return TypeUtils.expressionHasTypeOrSubtype(qualifier, "org.hibernate.SessionFactory");
        }
    }
}

