/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.SerializationUtils;
import org.jetbrains.annotations.NotNull;

public class NonSerializableObjectPassedToObjectStreamInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("non.serializable.object.passed.to.object.stream.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/serialization/NonSerializableObjectPassedToObjectStreamInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("non.serializable.object.passed.to.object.stream.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/serialization/NonSerializableObjectPassedToObjectStreamInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NonSerializableObjectPassedToObjectStreamVisitor();
    }

    private static class NonSerializableObjectPassedToObjectStreamVisitor
    extends BaseInspectionVisitor {
        private NonSerializableObjectPassedToObjectStreamVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression methodCallExpression) {
            super.visitMethodCallExpression(methodCallExpression);
            if (!MethodCallUtils.isSimpleCallToMethod(methodCallExpression, "java.io.ObjectOutputStream", PsiType.VOID, "writeObject", "java.lang.Object")) {
                return;
            }
            PsiExpressionList argList = methodCallExpression.getArgumentList();
            PsiExpression[] args = argList.getExpressions();
            if (args.length != 1) {
                return;
            }
            PsiType argType = args[0].getType();
            if (argType == null) {
                return;
            }
            if (SerializationUtils.isProbablySerializable(argType)) {
                return;
            }
            this.registerError((PsiElement)args[0], new Object[0]);
        }
    }
}

