/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.tree.IElementType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class ChainedEqualityInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("ChainedEqualityComparisons" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/ChainedEqualityInspection.getID must not return null");
        }
        return "ChainedEqualityComparisons";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("chained.equality.comparisons.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/ChainedEqualityInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("chained.equality.comparisons.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/ChainedEqualityInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ChainedEqualityVisitor();
    }

    private static class ChainedEqualityVisitor
    extends BaseInspectionVisitor {
        private ChainedEqualityVisitor() {
        }

        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/style/ChainedEqualityInspection$ChainedEqualityVisitor.visitBinaryExpression must not be null");
            }
            super.visitBinaryExpression(expression);
            if (expression.getROperand() == null) {
                return;
            }
            if (!ChainedEqualityVisitor.isEqualityComparison(expression)) {
                return;
            }
            PsiExpression lhs = expression.getLOperand();
            if (!(lhs instanceof PsiBinaryExpression)) {
                return;
            }
            if (!ChainedEqualityVisitor.isEqualityComparison((PsiBinaryExpression)lhs)) {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }

        private static boolean isEqualityComparison(@NotNull PsiBinaryExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/style/ChainedEqualityInspection$ChainedEqualityVisitor.isEqualityComparison must not be null");
            }
            PsiJavaToken sign = expression.getOperationSign();
            IElementType tokenType = sign.getTokenType();
            return tokenType.equals(JavaTokenType.EQEQ) || tokenType.equals(JavaTokenType.NE);
        }
    }
}

