/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.telemetry;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsPlugin;
import com.siyeh.ig.telemetry.InspectionGadgetsTelemetry;
import com.siyeh.ig.telemetry.ResetTelemetryAction;
import com.siyeh.ig.telemetry.TelemetryDisplay;
import com.siyeh.ig.telemetry.TelemetryDisplayImpl;
import com.siyeh.ig.telemetry.TelemetryToolWindow;
import com.siyeh.ig.telemetry.UpdateTelemetryViewAction;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class TelemetryToolWindowImpl
implements TelemetryToolWindow {
    private final TelemetryDisplay telemetryDisplay;
    private final JPanel myContentPanel;
    private ToolWindow myToolWindow = null;

    public TelemetryToolWindowImpl() {
        Application application = ApplicationManager.getApplication();
        InspectionGadgetsPlugin plugin = (InspectionGadgetsPlugin)application.getComponent(InspectionGadgetsPlugin.class);
        InspectionGadgetsTelemetry telemetry = plugin.getTelemetry();
        this.telemetryDisplay = new TelemetryDisplayImpl(telemetry);
        DefaultActionGroup toolbarGroup = new DefaultActionGroup();
        toolbarGroup.add((AnAction)new UpdateTelemetryViewAction(this.telemetryDisplay));
        toolbarGroup.add((AnAction)new ResetTelemetryAction(telemetry, this.telemetryDisplay));
        ActionManager actionManager = ActionManager.getInstance();
        ActionToolbar toolbar = actionManager.createActionToolbar("IG Telemetry", (ActionGroup)toolbarGroup, true);
        this.myContentPanel = new JPanel(new BorderLayout());
        this.myContentPanel.setBackground(Color.gray);
        JComponent toolbarComponent = toolbar.getComponent();
        this.myContentPanel.add((Component)toolbarComponent, "North");
        JComponent displayContentPane = this.telemetryDisplay.getContentPane();
        this.myContentPanel.add((Component)displayContentPane, "Center");
    }

    @Override
    public void register(Project project) {
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project);
        this.myToolWindow = toolWindowManager.registerToolWindow("IG Telemetry", (JComponent)this.myContentPanel, ToolWindowAnchor.LEFT);
        this.myToolWindow.setTitle(InspectionGadgetsBundle.message("telemetry.toolwindow.title", new Object[0]));
        this.myToolWindow.setAvailable(true, null);
    }

    @Override
    public void show() {
        this.myToolWindow.setAvailable(true, null);
        this.telemetryDisplay.update();
        this.myToolWindow.show(null);
    }

    @Override
    public void close() {
        this.myToolWindow.hide(null);
        this.myToolWindow.setAvailable(false, null);
    }

    @Override
    public void unregister(Project project) {
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project);
        toolWindowManager.unregisterToolWindow("IG Telemetry");
    }
}

