/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiSynchronizedStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class SynchronizeOnLockInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("SynchroniziationOnLockObject" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/threading/SynchronizeOnLockInspection.getID must not return null");
        }
        return "SynchroniziationOnLockObject";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("synchronize.on.lock.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/threading/SynchronizeOnLockInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String type = (String)infos[0];
        String string = InspectionGadgetsBundle.message("synchronize.on.lock.problem.descriptor", type);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/threading/SynchronizeOnLockInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SynchronizeOnLockVisitor();
    }

    private static class SynchronizeOnLockVisitor
    extends BaseInspectionVisitor {
        private SynchronizeOnLockVisitor() {
        }

        public void visitSynchronizedStatement(@NotNull PsiSynchronizedStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/threading/SynchronizeOnLockInspection$SynchronizeOnLockVisitor.visitSynchronizedStatement must not be null");
            }
            super.visitSynchronizedStatement(statement);
            PsiExpression lockExpression = statement.getLockExpression();
            if (lockExpression == null) {
                return;
            }
            String type = TypeUtils.expressionHasTypeOrSubtype(lockExpression, "java.util.concurrent.locks.Lock", "java.util.concurrent.locks.ReadWriteLock");
            if (type == null) {
                return;
            }
            this.registerError((PsiElement)lockExpression, type);
        }
    }
}

