/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.visibility;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import com.siyeh.ig.psiutils.ClassUtils;
import java.util.HashSet;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class FieldHidesSuperclassFieldInspection
extends BaseInspection {
    public boolean m_ignoreInvisibleFields = true;

    @NotNull
    public String getID() {
        if ("FieldNameHidesFieldInSuperclass" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/visibility/FieldHidesSuperclassFieldInspection.getID must not return null");
        }
        return "FieldNameHidesFieldInSuperclass";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("field.name.hides.in.superclass.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/visibility/FieldHidesSuperclassFieldInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new RenameFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("field.name.hides.in.superclass.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/visibility/FieldHidesSuperclassFieldInspection.buildErrorString must not return null");
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("field.name.hides.in.superclass.ignore.option", new Object[0]), (InspectionProfileEntry)this, "m_ignoreInvisibleFields");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new FieldHidesSuperclassFieldVisitor();
    }

    private class FieldHidesSuperclassFieldVisitor
    extends BaseInspectionVisitor {
        private FieldHidesSuperclassFieldVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/visibility/FieldHidesSuperclassFieldInspection$FieldHidesSuperclassFieldVisitor.visitField must not be null");
            }
            PsiClass aClass = field.getContainingClass();
            if (aClass == null) {
                return;
            }
            String fieldName = field.getName();
            if ("serialVersionUID".equals(fieldName)) {
                return;
            }
            HashSet<PsiClass> visitedClasses = new HashSet<PsiClass>();
            for (PsiClass ancestorClass = aClass.getSuperClass(); ancestorClass != null; ancestorClass = ancestorClass.getSuperClass()) {
                if (!visitedClasses.add(ancestorClass)) {
                    return;
                }
                PsiField ancestorField = ancestorClass.findFieldByName(fieldName, false);
                if (ancestorField == null || FieldHidesSuperclassFieldInspection.this.m_ignoreInvisibleFields && !ClassUtils.isFieldVisible(ancestorField, aClass)) continue;
                this.registerFieldError(field, new Object[0]);
                return;
            }
        }
    }
}

