/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions.impl;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.AreaPicoContainer;
import com.intellij.openapi.extensions.DefaultPluginDescriptor;
import com.intellij.openapi.extensions.EPAvailabilityListenerExtension;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointAvailabilityListener;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.LogProvider;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.extensions.impl.AreaPicoContainerImpl;
import com.intellij.openapi.extensions.impl.ExtensionComponentAdapter;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.extensions.impl.UndefinedPluginDescriptor;
import com.intellij.util.containers.ConcurrentHashMap;
import com.intellij.util.containers.MultiMap;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jetbrains.annotations.NotNull;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.ConstructorInjectionComponentAdapter;
import org.picocontainer.defaults.DefaultPicoContainer;

public class ExtensionsAreaImpl
implements ExtensionsArea {
    private final LogProvider myLogger;
    private static final String ATTRIBUTE_AREA = "area";
    private static final Map<String, String> ourDefaultEPs = new HashMap<String, String>();
    private static final boolean DEBUG_REGISTRATION = true;
    private AreaPicoContainerImpl myPicoContainer;
    private Throwable myCreationTrace = null;
    private final Map<String, ExtensionPointImpl> myExtensionPoints = new ConcurrentHashMap();
    private final Map<String, Throwable> myEPTraces = new HashMap<String, Throwable>();
    private final MultiMap<String, ExtensionPointAvailabilityListener> myAvailabilityListeners = new MultiMap();
    private final List<Runnable> mySuspendedListenerActions = new ArrayList<Runnable>();
    private boolean myAvailabilityNotificationsActive = true;
    private final AreaInstance myAreaInstance;
    private final String myAreaClass;
    private final Map<Element, ExtensionComponentAdapter> myExtensionElement2extension = new HashMap<Element, ExtensionComponentAdapter>();
    private final Map<String, DefaultPicoContainer> myPluginName2picoContainer = new HashMap<String, DefaultPicoContainer>();

    public ExtensionsAreaImpl(String areaClass, AreaInstance areaInstance, PicoContainer parentPicoContainer, LogProvider logger) {
        this.myCreationTrace = new Throwable("Area creation trace");
        this.myAreaClass = areaClass;
        this.myAreaInstance = areaInstance;
        this.myPicoContainer = new AreaPicoContainerImpl(parentPicoContainer, areaInstance);
        this.myLogger = logger;
        this.initialize();
    }

    public ExtensionsAreaImpl(MutablePicoContainer picoContainer, LogProvider logger) {
        this(null, null, (PicoContainer)picoContainer, logger);
    }

    public final void notifyAreaReplaced() {
        for (ExtensionPointImpl point : this.myExtensionPoints.values()) {
            point.notifyAreaReplaced(this);
        }
    }

    @Override
    public AreaPicoContainer getPicoContainer() {
        return this.myPicoContainer;
    }

    MutablePicoContainer getMutablePicoContainer() {
        return this.myPicoContainer;
    }

    @Override
    public String getAreaClass() {
        return this.myAreaClass;
    }

    @Override
    public void registerExtensionPoint(String pluginName, Element extensionPointElement) {
        this.registerExtensionPoint(new DefaultPluginDescriptor(PluginId.getId(pluginName)), extensionPointElement);
    }

    @Override
    public void registerExtensionPoint(PluginDescriptor pluginDescriptor, Element extensionPointElement) {
        String className;
        assert (pluginDescriptor.getPluginId() != null);
        String epName = extensionPointElement.getAttributeValue("qualifiedName");
        if (epName == null) {
            epName = pluginDescriptor.getPluginId().getIdString() + '.' + extensionPointElement.getAttributeValue("name");
        }
        if ((className = extensionPointElement.getAttributeValue("beanClass")) == null) {
            className = extensionPointElement.getAttributeValue("interface");
        }
        if (className == null) {
            throw new RuntimeException("No class specified for extension point: " + epName);
        }
        this.registerExtensionPoint(epName, className, pluginDescriptor);
    }

    @Override
    public void registerExtension(String pluginName, Element extensionElement) {
        this.registerExtension(new DefaultPluginDescriptor(PluginId.getId(pluginName)), extensionElement);
    }

    @Override
    public void registerExtension(PluginDescriptor pluginDescriptor, Element extensionElement) {
        ExtensionComponentAdapter adapter;
        PluginId pluginId = pluginDescriptor.getPluginId();
        String epName = ExtensionsAreaImpl.extractEPName(extensionElement);
        String implClass = extensionElement.getAttributeValue("implementation");
        if (implClass != null) {
            adapter = new ExtensionComponentAdapter(implClass, extensionElement, this.getPluginContainer(pluginId.getIdString()), pluginDescriptor, ExtensionsAreaImpl.shouldDeserializeInstance(extensionElement));
        } else {
            ExtensionPoint extensionPoint = this.getExtensionPoint(epName);
            adapter = new ExtensionComponentAdapter(extensionPoint.getBeanClassName(), extensionElement, this.getPluginContainer(pluginId.getIdString()), pluginDescriptor, true);
        }
        this.myExtensionElement2extension.put(extensionElement, adapter);
        this.internalGetPluginContainer().registerComponent((ComponentAdapter)adapter);
        ((ExtensionPointImpl)this.getExtensionPoint(epName)).registerExtensionAdapter(adapter);
    }

    private static boolean shouldDeserializeInstance(Element extensionElement) {
        if (!extensionElement.getContent().isEmpty()) {
            return true;
        }
        for (Attribute attribute : extensionElement.getAttributes()) {
            String name = attribute.getName();
            if ("implementation".equals(name) || "id".equals(name) || "order".equals(name)) continue;
            return true;
        }
        return false;
    }

    private static String extractEPName(Element extensionElement) {
        String epName = extensionElement.getAttributeValue("point");
        if (epName == null) {
            String ns;
            Element parentElement = extensionElement.getParentElement();
            String string = ns = parentElement != null ? parentElement.getAttributeValue("defaultExtensionNs") : null;
            if (ns != null) {
                epName = ns + '.' + extensionElement.getName();
            } else {
                Namespace namespace = extensionElement.getNamespace();
                epName = namespace.getURI() + '.' + extensionElement.getName();
            }
        }
        return epName;
    }

    @Override
    public PicoContainer getPluginContainer(String pluginName) {
        return this.internalGetPluginContainer();
    }

    private MutablePicoContainer internalGetPluginContainer() {
        return this.myPicoContainer;
    }

    private void disposePluginContainer(String pluginName) {
        DefaultPicoContainer pluginContainer = this.myPluginName2picoContainer.remove(pluginName);
        if (pluginContainer != null) {
            this.myPicoContainer.removeChildContainer((PicoContainer)pluginContainer);
        }
    }

    @Override
    public void unregisterExtensionPoint(String pluginName, Element extensionPointElement) {
        assert (pluginName != null);
        String epName = pluginName + '.' + extensionPointElement.getAttributeValue("name");
        this.unregisterExtensionPoint(epName);
    }

    @Override
    public void unregisterExtension(String pluginName, Element extensionElement) {
        String epName = ExtensionsAreaImpl.extractEPName(extensionElement);
        if (!this.myExtensionElement2extension.containsKey(extensionElement)) {
            XMLOutputter xmlOutputter = new XMLOutputter();
            Format format = Format.getCompactFormat().setIndent("  ").setTextMode(Format.TextMode.NORMALIZE);
            xmlOutputter.setFormat(format);
            StringWriter stringWriter = new StringWriter();
            try {
                xmlOutputter.output(extensionElement, (Writer)stringWriter);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.myLogger.warn(stringWriter.toString());
            throw new IllegalArgumentException("Trying to unregister extension element that was never registered");
        }
        ExtensionComponentAdapter adapter = this.myExtensionElement2extension.remove(extensionElement);
        if (adapter == null) {
            return;
        }
        if (((ExtensionPointImpl)this.getExtensionPoint(epName)).unregisterComponentAdapter(adapter)) {
            MutablePicoContainer pluginContainer = this.internalGetPluginContainer();
            pluginContainer.unregisterComponent(adapter.getComponentKey());
            if (pluginContainer.getComponentAdapters().isEmpty()) {
                this.disposePluginContainer(pluginName);
            }
        }
    }

    private void initialize() {
        for (Map.Entry<String, String> entry : ourDefaultEPs.entrySet()) {
            String epName = entry.getKey();
            this.registerExtensionPoint(epName, entry.getValue());
        }
        ((ExtensionPointImpl)this.getExtensionPoint("com.intellij.openapi.extensions.epAvailabilityListener")).addExtensionPointListener(new ExtensionPointListener(){

            public void extensionRemoved(Object extension, PluginDescriptor pluginDescriptor) {
                EPAvailabilityListenerExtension epListenerExtension = (EPAvailabilityListenerExtension)extension;
                Collection listeners = ExtensionsAreaImpl.this.myAvailabilityListeners.get((Object)epListenerExtension.getExtensionPointName());
                Iterator iterator = listeners.iterator();
                while (iterator.hasNext()) {
                    ExtensionPointAvailabilityListener listener = (ExtensionPointAvailabilityListener)iterator.next();
                    if (!listener.getClass().getName().equals(epListenerExtension.getListenerClass())) continue;
                    iterator.remove();
                    return;
                }
                ExtensionsAreaImpl.this.myLogger.warn("Failed to find EP availability listener: " + epListenerExtension.getListenerClass());
            }

            public void extensionAdded(Object extension, PluginDescriptor pluginDescriptor) {
                EPAvailabilityListenerExtension epListenerExtension = (EPAvailabilityListenerExtension)extension;
                try {
                    String epName = epListenerExtension.getExtensionPointName();
                    ExtensionPointAvailabilityListener listener = (ExtensionPointAvailabilityListener)ExtensionsAreaImpl.this.instantiate(epListenerExtension.loadListenerClass());
                    ExtensionsAreaImpl.this.addAvailabilityListener(epName, listener);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private Object instantiate(Class clazz) {
        ConstructorInjectionComponentAdapter adapter = new ConstructorInjectionComponentAdapter((Object)Integer.toString(System.identityHashCode(new Object())), clazz);
        return adapter.getComponentInstance((PicoContainer)this.getPicoContainer());
    }

    public Throwable getCreationTrace() {
        return this.myCreationTrace;
    }

    @Override
    public void addAvailabilityListener(String epName, ExtensionPointAvailabilityListener listener) {
        this.myAvailabilityListeners.putValue((Object)epName, (Object)listener);
        if (this.hasExtensionPoint(epName)) {
            this.notifyAvailableListener(listener, this.myExtensionPoints.get(epName));
        }
    }

    @Override
    public void registerExtensionPoint(String extensionPointName, String extensionPointBeanClass) {
        this.registerExtensionPoint(extensionPointName, extensionPointBeanClass, new UndefinedPluginDescriptor());
    }

    @Override
    public void registerExtensionPoint(String extensionPointName, String extensionPointBeanClass, PluginDescriptor descriptor) {
        if (this.hasExtensionPoint(extensionPointName)) {
            ExtensionPoint oldEP = this.getExtensionPoint(extensionPointName);
            this.myLogger.error("Duplicate registration for EP: " + extensionPointName + ": original plugin " + ((ExtensionPointImpl)oldEP).getDescriptor().getPluginId() + ", new plugin " + descriptor.getPluginId(), this.myEPTraces.get(extensionPointName));
            throw new RuntimeException("Duplicate registration for EP: " + extensionPointName);
        }
        this.registerExtensionPoint(new ExtensionPointImpl(extensionPointName, extensionPointBeanClass, this, this.myAreaInstance, this.myLogger, descriptor));
    }

    public void registerExtensionPoint(ExtensionPointImpl extensionPoint) {
        String name = extensionPoint.getName();
        this.myExtensionPoints.put(name, extensionPoint);
        this.notifyEPRegistered(extensionPoint);
        this.myEPTraces.put(name, new Throwable("Original registration for " + name));
    }

    @Override
    public void registerAreaExtensionsAndPoints(PluginDescriptor pluginDescriptor, List<Element> extensionsPoints, List<Element> extensions) {
        String areaClass = this.getAreaClass();
        if (extensionsPoints != null) {
            for (Element element : extensionsPoints) {
                if (!ExtensionsAreaImpl.equal(areaClass, element.getAttributeValue(ATTRIBUTE_AREA))) continue;
                this.registerExtensionPoint(pluginDescriptor, element);
            }
        }
        if (extensions != null) {
            for (Element element : extensions) {
                if (!this.hasExtensionPoint(ExtensionsAreaImpl.extractEPName(element))) continue;
                this.registerExtension(pluginDescriptor, element);
            }
        }
    }

    private static boolean equal(String areaClass, String anotherAreaClass) {
        return areaClass == null ? anotherAreaClass == null : areaClass.equals(anotherAreaClass);
    }

    private void notifyEPRegistered(ExtensionPoint extensionPoint) {
        Collection listeners = this.myAvailabilityListeners.get((Object)extensionPoint.getName());
        for (ExtensionPointAvailabilityListener listener : listeners) {
            this.notifyAvailableListener(listener, extensionPoint);
        }
    }

    private void notifyAvailableListener(final ExtensionPointAvailabilityListener listener, final ExtensionPoint extensionPoint) {
        this.queueNotificationAction(new Runnable(){

            @Override
            public void run() {
                listener.extensionPointRegistered(extensionPoint);
            }
        });
    }

    private void queueNotificationAction(Runnable action) {
        if (this.myAvailabilityNotificationsActive) {
            action.run();
        } else {
            this.mySuspendedListenerActions.add(action);
        }
    }

    @NotNull
    public <T> ExtensionPointImpl<T> getExtensionPoint(String extensionPointName) {
        ExtensionPointImpl extensionPoint = this.myExtensionPoints.get(extensionPointName);
        if (extensionPoint == null) {
            throw new IllegalArgumentException("Missing extension point: " + extensionPointName + " in area " + this.myAreaInstance);
        }
        ExtensionPointImpl extensionPointImpl = extensionPoint;
        if (extensionPointImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/extensions/impl/ExtensionsAreaImpl.getExtensionPoint must not return null");
        }
        return extensionPointImpl;
    }

    @Override
    public <T> ExtensionPoint<T> getExtensionPoint(ExtensionPointName<T> extensionPointName) {
        return this.getExtensionPoint(extensionPointName.getName());
    }

    @Override
    public ExtensionPoint[] getExtensionPoints() {
        return this.myExtensionPoints.values().toArray(new ExtensionPoint[this.myExtensionPoints.size()]);
    }

    @Override
    public void unregisterExtensionPoint(String extensionPointName) {
        ExtensionPoint extensionPoint = this.myExtensionPoints.get(extensionPointName);
        if (extensionPoint != null) {
            extensionPoint.reset();
            this.myExtensionPoints.remove(extensionPointName);
            this.notifyEPRemoved(extensionPoint);
        }
    }

    private void notifyEPRemoved(ExtensionPoint extensionPoint) {
        Collection listeners = this.myAvailabilityListeners.get((Object)extensionPoint.getName());
        for (ExtensionPointAvailabilityListener listener : listeners) {
            this.notifyUnavailableListener(extensionPoint, listener);
        }
    }

    private void notifyUnavailableListener(final ExtensionPoint extensionPoint, final ExtensionPointAvailabilityListener listener) {
        this.queueNotificationAction(new Runnable(){

            @Override
            public void run() {
                listener.extensionPointRemoved(extensionPoint);
            }
        });
    }

    @Override
    public boolean hasExtensionPoint(String extensionPointName) {
        return this.myExtensionPoints.containsKey(extensionPointName);
    }

    @Override
    public void suspendInteractions() {
        this.myAvailabilityNotificationsActive = false;
    }

    @Override
    public void resumeInteractions() {
        ExtensionPoint[] extensionPoints;
        this.myAvailabilityNotificationsActive = true;
        for (ExtensionPoint extensionPoint : extensionPoints = this.getExtensionPoints()) {
            extensionPoint.getExtensions();
        }
        for (Runnable action : this.mySuspendedListenerActions) {
            try {
                action.run();
            }
            catch (Exception e) {
                this.myLogger.error(e);
            }
        }
        this.mySuspendedListenerActions.clear();
    }

    @Override
    public void killPendingInteractions() {
        this.mySuspendedListenerActions.clear();
    }

    public MutablePicoContainer[] getPluginContainers() {
        return this.myPluginName2picoContainer.values().toArray(new MutablePicoContainer[this.myPluginName2picoContainer.values().size()]);
    }

    public void removeAllComponents(Set<ExtensionComponentAdapter> extensionAdapters) {
        Iterator<ExtensionComponentAdapter> i$ = extensionAdapters.iterator();
        while (i$.hasNext()) {
            ExtensionComponentAdapter extensionAdapter;
            ExtensionComponentAdapter componentAdapter = extensionAdapter = i$.next();
            this.internalGetPluginContainer().unregisterComponent(componentAdapter.getComponentKey());
        }
    }

    static {
        ourDefaultEPs.put("com.intellij.openapi.extensions.epAvailabilityListener", EPAvailabilityListenerExtension.class.getName());
    }
}

