/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.jackrabbit.webdav.client.methods;

import hidden.org.apache.commons.httpclient.HttpConnection;
import hidden.org.apache.commons.httpclient.HttpState;
import hidden.org.apache.jackrabbit.webdav.DavException;
import hidden.org.apache.jackrabbit.webdav.client.methods.DavMethodBase;
import hidden.org.apache.jackrabbit.webdav.header.PollTimeoutHeader;
import hidden.org.apache.jackrabbit.webdav.observation.EventBundle;
import hidden.org.apache.jackrabbit.webdav.observation.EventDiscovery;
import hidden.org.apache.jackrabbit.webdav.observation.ObservationConstants;
import hidden.org.apache.jackrabbit.webdav.xml.DomUtil;
import hidden.org.apache.jackrabbit.webdav.xml.ElementIterator;
import hidden.org.slf4j.Logger;
import hidden.org.slf4j.LoggerFactory;
import java.io.IOException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PollMethod
extends DavMethodBase
implements ObservationConstants {
    private static Logger log = LoggerFactory.getLogger(PollMethod.class);
    private EventDiscovery eventDiscovery;

    public PollMethod(String uri, String subscriptionId) {
        this(uri, subscriptionId, 0L);
    }

    public PollMethod(String uri, String subscriptionId, long timeout) {
        super(uri);
        this.setRequestHeader("SubscriptionId", subscriptionId);
        if (timeout > 0L) {
            this.setRequestHeader(new PollTimeoutHeader(timeout));
        }
    }

    public EventDiscovery getResponseAsEventDiscovery() throws IOException, DavException {
        this.checkUsed();
        if (this.eventDiscovery != null) {
            return this.eventDiscovery;
        }
        DavException dx = this.getResponseException();
        if (dx != null) {
            throw dx;
        }
        throw new DavException(this.getStatusCode(), this.getName() + " resulted with unexpected status: " + this.getStatusLine());
    }

    public String getName() {
        return "POLL";
    }

    protected boolean isSuccess(int statusCode) {
        return 200 == statusCode;
    }

    protected void processResponseBody(HttpState httpState, HttpConnection httpConnection) {
        if (this.getSuccess()) {
            try {
                this.setSuccess(this.buildDiscoveryFromRoot(this.getRootElement()));
            }
            catch (IOException e) {
                log.error("Error while parsing multistatus response: " + e);
                this.setSuccess(false);
            }
        }
    }

    private boolean buildDiscoveryFromRoot(Element root) {
        if (DomUtil.matches(root, "eventdiscovery", ObservationConstants.NAMESPACE)) {
            this.eventDiscovery = new EventDiscovery();
            ElementIterator it = DomUtil.getChildren(root, "eventbundle", ObservationConstants.NAMESPACE);
            while (it.hasNext()) {
                final Element ebElement = it.nextElement();
                EventBundle eb = new EventBundle(){

                    public Element toXml(Document document) {
                        return (Element)document.importNode(ebElement, true);
                    }
                };
                this.eventDiscovery.addEventBundle(eb);
            }
            return true;
        }
        log.debug("Missing 'eventdiscovery' response body in POLL method.");
        return false;
    }
}

