/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.jackrabbit.webdav.io;

import hidden.org.apache.jackrabbit.webdav.io.InputContext;
import hidden.org.slf4j.Logger;
import hidden.org.slf4j.LoggerFactory;
import java.io.InputStream;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;

public class InputContextImpl
implements InputContext {
    private static Logger log = LoggerFactory.getLogger(InputContextImpl.class);
    private final HttpServletRequest request;
    private final InputStream in;

    public InputContextImpl(HttpServletRequest request, InputStream in) {
        if (request == null) {
            throw new IllegalArgumentException("DavResource and Request must not be null.");
        }
        this.request = request;
        this.in = in;
    }

    public boolean hasStream() {
        return this.in != null;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public long getModificationTime() {
        return new Date().getTime();
    }

    public String getContentLanguage() {
        return this.request.getHeader("Content-Language");
    }

    public long getContentLength() {
        int length = this.request.getIntHeader("Content-Length");
        return Long.parseLong(length + "");
    }

    public String getContentType() {
        return this.request.getHeader("Content-Type");
    }

    public String getProperty(String propertyName) {
        return this.request.getHeader(propertyName);
    }
}

