/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.jackrabbit.webdav.security.report;

import hidden.org.apache.jackrabbit.webdav.DavException;
import hidden.org.apache.jackrabbit.webdav.DavResource;
import hidden.org.apache.jackrabbit.webdav.DavResourceLocator;
import hidden.org.apache.jackrabbit.webdav.MultiStatusResponse;
import hidden.org.apache.jackrabbit.webdav.property.DavProperty;
import hidden.org.apache.jackrabbit.webdav.security.AclProperty;
import hidden.org.apache.jackrabbit.webdav.security.SecurityConstants;
import hidden.org.apache.jackrabbit.webdav.security.report.AbstractSecurityReport;
import hidden.org.apache.jackrabbit.webdav.version.report.ReportInfo;
import hidden.org.apache.jackrabbit.webdav.version.report.ReportType;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class AclPrincipalReport
extends AbstractSecurityReport {
    public static final String REPORT_NAME = "acl-principal-prop-set";
    public static final ReportType REPORT_TYPE = ReportType.register("acl-principal-prop-set", SecurityConstants.NAMESPACE, AclPrincipalReport.class);

    public ReportType getType() {
        return REPORT_TYPE;
    }

    public void init(DavResource resource, ReportInfo info) throws DavException {
        super.init(resource, info);
        DavProperty acl = resource.getProperty(SecurityConstants.ACL);
        if (!(acl instanceof AclProperty)) {
            throw new DavException(500, "DAV:acl property expected.");
        }
        DavResourceLocator loc = resource.getLocator();
        HashMap<String, MultiStatusResponse> principalMap = new HashMap<String, MultiStatusResponse>();
        Iterator aceIt = ((List)((AclProperty)acl).getValue()).iterator();
        while (aceIt.hasNext()) {
            AclProperty.Ace ace = (AclProperty.Ace)aceIt.next();
            String href = ace.getPrincipal().getHref();
            if (href == null && principalMap.containsKey(href)) continue;
            DavResourceLocator princLocator = loc.getFactory().createResourceLocator(loc.getPrefix(), href);
            DavResource principalResource = resource.getFactory().createResource(princLocator, resource.getSession());
            principalMap.put(href, new MultiStatusResponse(principalResource, info.getPropertyNameSet()));
        }
        this.responses = principalMap.values().toArray(new MultiStatusResponse[principalMap.size()]);
    }
}

