/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.editor;

import com.intellij.application.options.editor.EditorOptionsProvider;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import org.jetbrains.annotations.Nls;

public class EditorTabsConfigurable
implements EditorOptionsProvider {
    private JPanel myRootPanel;
    private JCheckBox myHideKnownExtensions;
    private JCheckBox myScrollTabLayoutInEditorCheckBox;
    private JTextField myEditorTabLimitField;
    private JComboBox myEditorTabPlacement;
    private JRadioButton myCloseNonModifiedFilesFirstRadio;
    private JRadioButton myCloseLRUFilesRadio;
    private JRadioButton myActivateLeftEditorOnCloseRadio;
    private JRadioButton myActivateMRUEditorOnCloseRadio;
    private JCheckBox myCbModifiedTabsMarkedWithAsterisk;
    private JCheckBox myShowCloseButtonOnCheckBox;

    public EditorTabsConfigurable() {
        this.$$$setupUI$$$();
        this.myEditorTabPlacement.setModel(new DefaultComboBoxModel<Object>(new Object[]{1, 2, 3, 4, 0}));
        this.myEditorTabPlacement.setRenderer(new MyTabsPlacementComboBoxRenderer());
        this.myEditorTabPlacement.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                EditorTabsConfigurable.this.revalidateSingleRowCheckbox();
            }
        });
        this.revalidateSingleRowCheckbox();
    }

    private void revalidateSingleRowCheckbox() {
        int i = (Integer)this.myEditorTabPlacement.getSelectedItem();
        if (1 != i) {
            this.myScrollTabLayoutInEditorCheckBox.setSelected(true);
            this.myScrollTabLayoutInEditorCheckBox.setEnabled(false);
        } else {
            this.myScrollTabLayoutInEditorCheckBox.setEnabled(true);
        }
    }

    @Nls
    public String getDisplayName() {
        return "Editor Tabs";
    }

    public Icon getIcon() {
        return null;
    }

    public String getHelpTopic() {
        return "reference.settingsdialog.IDE.editor.tabs";
    }

    public JComponent createComponent() {
        return this.myRootPanel;
    }

    public void reset() {
        UISettings uiSettings = UISettings.getInstance();
        this.myCbModifiedTabsMarkedWithAsterisk.setSelected(uiSettings.MARK_MODIFIED_TABS_WITH_ASTERISK);
        this.myScrollTabLayoutInEditorCheckBox.setSelected(uiSettings.SCROLL_TAB_LAYOUT_IN_EDITOR);
        this.myEditorTabPlacement.setSelectedItem(uiSettings.EDITOR_TAB_PLACEMENT);
        this.myHideKnownExtensions.setSelected(uiSettings.HIDE_KNOWN_EXTENSION_IN_TABS);
        this.myEditorTabLimitField.setText(Integer.toString(uiSettings.EDITOR_TAB_LIMIT));
        this.myShowCloseButtonOnCheckBox.setSelected(uiSettings.SHOW_CLOSE_BUTTON);
        if (uiSettings.CLOSE_NON_MODIFIED_FILES_FIRST) {
            this.myCloseNonModifiedFilesFirstRadio.setSelected(true);
        } else {
            this.myCloseLRUFilesRadio.setSelected(true);
        }
        if (uiSettings.ACTIVATE_MRU_EDITOR_ON_CLOSE) {
            this.myActivateMRUEditorOnCloseRadio.setSelected(true);
        } else {
            this.myActivateLeftEditorOnCloseRadio.setSelected(true);
        }
    }

    public void apply() throws ConfigurationException {
        UISettings uiSettings = UISettings.getInstance();
        boolean uiSettingsChanged = uiSettings.MARK_MODIFIED_TABS_WITH_ASTERISK != this.myCbModifiedTabsMarkedWithAsterisk.isSelected();
        uiSettings.MARK_MODIFIED_TABS_WITH_ASTERISK = this.myCbModifiedTabsMarkedWithAsterisk.isSelected();
        if (EditorTabsConfigurable.isModified(this.myScrollTabLayoutInEditorCheckBox, uiSettings.SCROLL_TAB_LAYOUT_IN_EDITOR)) {
            uiSettingsChanged = true;
        }
        uiSettings.SCROLL_TAB_LAYOUT_IN_EDITOR = this.myScrollTabLayoutInEditorCheckBox.isSelected();
        if (EditorTabsConfigurable.isModified(this.myShowCloseButtonOnCheckBox, uiSettings.SHOW_CLOSE_BUTTON)) {
            uiSettingsChanged = true;
        }
        uiSettings.SHOW_CLOSE_BUTTON = this.myShowCloseButtonOnCheckBox.isSelected();
        int tabPlacement = (Integer)this.myEditorTabPlacement.getSelectedItem();
        if (uiSettings.EDITOR_TAB_PLACEMENT != tabPlacement) {
            uiSettingsChanged = true;
        }
        uiSettings.EDITOR_TAB_PLACEMENT = tabPlacement;
        boolean hide = this.myHideKnownExtensions.isSelected();
        if (uiSettings.HIDE_KNOWN_EXTENSION_IN_TABS != hide) {
            uiSettingsChanged = true;
        }
        uiSettings.HIDE_KNOWN_EXTENSION_IN_TABS = hide;
        uiSettings.CLOSE_NON_MODIFIED_FILES_FIRST = this.myCloseNonModifiedFilesFirstRadio.isSelected();
        uiSettings.ACTIVATE_MRU_EDITOR_ON_CLOSE = this.myActivateMRUEditorOnCloseRadio.isSelected();
        String temp = this.myEditorTabLimitField.getText();
        if (temp.trim().length() > 0) {
            try {
                int newEditorTabLimit = Integer.parseInt(temp);
                if (newEditorTabLimit > 0 && newEditorTabLimit != uiSettings.EDITOR_TAB_LIMIT) {
                    uiSettings.EDITOR_TAB_LIMIT = newEditorTabLimit;
                    uiSettingsChanged = true;
                }
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
        }
        if (uiSettingsChanged) {
            uiSettings.fireUISettingsChanged();
        }
    }

    public boolean isModified() {
        UISettings uiSettings = UISettings.getInstance();
        boolean isModified = EditorTabsConfigurable.isModified(this.myCbModifiedTabsMarkedWithAsterisk, uiSettings.MARK_MODIFIED_TABS_WITH_ASTERISK);
        isModified |= EditorTabsConfigurable.isModified(this.myEditorTabLimitField, uiSettings.EDITOR_TAB_LIMIT);
        int tabPlacement = (Integer)this.myEditorTabPlacement.getSelectedItem();
        isModified |= tabPlacement != uiSettings.EDITOR_TAB_PLACEMENT;
        isModified |= this.myHideKnownExtensions.isSelected() != uiSettings.HIDE_KNOWN_EXTENSION_IN_TABS;
        isModified |= this.myScrollTabLayoutInEditorCheckBox.isSelected() != uiSettings.SCROLL_TAB_LAYOUT_IN_EDITOR;
        isModified |= this.myShowCloseButtonOnCheckBox.isSelected() != uiSettings.SHOW_CLOSE_BUTTON;
        isModified |= EditorTabsConfigurable.isModified(this.myCloseNonModifiedFilesFirstRadio, uiSettings.CLOSE_NON_MODIFIED_FILES_FIRST);
        return isModified |= EditorTabsConfigurable.isModified(this.myActivateMRUEditorOnCloseRadio, uiSettings.ACTIVATE_MRU_EDITOR_ON_CLOSE);
    }

    public void disposeUIResources() {
    }

    private static boolean isModified(JToggleButton checkBox, boolean value) {
        return checkBox.isSelected() != value;
    }

    private static boolean isModified(JTextField textField, int value) {
        try {
            int fieldValue = Integer.parseInt(textField.getText().trim());
            return fieldValue != value;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public String getId() {
        return "editor.preferences.tabs";
    }

    public Runnable enableSearch(String option) {
        return null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JRadioButton jRadioButton4;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JComboBox jComboBox;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JPanel jPanel;
        this.myRootPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 9, 3, 0, 0, null, null, null));
        jPanel2.setBorder(BorderFactory.createTitledBorder(null, ResourceBundle.getBundle("messages/ApplicationBundle").getString("group.tab.appearance"), 0, 0, null, null));
        this.myHideKnownExtensions = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.hide.file.extension.in.editor.tabs"));
        jCheckBox4.setMargin(new Insets(2, 0, 2, 2));
        jPanel2.add((Component)jCheckBox4, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myScrollTabLayoutInEditorCheckBox = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.editor.tabs.in.single.row"));
        jCheckBox3.setMargin(new Insets(2, 0, 2, 2));
        jPanel2.add((Component)jCheckBox3, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 3, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setIconTextGap(4);
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/ApplicationBundle").getString("combobox.editor.tab.placement"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myEditorTabPlacement = jComboBox = new JComboBox();
        jPanel3.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 1, 0, new Dimension(140, -1), null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myCbModifiedTabsMarkedWithAsterisk = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.mark.modified.tabs.with.asterisk"));
        jPanel2.add((Component)jCheckBox2, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myShowCloseButtonOnCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.editor.tabs.show.close.button"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(7, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 0, 0, null, null, null));
        jPanel4.setBorder(BorderFactory.createTitledBorder(null, ResourceBundle.getBundle("messages/ApplicationBundle").getString("group.tab.closing.policy"), 0, 0, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("label.when.number.of.opened.editors.exceeds.tab.limit"));
        jPanel4.add((Component)jLabel2, new GridConstraints(1, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myCloseNonModifiedFilesFirstRadio = jRadioButton4 = new JRadioButton();
        jRadioButton4.setMargin(new Insets(2, 15, 2, 2));
        this.$$$loadButtonText$$$(jRadioButton4, ResourceBundle.getBundle("messages/ApplicationBundle").getString("radio.close.non.modified.files.first"));
        jPanel4.add((Component)jRadioButton4, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myCloseLRUFilesRadio = jRadioButton3 = new JRadioButton();
        jRadioButton3.setMargin(new Insets(2, 15, 2, 2));
        this.$$$loadButtonText$$$(jRadioButton3, ResourceBundle.getBundle("messages/ApplicationBundle").getString("radio.close.less.frequently.used.files"));
        jPanel4.add((Component)jRadioButton3, new GridConstraints(3, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/ApplicationBundle").getString("label.when.closing.active.editor"));
        jPanel4.add((Component)jLabel3, new GridConstraints(4, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myActivateLeftEditorOnCloseRadio = jRadioButton2 = new JRadioButton();
        jRadioButton2.setMargin(new Insets(2, 15, 2, 2));
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("radio.activate.left.neighbouring.tab"));
        jPanel4.add((Component)jRadioButton2, new GridConstraints(5, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myActivateMRUEditorOnCloseRadio = jRadioButton = new JRadioButton();
        jRadioButton.setMargin(new Insets(2, 15, 2, 2));
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("messages/ApplicationBundle").getString("radio.activate.most.recently.opened.tab"));
        jPanel4.add((Component)jRadioButton, new GridConstraints(6, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("messages/ApplicationBundle").getString("editbox.tab.limit"));
        jPanel4.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myEditorTabLimitField = jTextField = new JTextField();
        jTextField.setText("15");
        jPanel4.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 0, 2, 0, null, new Dimension(30, -1), null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton4);
        buttonGroup.add(jRadioButton3);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static final class MyTabsPlacementComboBoxRenderer
    extends DefaultListCellRenderer {
        private MyTabsPlacementComboBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String text;
            int tabPlacement = (Integer)value;
            if (0 == tabPlacement) {
                text = ApplicationBundle.message((String)"combobox.tab.placement.none", (Object[])new Object[0]);
            } else if (1 == tabPlacement) {
                text = ApplicationBundle.message((String)"combobox.tab.placement.top", (Object[])new Object[0]);
            } else if (2 == tabPlacement) {
                text = ApplicationBundle.message((String)"combobox.tab.placement.left", (Object[])new Object[0]);
            } else if (3 == tabPlacement) {
                text = ApplicationBundle.message((String)"combobox.tab.placement.bottom", (Object[])new Object[0]);
            } else if (4 == tabPlacement) {
                text = ApplicationBundle.message((String)"combobox.tab.placement.right", (Object[])new Object[0]);
            } else {
                throw new IllegalArgumentException("unknown tabPlacement: " + tabPlacement);
            }
            return super.getListCellRendererComponent((JList<?>)list, text, index, isSelected, cellHasFocus);
        }
    }
}

