/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.editor;

import com.intellij.application.options.editor.AutoImportOptionsProvider;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.ListUtil;
import com.intellij.ui.TitledSeparator;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NonNls;

public class JavaAutoImportOptions
implements AutoImportOptionsProvider {
    private static final String INSERT_IMPORTS_ALWAYS = ApplicationBundle.message((String)"combobox.insert.imports.all", (Object[])new Object[0]);
    private static final String INSERT_IMPORTS_ASK = ApplicationBundle.message((String)"combobox.insert.imports.ask", (Object[])new Object[0]);
    private static final String INSERT_IMPORTS_NONE = ApplicationBundle.message((String)"combobox.insert.imports.none", (Object[])new Object[0]);
    private JComboBox mySmartPasteCombo;
    private JCheckBox myCbShowImportPopup;
    private JPanel myWholePanel;
    private JList myExcludePackagesList;
    private JButton myAddPackageButton;
    private JButton myRemoveButton;
    private JCheckBox myCbAddUnambiguousImports;
    private JCheckBox myCbOptimizeImports;
    private DefaultListModel myExcludePackagesModel;
    @NonNls
    private static final Pattern ourPackagePattern = Pattern.compile("(\\w+\\.)*\\w+");

    public JavaAutoImportOptions() {
        this.$$$setupUI$$$();
        this.mySmartPasteCombo.addItem(INSERT_IMPORTS_ALWAYS);
        this.mySmartPasteCombo.addItem(INSERT_IMPORTS_ASK);
        this.mySmartPasteCombo.addItem(INSERT_IMPORTS_NONE);
        this.myAddPackageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InputValidator validator = new InputValidator(){

                    public boolean checkInput(String inputString) {
                        return ourPackagePattern.matcher(inputString).matches();
                    }

                    public boolean canClose(String inputString) {
                        return this.checkInput(inputString);
                    }
                };
                String packageName = Messages.showInputDialog((Component)JavaAutoImportOptions.this.myWholePanel, (String)ApplicationBundle.message((String)"exclude.from.completion.prompt", (Object[])new Object[0]), (String)ApplicationBundle.message((String)"exclude.from.completion.title", (Object[])new Object[0]), (Icon)Messages.getWarningIcon(), (String)"", (InputValidator)validator);
                JavaAutoImportOptions.this.addExcludePackage(packageName);
            }
        });
        this.myExcludePackagesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                JavaAutoImportOptions.this.myRemoveButton.setEnabled(JavaAutoImportOptions.this.myExcludePackagesList.getSelectedValue() != null);
            }
        });
        this.myRemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListUtil.removeSelectedItems((JList)JavaAutoImportOptions.this.myExcludePackagesList);
            }
        });
    }

    public void addExcludePackage(String packageName) {
        if (packageName != null) {
            this.myExcludePackagesModel.add(this.myExcludePackagesModel.size(), packageName);
            this.myExcludePackagesList.setSelectedValue(packageName, true);
        }
    }

    public JList getExcludePackagesList() {
        return this.myExcludePackagesList;
    }

    public void reset() {
        CodeInsightSettings codeInsightSettings = CodeInsightSettings.getInstance();
        DaemonCodeAnalyzerSettings daemonSettings = DaemonCodeAnalyzerSettings.getInstance();
        switch (codeInsightSettings.ADD_IMPORTS_ON_PASTE) {
            case 1: {
                this.mySmartPasteCombo.setSelectedItem(INSERT_IMPORTS_ALWAYS);
                break;
            }
            case 2: {
                this.mySmartPasteCombo.setSelectedItem(INSERT_IMPORTS_NONE);
                break;
            }
            case 3: {
                this.mySmartPasteCombo.setSelectedItem(INSERT_IMPORTS_ASK);
            }
        }
        this.myCbShowImportPopup.setSelected(daemonSettings.isImportHintEnabled());
        this.myCbOptimizeImports.setSelected(codeInsightSettings.OPTIMIZE_IMPORTS_ON_THE_FLY);
        this.myCbAddUnambiguousImports.setSelected(codeInsightSettings.ADD_UNAMBIGIOUS_IMPORTS_ON_THE_FLY);
        this.myExcludePackagesModel = new DefaultListModel();
        for (String aPackage : codeInsightSettings.EXCLUDED_PACKAGES) {
            this.myExcludePackagesModel.add(this.myExcludePackagesModel.size(), aPackage);
        }
        this.myExcludePackagesList.setModel(this.myExcludePackagesModel);
    }

    public void disposeUIResources() {
    }

    public void apply() {
        CodeInsightSettings codeInsightSettings = CodeInsightSettings.getInstance();
        DaemonCodeAnalyzerSettings daemonSettings = DaemonCodeAnalyzerSettings.getInstance();
        codeInsightSettings.ADD_IMPORTS_ON_PASTE = this.getSmartPasteValue();
        codeInsightSettings.EXCLUDED_PACKAGES = this.getExcludedPackages();
        daemonSettings.setImportHintEnabled(this.myCbShowImportPopup.isSelected());
        codeInsightSettings.OPTIMIZE_IMPORTS_ON_THE_FLY = this.myCbOptimizeImports.isSelected();
        codeInsightSettings.ADD_UNAMBIGIOUS_IMPORTS_ON_THE_FLY = this.myCbAddUnambiguousImports.isSelected();
    }

    private String[] getExcludedPackages() {
        String[] excludedPackages = new String[this.myExcludePackagesModel.size()];
        for (int i = 0; i < this.myExcludePackagesModel.size(); ++i) {
            excludedPackages[i] = (String)this.myExcludePackagesModel.elementAt(i);
        }
        return excludedPackages;
    }

    public JComponent createComponent() {
        return this.myWholePanel;
    }

    public boolean isModified() {
        CodeInsightSettings codeInsightSettings = CodeInsightSettings.getInstance();
        DaemonCodeAnalyzerSettings daemonSettings = DaemonCodeAnalyzerSettings.getInstance();
        boolean isModified = JavaAutoImportOptions.isModified(this.myCbShowImportPopup, daemonSettings.isImportHintEnabled());
        isModified |= JavaAutoImportOptions.isModified(this.myCbOptimizeImports, codeInsightSettings.OPTIMIZE_IMPORTS_ON_THE_FLY);
        isModified |= JavaAutoImportOptions.isModified(this.myCbAddUnambiguousImports, codeInsightSettings.ADD_UNAMBIGIOUS_IMPORTS_ON_THE_FLY);
        isModified |= this.getSmartPasteValue() != codeInsightSettings.ADD_IMPORTS_ON_PASTE;
        return isModified |= !Arrays.deepEquals(this.getExcludedPackages(), codeInsightSettings.EXCLUDED_PACKAGES);
    }

    private int getSmartPasteValue() {
        Object selectedItem = this.mySmartPasteCombo.getSelectedItem();
        if (INSERT_IMPORTS_ALWAYS.equals(selectedItem)) {
            return 1;
        }
        if (INSERT_IMPORTS_NONE.equals(selectedItem)) {
            return 2;
        }
        return 3;
    }

    private static boolean isModified(JToggleButton checkBox, boolean value) {
        return checkBox.isSelected() != value;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JButton jButton;
        JButton jButton2;
        JList jList;
        JComboBox jComboBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JPanel jPanel;
        this.myWholePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Java", 0, 0, null, null));
        this.myCbShowImportPopup = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.show.import.popup"));
        jPanel.add((Component)jCheckBox3, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbAddUnambiguousImports = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.add.unambiguous.imports.on.the.fly"));
        jPanel.add((Component)jCheckBox2, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 5, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/ApplicationBundle").getString("combobox.paste.insert.imports"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySmartPasteCombo = jComboBox = new JComboBox();
        jPanel2.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(5, 0, 1, 2, 0, 3, 3, 7, null, null, null));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel3.add((Component)jScrollPane, new GridConstraints(0, 0, 3, 1, 0, 3, 7, 7, null, null, null));
        this.myExcludePackagesList = jList = new JList();
        jScrollPane.setViewportView(jList);
        this.myAddPackageButton = jButton2 = new JButton();
        this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("exclude.from.imports.add"));
        jPanel3.add((Component)jButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myRemoveButton = jButton = new JButton();
        ((Component)jButton).setEnabled(false);
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("messages/ApplicationBundle").getString("action.remove"));
        jPanel3.add((Component)jButton, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(2, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText(ResourceBundle.getBundle("messages/ApplicationBundle").getString("exclude.from.completion.group"));
        jPanel.add((Component)titledSeparator, new GridConstraints(4, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myCbOptimizeImports = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.optimize.imports.on.the.fly"));
        jPanel.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        jLabel.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

