/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.pathMacros;

import com.intellij.application.options.pathMacros.PathMacroTable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.text.StringTokenizer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class PathMacroListEditor {
    JPanel myPanel;
    JButton myAddButton;
    JButton myRemoveButton;
    JButton myEditButton;
    JScrollPane myScrollPane;
    private JTextField myIgnoredVariables;
    private PathMacroTable myPathMacroTable;

    public PathMacroListEditor() {
        this(null);
    }

    public PathMacroListEditor(Collection<String> undefinedMacroNames) {
        this.$$$setupUI$$$();
        this.myPathMacroTable = undefinedMacroNames != null ? new PathMacroTable(undefinedMacroNames) : new PathMacroTable();
        this.myScrollPane.setViewportView((Component)((Object)this.myPathMacroTable));
        this.myAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PathMacroListEditor.this.myPathMacroTable.addMacro();
            }
        });
        this.myRemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PathMacroListEditor.this.myPathMacroTable.removeSelectedMacros();
            }
        });
        this.myEditButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PathMacroListEditor.this.myPathMacroTable.editMacro();
            }
        });
        this.fillIgnoredVariables();
    }

    private void fillIgnoredVariables() {
        Collection ignored = PathMacros.getInstance().getIgnoredMacroNames();
        this.myIgnoredVariables.setText(StringUtil.join((Collection)ignored, (String)";"));
    }

    private boolean isIgnoredModified() {
        Collection ignored = PathMacros.getInstance().getIgnoredMacroNames();
        return !((Object)this.parseIgnoredVariables()).equals(ignored);
    }

    private Collection<String> parseIgnoredVariables() {
        String s = this.myIgnoredVariables.getText();
        ArrayList<String> ignored = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(s, ";");
        while (st.hasMoreElements()) {
            ignored.add(st.nextElement().trim());
        }
        return ignored;
    }

    public void commit() throws ConfigurationException {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                PathMacroListEditor.this.myPathMacroTable.commit();
                Collection ignored = PathMacroListEditor.this.parseIgnoredVariables();
                PathMacros instance = PathMacros.getInstance();
                instance.setIgnoredMacroNames(ignored);
            }
        });
    }

    public JComponent getPanel() {
        return this.myPanel;
    }

    public void reset() {
        this.myPathMacroTable.reset();
        this.fillIgnoredVariables();
    }

    public boolean isModified() {
        return this.myPathMacroTable.isModified() || this.isIgnoredModified();
    }

    private void createUIComponents() {
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JScrollPane jScrollPane;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myScrollPane = jScrollPane = new JScrollPane();
        jPanel.add((Component)jScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 2, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myAddButton = jButton3 = new JButton();
        jButton3.setActionCommand(ResourceBundle.getBundle("messages/ApplicationBundle").getString("button.add"));
        this.$$$loadButtonText$$$(jButton3, ResourceBundle.getBundle("messages/ApplicationBundle").getString("button.add"));
        jButton3.setAutoscrolls(true);
        jPanel2.add((Component)jButton3, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myEditButton = jButton2 = new JButton();
        this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("button.edit"));
        jPanel2.add((Component)jButton2, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myRemoveButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("messages/ApplicationBundle").getString("button.remove.r"));
        jPanel2.add((Component)jButton, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 2, 1, 6, new Dimension(-1, 200), null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Ignored Variables:");
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myIgnoredVariables = jTextField = new JTextField();
        jPanel3.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Use ; to separate ignored variables.");
        jPanel3.add((Component)jLabel2, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

