/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionContext;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.CompletionVariant;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.KeywordChooser;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.LookupValueWithTail;
import com.intellij.codeInsight.lookup.LookupValueWithUIHint;
import com.intellij.codeInsight.lookup.PresentableLookupValue;
import com.intellij.codeInsight.template.Template;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.paths.PsiDynaReference;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPlainText;
import com.intellij.psi.PsiReference;
import com.intellij.psi.filters.ContextGetter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.TrueFilter;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.ReflectionCache;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompletionData {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.completion.CompletionData");
    private final Set<Class> myFinalScopes = new HashSet<Class>();
    private final List<CompletionVariant> myCompletionVariants = new ArrayList<CompletionVariant>();
    protected final CompletionVariant myGenericVariant = new CompletionVariant(){

        @Override
        public void addReferenceCompletions(PsiReference reference, PsiElement position, Set<LookupElement> set, PsiFile file, CompletionData completionData) {
            CompletionData.this.completeReference(reference, position, set, TailType.NONE, file, TrueFilter.INSTANCE, this);
        }
    };

    protected CompletionData() {
    }

    protected final void declareFinalScope(Class scopeClass) {
        this.myFinalScopes.add(scopeClass);
    }

    protected boolean isScopeFinal(Class scopeClass) {
        if (this.myFinalScopes.contains(scopeClass)) {
            return true;
        }
        for (Class myFinalScope : this.myFinalScopes) {
            if (!ReflectionCache.isAssignable((Class)myFinalScope, (Class)scopeClass)) continue;
            return true;
        }
        return false;
    }

    private boolean isScopeAcceptable(PsiElement scope) {
        for (CompletionVariant variant : this.myCompletionVariants) {
            if (!variant.isScopeAcceptable(scope)) continue;
            return true;
        }
        return false;
    }

    protected void defineScopeEquivalence(Class scopeClass, Class equivClass) {
        Iterator<CompletionVariant> iter = this.myCompletionVariants.iterator();
        if (this.isScopeFinal(scopeClass)) {
            this.declareFinalScope(equivClass);
        }
        while (iter.hasNext()) {
            CompletionVariant variant = iter.next();
            if (!variant.isScopeClassAcceptable(scopeClass)) continue;
            variant.includeScopeClass(equivClass, variant.isScopeClassFinal(scopeClass));
        }
    }

    protected void registerVariant(CompletionVariant variant) {
        this.myCompletionVariants.add(variant);
    }

    public void completeReference(final PsiReference reference, final Set<LookupElement> set, final @NotNull PsiElement position, final PsiFile file, int offset) {
        if (position == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/completion/CompletionData.completeReference must not be null");
        }
        final CompletionVariant[] variants = this.findVariants(position, file);
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                boolean hasApplicableVariants = false;
                for (CompletionVariant variant : variants) {
                    if (!variant.hasReferenceFilter()) continue;
                    variant.addReferenceCompletions(reference, position, set, file, CompletionData.this);
                    hasApplicableVariants = true;
                }
                if (!hasApplicableVariants) {
                    CompletionData.this.myGenericVariant.addReferenceCompletions(reference, position, set, file, CompletionData.this);
                }
            }
        });
    }

    public void addKeywordVariants(Set<CompletionVariant> set, PsiElement position, PsiFile file) {
        set.addAll(Arrays.asList(this.findVariants(position, file)));
    }

    public void completeKeywordsBySet(final Set<LookupElement> set, Set<CompletionVariant> variants, final PsiElement position, final PrefixMatcher matcher, final PsiFile file) {
        for (final CompletionVariant variant : variants) {
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    variant.addKeywords(set, position, matcher, file, CompletionData.this);
                }
            });
        }
    }

    public String findPrefix(PsiElement insertedElement, int offsetInFile) {
        return CompletionData.findPrefixStatic(insertedElement, offsetInFile);
    }

    public CompletionVariant[] findVariants(final PsiElement position, final PsiFile file) {
        return (CompletionVariant[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<CompletionVariant[]>(){

            public CompletionVariant[] compute() {
                ArrayList<CompletionVariant> variants = new ArrayList<CompletionVariant>();
                PsiElement scope = position;
                if (scope == null) {
                    scope = file;
                }
                while (scope != null) {
                    boolean breakFlag = false;
                    if (CompletionData.this.isScopeAcceptable(scope)) {
                        for (CompletionVariant variant : CompletionData.this.myCompletionVariants) {
                            if (!variant.isVariantApplicable(position, scope) || variants.contains(variant)) continue;
                            variants.add(variant);
                            if (!variant.isScopeFinal(scope)) continue;
                            breakFlag = true;
                        }
                    }
                    if (!breakFlag && !CompletionData.this.isScopeFinal(scope.getClass()) && !((scope = scope.getContext()) instanceof PsiDirectory)) continue;
                    break;
                }
                return variants.toArray(new CompletionVariant[variants.size()]);
            }
        });
    }

    @Nullable
    public static String getReferencePrefix(@NotNull PsiElement insertedElement, int offsetInFile) {
        if (insertedElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/CompletionData.getReferencePrefix must not be null");
        }
        PsiReference ref = insertedElement.getContainingFile().findReferenceAt(offsetInFile);
        if (ref != null) {
            PsiElement element = ref.getElement();
            int endIndex = offsetInFile - element.getTextRange().getStartOffset();
            int beginIndex = ref.getRangeInElement().getStartOffset();
            if (beginIndex > endIndex) {
                LOG.error("Inconsistent reference (found at offset not included in its range): ref=" + ref + " element=" + element + " text=" + element.getText());
            }
            if (beginIndex < 0) {
                LOG.error("Inconsistent reference (begin < 0): ref=" + ref + " element=" + element + "; begin=" + beginIndex + " text=" + element.getText());
            }
            LOG.assertTrue(endIndex >= 0);
            return element.getText().substring(beginIndex, endIndex);
        }
        return null;
    }

    public static String findPrefixStatic(final PsiElement insertedElement, final int offsetInFile) {
        if (insertedElement == null) {
            return "";
        }
        String prefix = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                if (!insertedElement.isValid()) {
                    return "";
                }
                return CompletionData.getReferencePrefix(insertedElement, offsetInFile);
            }
        });
        if (prefix != null) {
            return prefix;
        }
        if (insertedElement instanceof PsiPlainText || insertedElement instanceof PsiComment) {
            return CompletionUtil.findJavaIdentifierPrefix(insertedElement, offsetInFile);
        }
        return CompletionData.findPrefixDefault(insertedElement, offsetInFile, StandardPatterns.not((ElementPattern)StandardPatterns.character().javaIdentifierPart()));
    }

    protected static String findPrefixDefault(PsiElement insertedElement, int offset, @NotNull ElementPattern trimStart) {
        int i;
        if (trimStart == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/completion/CompletionData.findPrefixDefault must not be null");
        }
        String substr = insertedElement.getText().substring(0, offset - insertedElement.getTextRange().getStartOffset());
        if (substr.length() == 0 || Character.isWhitespace(substr.charAt(substr.length() - 1))) {
            return "";
        }
        substr = substr.trim();
        for (i = 0; substr.length() > i && trimStart.accepts((Object)Character.valueOf(substr.charAt(i))); ++i) {
        }
        return substr.substring(i).trim();
    }

    public static LookupElement objectToLookupItem(Object object) {
        if (object instanceof LookupElement) {
            return (LookupElement)object;
        }
        String s = null;
        TailType tailType = TailType.NONE;
        if (object instanceof PsiElement) {
            s = PsiUtilBase.getName((PsiElement)((PsiElement)object));
        } else if (object instanceof PsiMetaData) {
            s = ((PsiMetaData)object).getName();
        } else if (object instanceof String) {
            s = (String)object;
        } else if (object instanceof Template) {
            s = ((Template)object).getKey();
        } else if (object instanceof PresentableLookupValue) {
            s = ((PresentableLookupValue)object).getPresentation();
        } else {
            LOG.error("Null string for object: " + object + " of class " + (object != null ? object.getClass() : null));
        }
        LookupItem<Object> item = new LookupItem<Object>(object, s);
        if (object instanceof LookupValueWithUIHint && ((LookupValueWithUIHint)object).isBold()) {
            item.setBold();
        }
        if (object instanceof LookupValueWithTail) {
            item.setAttribute(LookupItem.TAIL_TEXT_ATTR, (Object)(" " + ((LookupValueWithTail)object).getTailText()));
        }
        item.setAttribute(CompletionUtil.TAIL_TYPE_ATTR, (Object)tailType);
        return item;
    }

    protected void addLookupItem(Set<LookupElement> set, TailType tailType, @NotNull Object completion, PsiFile file, CompletionVariant variant) {
        if (completion == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/completion/CompletionData.addLookupItem must not be null");
        }
        LookupElement ret = CompletionData.objectToLookupItem(completion);
        if (ret == null) {
            return;
        }
        if (!(ret instanceof LookupItem)) {
            set.add(ret);
            return;
        }
        LookupItem item = (LookupItem)ret;
        InsertHandler insertHandler = variant.getInsertHandler();
        if (insertHandler != null && item.getInsertHandler() == null) {
            item.setInsertHandler(insertHandler);
            item.setTailType(TailType.UNKNOWN);
        } else if (tailType != TailType.NONE) {
            item.setTailType(tailType);
        }
        Map<Object, Object> itemProperties = variant.getItemProperties();
        for (Object key : itemProperties.keySet()) {
            item.setAttribute(key, itemProperties.get(key));
        }
        set.add(ret);
    }

    protected void completeReference(PsiReference reference, PsiElement position, Set<LookupElement> set, TailType tailType, PsiFile file, ElementFilter filter, CompletionVariant variant) {
        if (reference instanceof PsiMultiReference) {
            for (PsiReference ref : this.getReferences((PsiMultiReference)reference)) {
                this.completeReference(ref, position, set, tailType, file, filter, variant);
            }
        } else if (reference instanceof PsiDynaReference) {
            for (PsiReference ref : ((PsiDynaReference)reference).getReferences()) {
                this.completeReference(ref, position, set, tailType, file, filter, variant);
            }
        } else {
            Object[] completions = reference.getVariants();
            if (completions == null) {
                return;
            }
            for (Object completion : completions) {
                Object o;
                if (completion == null) {
                    LOG.error("Position=" + position + "\n;Reference=" + reference + "\n;variants=" + Arrays.toString(completions));
                }
                if (completion instanceof PsiElement) {
                    PsiElement psiElement = (PsiElement)completion;
                    if (!filter.isClassAcceptable(psiElement.getClass()) || !filter.isAcceptable((Object)psiElement, position)) continue;
                    this.addLookupItem(set, tailType, completion, file, variant);
                    continue;
                }
                if (completion instanceof LookupItem && (o = ((LookupItem)completion).getObject()) instanceof PsiElement && (!filter.isClassAcceptable(o.getClass()) || !filter.isAcceptable(o, position))) continue;
                this.addLookupItem(set, tailType, completion, file, variant);
            }
        }
    }

    protected PsiReference[] getReferences(PsiMultiReference multiReference) {
        Object[] references = multiReference.getReferences();
        List hard = ContainerUtil.findAll((Object[])references, (Condition)new Condition<PsiReference>(){

            public boolean value(PsiReference object) {
                return !object.isSoft();
            }
        });
        if (!hard.isEmpty()) {
            return hard.toArray(new PsiReference[hard.size()]);
        }
        return references;
    }

    protected void addKeywords(Set<LookupElement> set, PsiElement position, PrefixMatcher matcher, PsiFile file, CompletionVariant variant, Object comp, TailType tailType) {
        block3: {
            String[] keywords;
            CompletionContext context;
            block4: {
                Object[] elements;
                block2: {
                    if (!(comp instanceof String)) break block2;
                    this.addKeyword(set, tailType, comp, matcher, file, variant);
                    break block3;
                }
                context = (CompletionContext)position.getUserData(CompletionContext.COMPLETION_CONTEXT_KEY);
                if (!(comp instanceof ContextGetter)) break block4;
                for (Object element : elements = ((ContextGetter)comp).get(position, context)) {
                    this.addLookupItem(set, tailType, element, file, variant);
                }
                break block3;
            }
            if (!(comp instanceof KeywordChooser)) break block3;
            for (String keyword : keywords = ((KeywordChooser)comp).getKeywords(context, position)) {
                this.addKeyword(set, tailType, keyword, matcher, file, variant);
            }
        }
    }

    private void addKeyword(Set<LookupElement> set, TailType tailType, Object comp, PrefixMatcher matcher, PsiFile file, CompletionVariant variant) {
        for (LookupElement item : set) {
            if (!item.getObject().toString().equals(comp.toString())) continue;
            return;
        }
        this.addLookupItem(set, tailType, comp, file, variant);
    }
}

