/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.lookup.CharFilter;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.PsiTreeUtil;

public class JavaCharFilter
extends CharFilter {
    private static boolean isWithinLiteral(Lookup lookup) {
        PsiElement psiElement = lookup.getPsiElement();
        return psiElement != null && psiElement.getParent() instanceof PsiLiteralExpression;
    }

    @Override
    public CharFilter.Result acceptChar(char c, int prefixLength, Lookup lookup) {
        LookupElement item;
        if (!lookup.isCompletion()) {
            return null;
        }
        if (c == '!' && lookup.getPsiFile() instanceof PsiJavaFile) {
            PsiType type;
            LookupElement item2 = lookup.getCurrentItem();
            if (item2 == null) {
                return null;
            }
            Object o = item2.getObject();
            if (o instanceof PsiVariable && PsiType.BOOLEAN.isAssignableFrom(((PsiVariable)o).getType())) {
                return CharFilter.Result.SELECT_ITEM_AND_FINISH_LOOKUP;
            }
            if (o instanceof PsiMethod && (type = ((PsiMethod)o).getReturnType()) != null && PsiType.BOOLEAN.isAssignableFrom(type)) {
                return CharFilter.Result.SELECT_ITEM_AND_FINISH_LOOKUP;
            }
            return null;
        }
        if (c == '.' && JavaCharFilter.isWithinLiteral(lookup)) {
            return CharFilter.Result.ADD_TO_PREFIX;
        }
        if (c == '#' && PsiTreeUtil.getParentOfType((PsiElement)lookup.getPsiElement(), PsiDocComment.class) != null && (item = lookup.getCurrentItem()) != null && item.getObject() instanceof PsiClass) {
            return CharFilter.Result.SELECT_ITEM_AND_FINISH_LOOKUP;
        }
        return null;
    }
}

