/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypeInfoImpl;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaSmartCompletionContributor;
import com.intellij.codeInsight.completion.OffsetKey;
import com.intellij.codeInsight.completion.OffsetMap;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.completion.scope.CompletionElement;
import com.intellij.codeInsight.completion.scope.JavaCompletionProcessor;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInsight.guess.GuessManager;
import com.intellij.codeInsight.lookup.InsertHandlerDecorator;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.LookupItemUtil;
import com.intellij.codeInsight.lookup.PsiTypeLookupItem;
import com.intellij.codeInsight.lookup.TypedLookupItem;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NullableLazyKey;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.filters.AndFilter;
import com.intellij.psi.filters.ClassFilter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.element.ExcludeDeclaredFilter;
import com.intellij.psi.filters.element.ExcludeSillyAssignment;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.ClassCandidateInfo;
import com.intellij.psi.javadoc.PsiDocToken;
import com.intellij.psi.scope.BaseScopeProcessor;
import com.intellij.psi.scope.ElementClassFilter;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.statistics.JavaStatisticsManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.HashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaCompletionUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.completion.JavaCompletionUtil");
    public static final Key<PairFunction<PsiExpression, CompletionParameters, PsiType>> DYNAMIC_TYPE_EVALUATOR = Key.create((String)"DYNAMIC_TYPE_EVALUATOR");
    static final Key<PsiType> QUALIFIER_TYPE_ATTR = Key.create((String)"qualifierType");
    @NonNls
    public static final String GET_PREFIX = "get";
    @NonNls
    public static final String SET_PREFIX = "set";
    @NonNls
    public static final String IS_PREFIX = "is";
    private static final int MAX_SCOPE_SIZE_TO_SEARCH_UNRESOLVED = 50000;
    public static final OffsetKey LPAREN_OFFSET = OffsetKey.create((String)"lparen");
    public static final OffsetKey RPAREN_OFFSET = OffsetKey.create((String)"rparen");
    public static final OffsetKey ARG_LIST_END_OFFSET = OffsetKey.create((String)"argListEnd");
    static final NullableLazyKey<ExpectedTypeInfo[], CompletionLocation> EXPECTED_TYPES = NullableLazyKey.create((String)"expectedTypes", (NullableFunction)new NullableFunction<CompletionLocation, ExpectedTypeInfo[]>(){

        @Nullable
        public ExpectedTypeInfo[] fun(CompletionLocation location) {
            return JavaSmartCompletionContributor.getExpectedTypes(location.getCompletionParameters());
        }
    });
    private static final PsiElementPattern.Capture<PsiElement> LEFT_PAREN = (PsiElementPattern.Capture)PlatformPatterns.psiElement((IElementType)JavaTokenType.LPARENTH).andOr(new ElementPattern[]{PlatformPatterns.psiElement().withParent(PsiExpressionList.class), PlatformPatterns.psiElement().afterLeaf(new String[]{".", "new"})});
    public static final Key<Boolean> SUPER_METHOD_PARAMETERS = Key.create((String)"SUPER_METHOD_PARAMETERS");
    static final NullableLazyKey<PsiMethod, CompletionLocation> POSITION_METHOD = NullableLazyKey.create((String)"positionMethod", (NullableFunction)new NullableFunction<CompletionLocation, PsiMethod>(){

        public PsiMethod fun(CompletionLocation location) {
            return (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)location.getCompletionParameters().getPosition(), PsiMethod.class, (boolean)false);
        }
    });
    public static final Key<List<PsiMethod>> ALL_METHODS_ATTRIBUTE = Key.create((String)"allMethods");

    @Nullable
    public static Set<PsiType> getExpectedTypes(CompletionParameters parameters) {
        ExpectedTypeInfo[] expectedInfos;
        PsiExpression expr = (PsiExpression)PsiTreeUtil.getContextOfType((PsiElement)parameters.getPosition(), PsiExpression.class, (boolean)true);
        if (expr != null && (expectedInfos = JavaSmartCompletionContributor.getExpectedTypes(parameters)) != null) {
            THashSet set = new THashSet();
            for (ExpectedTypeInfo expectedInfo : expectedInfos) {
                set.add(expectedInfo.getType());
            }
            return set;
        }
        return null;
    }

    public static void completeLocalVariableName(Set<LookupElement> set, PrefixMatcher matcher, PsiVariable var) {
        PsiElement parent;
        FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.variable.name");
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)var.getProject());
        VariableKind variableKind = codeStyleManager.getVariableKind(var);
        String propertyName = null;
        if (variableKind == VariableKind.PARAMETER) {
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)var, PsiMethod.class);
            propertyName = PropertyUtil.getPropertyName((PsiMethod)method);
        }
        PsiType type = var.getType();
        SuggestedNameInfo suggestedNameInfo = codeStyleManager.suggestVariableName(variableKind, propertyName, null, type);
        Object[] suggestedNames = suggestedNameInfo.names;
        JavaCompletionUtil.tunePreferencePolicy(LookupItemUtil.addLookupItems(set, suggestedNames, matcher), suggestedNameInfo);
        if (set.isEmpty()) {
            if (type.equalsToText("java.lang.Object") && matcher.prefixMatches("object")) {
                set.add((LookupElement)LookupElementBuilder.create((String)"object"));
            }
            if (type.equalsToText("java.lang.String") && matcher.prefixMatches("string")) {
                set.add((LookupElement)LookupElementBuilder.create((String)"string"));
            }
        }
        if (set.isEmpty()) {
            suggestedNameInfo = new SuggestedNameInfo(JavaCompletionUtil.getOverlappedNameVersions(matcher.getPrefix(), (String[])suggestedNames, "")){

                public void nameChoosen(String name) {
                }
            };
            JavaCompletionUtil.tunePreferencePolicy(LookupItemUtil.addLookupItems(set, suggestedNameInfo.names, matcher), suggestedNameInfo);
        }
        if ((parent = PsiTreeUtil.getParentOfType((PsiElement)var, PsiCodeBlock.class)) == null) {
            parent = PsiTreeUtil.getParentOfType((PsiElement)var, PsiMethod.class);
        }
        JavaCompletionUtil.tunePreferencePolicy(LookupItemUtil.addLookupItems(set, JavaCompletionUtil.getUnresolvedReferences(parent, false), matcher), suggestedNameInfo);
        Object[] nameSuggestions = JavaStatisticsManager.getNameSuggestions((PsiType)type, (JavaStatisticsManager.NameContext)JavaStatisticsManager.getContext((PsiElement)var), (String)matcher.getPrefix());
        JavaCompletionUtil.tunePreferencePolicy(LookupItemUtil.addLookupItems(set, nameSuggestions, matcher), suggestedNameInfo);
    }

    public static void completeFieldName(Set<LookupElement> set, PsiVariable var, PrefixMatcher matcher) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.variable.name");
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)var.getProject());
        VariableKind variableKind = JavaCodeStyleManager.getInstance((Project)var.getProject()).getVariableKind(var);
        String prefix = matcher.getPrefix();
        if (PsiType.VOID.equals(var.getType()) || prefix.startsWith(IS_PREFIX) || prefix.startsWith(GET_PREFIX) || prefix.startsWith(SET_PREFIX)) {
            JavaCompletionUtil.completeVariableNameForRefactoring(var.getProject(), set, matcher, var.getType(), variableKind);
            return;
        }
        SuggestedNameInfo suggestedNameInfo = codeStyleManager.suggestVariableName(variableKind, null, null, var.getType());
        Object[] suggestedNames = suggestedNameInfo.names;
        JavaCompletionUtil.tunePreferencePolicy(LookupItemUtil.addLookupItems(set, suggestedNames, matcher), suggestedNameInfo);
        if (set.isEmpty()) {
            String requiredSuffix = codeStyleManager.getSuffixByVariableKind(variableKind);
            if (variableKind != VariableKind.STATIC_FINAL_FIELD) {
                for (int i = 0; i < suggestedNames.length; ++i) {
                    suggestedNames[i] = codeStyleManager.variableNameToPropertyName((String)suggestedNames[i], variableKind);
                }
            }
            suggestedNameInfo = new SuggestedNameInfo(JavaCompletionUtil.getOverlappedNameVersions(prefix, (String[])suggestedNames, requiredSuffix)){

                public void nameChoosen(String name) {
                }
            };
            JavaCompletionUtil.tunePreferencePolicy(LookupItemUtil.addLookupItems(set, suggestedNameInfo.names, matcher), suggestedNameInfo);
        }
        JavaCompletionUtil.tunePreferencePolicy(LookupItemUtil.addLookupItems(set, JavaStatisticsManager.getNameSuggestions((PsiType)var.getType(), (JavaStatisticsManager.NameContext)JavaStatisticsManager.getContext((PsiElement)var), (String)matcher.getPrefix()), matcher), suggestedNameInfo);
        JavaCompletionUtil.tunePreferencePolicy(LookupItemUtil.addLookupItems(set, JavaCompletionUtil.getUnresolvedReferences(var.getParent(), false), matcher), suggestedNameInfo);
    }

    public static void completeMethodName(Set<LookupElement> set, PsiElement element, PrefixMatcher matcher) {
        PsiMethod method;
        if (element instanceof PsiMethod && (method = (PsiMethod)element).isConstructor()) {
            PsiClass containingClass = method.getContainingClass();
            String name = containingClass.getName();
            if (StringUtil.isNotEmpty((String)name)) {
                LookupItemUtil.addLookupItem(set, name, matcher);
            }
            return;
        }
        PsiClass ourClassParent = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
        if (ourClassParent == null) {
            return;
        }
        LookupItemUtil.addLookupItems(set, JavaCompletionUtil.getUnresolvedReferences((PsiElement)ourClassParent, true), matcher);
        if (!((PsiModifierListOwner)element).hasModifierProperty("private")) {
            LookupItemUtil.addLookupItems(set, JavaCompletionUtil.getOverides(ourClassParent, PsiUtil.getTypeByPsiElement((PsiElement)element)), matcher);
            LookupItemUtil.addLookupItems(set, JavaCompletionUtil.getImplements(ourClassParent, PsiUtil.getTypeByPsiElement((PsiElement)element)), matcher);
        }
        LookupItemUtil.addLookupItems(set, JavaCompletionUtil.getPropertiesHandlersNames(ourClassParent, ((PsiModifierListOwner)element).hasModifierProperty("static"), PsiUtil.getTypeByPsiElement((PsiElement)element), element), matcher);
    }

    public static PsiType getQualifierType(LookupItem item) {
        return (PsiType)item.getUserData(QUALIFIER_TYPE_ATTR);
    }

    public static void completeVariableNameForRefactoring(Project project, Set<LookupElement> set, String prefix, PsiType varType, VariableKind varKind) {
        JavaCompletionUtil.completeVariableNameForRefactoring(project, set, new CamelHumpMatcher(prefix), varType, varKind);
    }

    public static void completeVariableNameForRefactoring(Project project, Set<LookupElement> set, PrefixMatcher matcher, PsiType varType, VariableKind varKind) {
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
        SuggestedNameInfo suggestedNameInfo = codeStyleManager.suggestVariableName(varKind, null, null, varType);
        Object[] strings = JavaCompletionUtil.completeVariableNameForRefactoring(codeStyleManager, matcher, varType, varKind, suggestedNameInfo);
        JavaCompletionUtil.tunePreferencePolicy(LookupItemUtil.addLookupItems(set, strings, matcher), suggestedNameInfo);
    }

    public static String[] completeVariableNameForRefactoring(JavaCodeStyleManager codeStyleManager, PsiType varType, VariableKind varKind, SuggestedNameInfo suggestedNameInfo) {
        return JavaCompletionUtil.completeVariableNameForRefactoring(codeStyleManager, new CamelHumpMatcher(""), varType, varKind, suggestedNameInfo);
    }

    public static String[] completeVariableNameForRefactoring(JavaCodeStyleManager codeStyleManager, PrefixMatcher matcher, PsiType varType, VariableKind varKind, SuggestedNameInfo suggestedNameInfo) {
        String[] suggestedNames;
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (String suggestedName : suggestedNames = suggestedNameInfo.names) {
            if (!matcher.prefixMatches(suggestedName)) continue;
            result.add(suggestedName);
        }
        if (result.isEmpty() && PsiType.VOID != varType) {
            boolean isMethodPrefix;
            String requiredSuffix = codeStyleManager.getSuffixByVariableKind(varKind);
            String prefix = matcher.getPrefix();
            boolean bl = isMethodPrefix = prefix.startsWith(IS_PREFIX) || prefix.startsWith(GET_PREFIX) || prefix.startsWith(SET_PREFIX);
            if (varKind != VariableKind.STATIC_FINAL_FIELD || isMethodPrefix) {
                for (int i = 0; i < suggestedNames.length; ++i) {
                    suggestedNames[i] = codeStyleManager.variableNameToPropertyName(suggestedNames[i], varKind);
                }
            }
            result.addAll(Arrays.asList(JavaCompletionUtil.getOverlappedNameVersions(prefix, suggestedNames, requiredSuffix)));
        }
        return ArrayUtil.toStringArray(result);
    }

    private static void tunePreferencePolicy(List<LookupElement> list, final SuggestedNameInfo suggestedNameInfo) {
        InsertHandler insertHandler = new InsertHandler(){

            public void handleInsert(InsertionContext context, LookupElement item) {
                suggestedNameInfo.nameChoosen(item.getLookupString());
            }
        };
        for (int i = 0; i < list.size(); ++i) {
            LookupElement item = list.get(i);
            if (!(item instanceof LookupItem)) continue;
            ((LookupItem)item).setPriority(list.size() - i).setInsertHandler(insertHandler);
        }
    }

    public static String[] getOverlappedNameVersions(String prefix, String[] suggestedNames, String suffix) {
        ArrayList<String> newSuggestions = new ArrayList<String>();
        int longestOverlap = 0;
        for (String suggestedName : suggestedNames) {
            String suggestion;
            int lastIndexOfSuffix;
            int overlap;
            if (suggestedName.toUpperCase().startsWith(prefix.toUpperCase())) {
                newSuggestions.add(suggestedName);
                longestOverlap = prefix.length();
            }
            if ((overlap = JavaCompletionUtil.getOverlap(suggestedName = String.valueOf(Character.toUpperCase(suggestedName.charAt(0))) + suggestedName.substring(1), prefix)) < longestOverlap) continue;
            if (overlap > longestOverlap) {
                newSuggestions.clear();
                longestOverlap = overlap;
            }
            if ((lastIndexOfSuffix = (suggestion = prefix.substring(0, prefix.length() - overlap) + suggestedName).lastIndexOf(suffix)) >= 0 && suffix.length() < suggestion.length() - lastIndexOfSuffix) {
                suggestion = suggestion.substring(0, lastIndexOfSuffix) + suffix;
            }
            if (newSuggestions.contains(suggestion)) continue;
            newSuggestions.add(suggestion);
        }
        return ArrayUtil.toStringArray(newSuggestions);
    }

    static int getOverlap(String propertyName, String prefix) {
        int overlap = 0;
        int propertyNameLen = propertyName.length();
        int prefixLen = prefix.length();
        for (int j = 1; j < prefixLen && j < propertyNameLen; ++j) {
            if (!prefix.substring(prefixLen - j).equals(propertyName.substring(0, j))) continue;
            overlap = j;
        }
        return overlap;
    }

    public static PsiType eliminateWildcards(PsiType type) {
        return JavaCompletionUtil.eliminateWildcardsInner(type, true);
    }

    static PsiType eliminateWildcardsInner(PsiType type, boolean eliminateInTypeArguments) {
        if (eliminateInTypeArguments && type instanceof PsiClassType) {
            PsiClassType classType = (PsiClassType)type;
            PsiClassType.ClassResolveResult resolveResult = classType.resolveGenerics();
            PsiClass aClass = (PsiClass)resolveResult.getElement();
            if (aClass != null) {
                PsiManager manager = aClass.getManager();
                PsiTypeParameter[] typeParams = aClass.getTypeParameters();
                HashMap map = new HashMap();
                for (PsiTypeParameter typeParam : typeParams) {
                    PsiType substituted = resolveResult.getSubstitutor().substitute(typeParam);
                    if (substituted instanceof PsiWildcardType && (substituted = ((PsiWildcardType)substituted).getBound()) == null) {
                        substituted = PsiType.getJavaLangObject((PsiManager)manager, (GlobalSearchScope)aClass.getResolveScope());
                    }
                    map.put(typeParam, substituted);
                }
                PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
                PsiSubstitutor substitutor = factory.createSubstitutor((Map)map);
                type = factory.createType(aClass, substitutor);
            }
        } else {
            if (type instanceof PsiArrayType) {
                return JavaCompletionUtil.eliminateWildcardsInner(((PsiArrayType)type).getComponentType(), false).createArrayType();
            }
            if (type instanceof PsiWildcardType) {
                return ((PsiWildcardType)type).getExtendsBound();
            }
        }
        return type;
    }

    public static String[] getOverides(PsiClass parent, PsiType typeByPsiElement) {
        ArrayList<String> overides = new ArrayList<String>();
        Collection<CandidateInfo> methodsToOverrideImplement = OverrideImplementUtil.getMethodsToOverrideImplement(parent, true);
        for (CandidateInfo candidateInfo : methodsToOverrideImplement) {
            PsiElement element = candidateInfo.getElement();
            if (!Comparing.equal((Object)typeByPsiElement, (Object)PsiUtil.getTypeByPsiElement((PsiElement)element)) || !(element instanceof PsiNamedElement)) continue;
            overides.add(((PsiNamedElement)element).getName());
        }
        return ArrayUtil.toStringArray(overides);
    }

    public static String[] getImplements(PsiClass parent, PsiType typeByPsiElement) {
        ArrayList<String> overides = new ArrayList<String>();
        Collection<CandidateInfo> methodsToOverrideImplement = OverrideImplementUtil.getMethodsToOverrideImplement(parent, false);
        for (CandidateInfo candidateInfo : methodsToOverrideImplement) {
            PsiElement element = candidateInfo.getElement();
            if (!Comparing.equal((Object)typeByPsiElement, (Object)PsiUtil.getTypeByPsiElement((PsiElement)element)) || !(element instanceof PsiNamedElement)) continue;
            overides.add(((PsiNamedElement)element).getName());
        }
        return ArrayUtil.toStringArray(overides);
    }

    public static String[] getPropertiesHandlersNames(final PsiClass psiClass, final boolean staticContext, final PsiType varType, final PsiElement element) {
        class Change
        implements Runnable {
            private String[] result;

            Change() {
            }

            @Override
            public void run() {
                PsiField[] fields;
                ArrayList<String> propertyHandlers = new ArrayList<String>();
                for (PsiField field : fields = psiClass.getFields()) {
                    String setterName;
                    String getterName;
                    if (field == element) continue;
                    PsiModifierList modifierList = field.getModifierList();
                    if (staticContext && modifierList != null && !modifierList.hasModifierProperty("static")) continue;
                    if (field.getType().equals(varType) && (psiClass.findMethodsByName(getterName = PropertyUtil.suggestGetterName((Project)field.getProject(), (PsiField)field), true).length == 0 || psiClass.findMethodBySignature(PropertyUtil.generateGetterPrototype((PsiField)field), true) == null)) {
                        propertyHandlers.add(getterName);
                    }
                    if (!PsiType.VOID.equals(varType) || psiClass.findMethodsByName(setterName = PropertyUtil.suggestSetterName((Project)field.getProject(), (PsiField)field), true).length != 0 && psiClass.findMethodBySignature(PropertyUtil.generateSetterPrototype((PsiField)field), true) != null) continue;
                    propertyHandlers.add(setterName);
                }
                this.result = ArrayUtil.toStringArray(propertyHandlers);
            }
        }
        Change result = new Change();
        element.getManager().performActionWithFormatterDisabled((Runnable)result);
        return result.result;
    }

    public static boolean isInExcludedPackage(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/JavaCompletionUtil.isInExcludedPackage must not be null");
        }
        String name = psiClass.getQualifiedName();
        if (name == null) {
            return false;
        }
        CodeInsightSettings cis = CodeInsightSettings.getInstance();
        for (String excluded : cis.EXCLUDED_PACKAGES) {
            if (!name.equals(excluded) && !name.startsWith(excluded + ".")) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static PsiField getOriginalElement(@NotNull PsiField field) {
        PsiField psiField;
        PsiField original;
        PsiClass newParent;
        if (field == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/JavaCompletionUtil.getOriginalElement must not be null");
        }
        PsiClass cls = field.getContainingClass();
        if (cls != null && (newParent = JavaCompletionUtil.getOriginalElement(cls)) != cls && (original = newParent.findFieldByName(field.getName(), false)) != null) {
            psiField = original;
            if (psiField == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/completion/JavaCompletionUtil.getOriginalElement must not return null");
            return psiField;
        }
        psiField = field;
        if (psiField != null) return psiField;
        throw new IllegalStateException("@NotNull method com/intellij/codeInsight/completion/JavaCompletionUtil.getOriginalElement must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static PsiTypeParameter getOriginalElement(@NotNull PsiTypeParameter param) {
        PsiTypeParameter psiTypeParameter;
        PsiClass newParent;
        if (param == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/JavaCompletionUtil.getOriginalElement must not be null");
        }
        PsiClass parent = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)param, PsiClass.class, (boolean)true, (Class[])new Class[]{PsiMethod.class});
        if (parent != null && (newParent = JavaCompletionUtil.getOriginalElement(parent)) != parent) {
            for (PsiTypeParameter parameter : newParent.getTypeParameters()) {
                if (!parameter.getName().equals(param.getName())) continue;
                psiTypeParameter = parameter;
                if (psiTypeParameter == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/completion/JavaCompletionUtil.getOriginalElement must not return null");
                return psiTypeParameter;
            }
        }
        if ((psiTypeParameter = param) != null) return psiTypeParameter;
        throw new IllegalStateException("@NotNull method com/intellij/codeInsight/completion/JavaCompletionUtil.getOriginalElement must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static PsiClass getOriginalElement(@NotNull PsiClass cls) {
        PsiClass psiClass;
        PsiClass newParent;
        if (cls == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/JavaCompletionUtil.getOriginalElement must not be null");
        }
        PsiClass containingClass = cls.getContainingClass();
        if (containingClass != null && (newParent = JavaCompletionUtil.getOriginalElement(containingClass)) != containingClass) {
            psiClass = JavaCompletionUtil.findClassByName(cls, newParent.getInnerClasses());
            if (psiClass == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/completion/JavaCompletionUtil.getOriginalElement must not return null");
            return psiClass;
        }
        PsiFile containingFile = cls.getContainingFile();
        if (containingFile instanceof PsiClassOwner) {
            psiClass = JavaCompletionUtil.findClassByName(cls, ((PsiClassOwner)containingFile.getOriginalFile()).getClasses());
            if (psiClass == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/completion/JavaCompletionUtil.getOriginalElement must not return null");
            return psiClass;
        }
        psiClass = cls;
        if (psiClass != null) return psiClass;
        throw new IllegalStateException("@NotNull method com/intellij/codeInsight/completion/JavaCompletionUtil.getOriginalElement must not return null");
    }

    private static PsiClass findClassByName(PsiClass defResult, PsiClass[] classes) {
        String name = defResult.getName();
        if (name == null) {
            return defResult;
        }
        for (PsiClass candidate : classes) {
            if (!name.equals(candidate.getName())) continue;
            return candidate;
        }
        return defResult;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T extends PsiType> T originalize(@NotNull T type) {
        Object object;
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/JavaCompletionUtil.originalize must not be null");
        }
        if (!type.isValid()) {
            object = type;
            if (object == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/completion/JavaCompletionUtil.originalize must not return null");
            return object;
        }
        object = (PsiType)type.accept((PsiTypeVisitor)new PsiTypeVisitor<PsiType>(){

            public PsiType visitArrayType(PsiArrayType arrayType) {
                return new PsiArrayType(JavaCompletionUtil.originalize(arrayType.getComponentType()));
            }

            public PsiType visitCapturedWildcardType(PsiCapturedWildcardType capturedWildcardType) {
                return PsiCapturedWildcardType.create((PsiWildcardType)JavaCompletionUtil.originalize(capturedWildcardType.getWildcard()), (PsiElement)capturedWildcardType.getContext());
            }

            public PsiType visitClassType(PsiClassType classType) {
                PsiClassType.ClassResolveResult classResolveResult = classType.resolveGenerics();
                PsiClass psiClass = classResolveResult.getElement();
                PsiSubstitutor substitutor = classResolveResult.getSubstitutor();
                if (psiClass == null) {
                    return classType;
                }
                LOG.assertTrue(psiClass.isValid());
                return new PsiImmediateClassType(JavaCompletionUtil.getOriginalElement(psiClass), JavaCompletionUtil.originalize(substitutor));
            }

            public PsiType visitEllipsisType(PsiEllipsisType ellipsisType) {
                return new PsiEllipsisType(JavaCompletionUtil.originalize(ellipsisType.getComponentType()));
            }

            public PsiType visitPrimitiveType(PsiPrimitiveType primitiveType) {
                return primitiveType;
            }

            public PsiType visitType(PsiType type) {
                return type;
            }

            public PsiType visitWildcardType(PsiWildcardType wildcardType) {
                PsiType bound = wildcardType.getBound();
                PsiManager manager = wildcardType.getManager();
                if (bound == null) {
                    return PsiWildcardType.createUnbounded((PsiManager)manager);
                }
                return wildcardType.isExtends() ? PsiWildcardType.createExtends((PsiManager)manager, (PsiType)bound) : PsiWildcardType.createSuper((PsiManager)manager, (PsiType)bound);
            }
        });
        if (object != null) return object;
        throw new IllegalStateException("@NotNull method com/intellij/codeInsight/completion/JavaCompletionUtil.originalize must not return null");
    }

    @Nullable
    private static PsiSubstitutor originalize(@Nullable PsiSubstitutor substitutor) {
        if (substitutor == null) {
            return null;
        }
        PsiSubstitutor originalSubstitutor = PsiSubstitutor.EMPTY;
        for (Map.Entry entry : substitutor.getSubstitutionMap().entrySet()) {
            PsiType value = (PsiType)entry.getValue();
            originalSubstitutor = originalSubstitutor.put(JavaCompletionUtil.getOriginalElement((PsiTypeParameter)entry.getKey()), value == null ? null : JavaCompletionUtil.originalize(value));
        }
        return originalSubstitutor;
    }

    public static String[] getUnresolvedReferences(PsiElement parentOfType, final boolean referenceOnMethod) {
        if (parentOfType != null && parentOfType.getTextLength() > 50000) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        final ArrayList unresolvedRefs = new ArrayList();
        if (parentOfType != null) {
            parentOfType.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitReferenceExpression(PsiReferenceExpression reference) {
                    PsiElement parent = reference.getParent();
                    if (parent instanceof PsiReference) {
                        return;
                    }
                    if (referenceOnMethod && parent instanceof PsiMethodCallExpression && reference == ((PsiMethodCallExpression)parent).getMethodExpression()) {
                        if (reference.resolve() == null && reference.getReferenceName() != null) {
                            unresolvedRefs.add(reference.getReferenceName());
                        }
                    } else if (!referenceOnMethod && !(parent instanceof PsiMethodCallExpression) && reference.resolve() == null && reference.getReferenceName() != null) {
                        unresolvedRefs.add(reference.getReferenceName());
                    }
                }
            });
        }
        return ArrayUtil.toStringArray(unresolvedRefs);
    }

    public static void initOffsets(PsiFile file, Project project, OffsetMap offsetMap) {
        int selectionEndOffset = offsetMap.getOffset(CompletionInitializationContext.SELECTION_END_OFFSET);
        PsiElement element = file.findElementAt(selectionEndOffset);
        if (element == null) {
            return;
        }
        if (LEFT_PAREN.accepts((Object)element) && (element = file.findElementAt(--selectionEndOffset)) == null) {
            return;
        }
        PsiReference reference = file.findReferenceAt(selectionEndOffset);
        if (reference != null) {
            if (reference instanceof PsiJavaCodeReferenceElement) {
                offsetMap.addOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET, element.getParent().getTextRange().getEndOffset());
            } else {
                offsetMap.addOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET, reference.getElement().getTextRange().getStartOffset() + reference.getRangeInElement().getEndOffset());
            }
            element = file.findElementAt(offsetMap.getOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET));
        } else if (JavaCompletionUtil.isWord(element)) {
            if (element instanceof PsiIdentifier && element.getParent() instanceof PsiJavaCodeReferenceElement) {
                offsetMap.addOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET, element.getParent().getTextRange().getEndOffset());
            } else {
                offsetMap.addOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET, element.getTextRange().getEndOffset());
            }
            element = file.findElementAt(offsetMap.getOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET));
            if (element == null) {
                return;
            }
        }
        if (element instanceof PsiWhiteSpace && (!element.textContains('\n') || CodeStyleSettingsManager.getInstance((Project)project).getCurrentSettings().METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE)) {
            element = file.findElementAt(element.getTextRange().getEndOffset());
        }
        if (LEFT_PAREN.accepts((Object)element)) {
            offsetMap.addOffset(LPAREN_OFFSET, element.getTextRange().getStartOffset());
            PsiElement list = element.getParent();
            PsiElement last = list.getLastChild();
            if (last instanceof PsiJavaToken && ((PsiJavaToken)last).getTokenType() == JavaTokenType.RPARENTH) {
                offsetMap.addOffset(RPAREN_OFFSET, last.getTextRange().getStartOffset());
            }
            offsetMap.addOffset(ARG_LIST_END_OFFSET, list.getTextRange().getEndOffset());
        }
    }

    static boolean isWord(PsiElement element) {
        if (element instanceof PsiIdentifier) {
            return true;
        }
        if (element instanceof PsiKeyword) {
            return true;
        }
        if (element instanceof PsiJavaToken) {
            String text = element.getText();
            if ("true".equals(text)) {
                return true;
            }
            if ("false".equals(text)) {
                return true;
            }
            return "null".equals(text);
        }
        if (element instanceof PsiDocToken) {
            IElementType tokenType = ((PsiDocToken)element).getTokenType();
            return tokenType == JavaDocTokenType.DOC_TAG_VALUE_TOKEN || tokenType == JavaDocTokenType.DOC_TAG_NAME;
        }
        if (element instanceof XmlToken) {
            IElementType tokenType = ((XmlToken)element).getTokenType();
            return tokenType == XmlTokenType.XML_TAG_NAME || tokenType == XmlTokenType.XML_NAME || tokenType == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN || tokenType == XmlTokenType.XML_DATA_CHARACTERS && !(element.getParent() instanceof HtmlTag);
        }
        return false;
    }

    public static void resetParensInfo(OffsetMap offsetMap) {
        offsetMap.removeOffset(LPAREN_OFFSET);
        offsetMap.removeOffset(RPAREN_OFFSET);
        offsetMap.removeOffset(ARG_LIST_END_OFFSET);
        offsetMap.removeOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET);
    }

    @Nullable
    public static List<? extends PsiElement> getAllPsiElements(LookupElement item) {
        List allMethods = (List)item.getUserData(ALL_METHODS_ATTRIBUTE);
        if (allMethods != null) {
            return allMethods;
        }
        if (item.getObject() instanceof PsiElement) {
            return Arrays.asList((PsiElement)item.getObject());
        }
        return null;
    }

    @Nullable
    private static PsiType getPsiType(Object o) {
        if (o instanceof PsiVariable) {
            return ((PsiVariable)o).getType();
        }
        if (o instanceof PsiMethod) {
            return ((PsiMethod)o).getReturnType();
        }
        if (o instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)o;
            return JavaPsiFacade.getInstance((Project)psiClass.getProject()).getElementFactory().createType(psiClass);
        }
        if (o instanceof PsiExpression) {
            return ((PsiExpression)o).getType();
        }
        return null;
    }

    public static int getNameEndMatchingDegree(String name, ExpectedTypeInfo[] expectedInfos, String prefix) {
        int res = 0;
        if (name != null && expectedInfos != null) {
            if (prefix.equals(name)) {
                res = Integer.MAX_VALUE;
            } else {
                List words = NameUtil.nameToWordsLowerCase((String)name);
                List wordsNoDigits = NameUtil.nameToWordsLowerCase((String)JavaCompletionUtil.truncDigits(name));
                int max1 = JavaCompletionUtil.calcMatch(words, 0, expectedInfos);
                res = max1 = JavaCompletionUtil.calcMatch(wordsNoDigits, max1, expectedInfos);
            }
        }
        return res;
    }

    static String truncDigits(String name) {
        char c;
        int count;
        for (count = name.length() - 1; count >= 0 && Character.isDigit(c = name.charAt(count)); --count) {
        }
        return name.substring(0, count + 1);
    }

    static int calcMatch(List<String> words, int max, ExpectedTypeInfo[] myExpectedInfos) {
        for (ExpectedTypeInfo myExpectedInfo : myExpectedInfos) {
            String expectedName = ((ExpectedTypeInfoImpl)myExpectedInfo).expectedName;
            if (expectedName == null) continue;
            max = JavaCompletionUtil.calcMatch(expectedName, words, max);
            max = JavaCompletionUtil.calcMatch(JavaCompletionUtil.truncDigits(expectedName), words, max);
        }
        return max;
    }

    static int calcMatch(String expectedName, List<String> words, int max) {
        String expectedWord;
        String word;
        if (expectedName == null) {
            return max;
        }
        String[] expectedWords = NameUtil.nameToWords((String)expectedName);
        int limit = Math.min(words.size(), expectedWords.length);
        for (int i = 0; i < limit && (word = words.get(words.size() - i - 1)).equalsIgnoreCase(expectedWord = expectedWords[expectedWords.length - i - 1]); ++i) {
            max = Math.max(max, i + 1);
        }
        return max;
    }

    @Nullable
    static String getLookupObjectName(Object o) {
        if (o instanceof PsiVariable) {
            PsiVariable variable = (PsiVariable)o;
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)variable.getProject());
            VariableKind variableKind = codeStyleManager.getVariableKind(variable);
            return codeStyleManager.variableNameToPropertyName(variable.getName(), variableKind);
        }
        if (o instanceof PsiMethod) {
            return ((PsiMethod)o).getName();
        }
        return null;
    }

    @Nullable
    public static PsiType getLookupElementType(LookupElement element) {
        TypedLookupItem typed = JavaCompletionUtil.typedFrom(element);
        if (typed != null) {
            return typed.getType();
        }
        PsiType qualifierType = JavaCompletionUtil.getPsiType(element.getObject());
        LookupItem lookupItem = LookupItem.from(element);
        if (lookupItem != null) {
            Object o = lookupItem.getAttribute(LookupItem.TYPE);
            if (o instanceof PsiType) {
                return (PsiType)o;
            }
            PsiSubstitutor substitutor = (PsiSubstitutor)lookupItem.getAttribute(LookupItem.SUBSTITUTOR);
            if (substitutor != null) {
                return substitutor.substitute(qualifierType);
            }
        }
        return qualifierType;
    }

    @Nullable
    public static TypedLookupItem typedFrom(LookupElement element) {
        TypedLookupItem typed = null;
        if (element instanceof TypedLookupItem) {
            typed = (TypedLookupItem)element;
        } else if (element instanceof LookupElementDecorator && (element = ((LookupElementDecorator)element).getDelegate()) instanceof TypedLookupItem) {
            typed = (TypedLookupItem)element;
        }
        return typed;
    }

    @Nullable
    public static PsiType getQualifiedMemberReferenceType(@Nullable PsiType qualifierType, final @NotNull PsiMember member) {
        if (member == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/completion/JavaCompletionUtil.getQualifiedMemberReferenceType must not be null");
        }
        ClassCandidateInfo info = TypeConversionUtil.splitType((PsiType)qualifierType, (PsiElement)member);
        if (info == null) {
            return null;
        }
        PsiClass element = info.getElement();
        assert (element != null);
        final Ref subst = Ref.create((Object)PsiSubstitutor.EMPTY);
        class MyProcessor
        extends BaseScopeProcessor
        implements NameHint,
        ElementClassHint {
            MyProcessor() {
            }

            public boolean execute(PsiElement element, ResolveState state) {
                if (element == member) {
                    subst.set(state.get(PsiSubstitutor.KEY));
                }
                return true;
            }

            @Override
            public String getName(ResolveState state) {
                return member.getName();
            }

            @Override
            public boolean shouldProcess(ElementClassHint.DeclaractionKind kind) {
                return member instanceof PsiEnumConstant ? kind == ElementClassHint.DeclaractionKind.ENUM_CONST : (member instanceof PsiField ? kind == ElementClassHint.DeclaractionKind.FIELD : kind == ElementClassHint.DeclaractionKind.METHOD);
            }

            @Override
            public <T> T getHint(Key<T> hintKey) {
                return (T)(hintKey == NameHint.KEY || hintKey == ElementClassHint.KEY ? this : null);
            }
        }
        element.processDeclarations((PsiScopeProcessor)new MyProcessor(), ResolveState.initial().put(PsiSubstitutor.KEY, (Object)info.getSubstitutor()), null, (PsiElement)member);
        PsiType rawType = member instanceof PsiField ? ((PsiField)member).getType() : ((PsiMethod)member).getReturnType();
        return ((PsiSubstitutor)subst.get()).substitute(rawType);
    }

    public static Set<LookupElement> processJavaReference(PsiElement element, PsiJavaReference javaReference, ElementFilter elementFilter, boolean checkAccess, final @Nullable PrefixMatcher matcher, CompletionParameters parameters) {
        THashSet set = new THashSet();
        Condition<String> nameCondition = matcher == null ? null : new Condition<String>(){

            public boolean value(String s) {
                return matcher.prefixMatches(s);
            }
        };
        JavaCompletionProcessor processor = new JavaCompletionProcessor(element, elementFilter, checkAccess, nameCondition);
        javaReference.processVariants((PsiScopeProcessor)processor);
        Set<CompletionElement> plainResults = processor.getResults();
        PsiType qualifierType = processor.getQualifierType();
        PsiType castedQualifierType = JavaCompletionUtil.addQualifierCastingVariants(javaReference, processor, (THashSet<LookupElement>)set, parameters);
        boolean mayHighlight = qualifierType != null && (castedQualifierType == null || !qualifierType.isAssignableFrom(castedQualifierType));
        for (CompletionElement completionElement : plainResults) {
            LookupElement item = JavaCompletionUtil.createLookupElement(completionElement, qualifierType);
            if (item == null) continue;
            set.add(mayHighlight ? JavaCompletionUtil.highlightIfNeeded(qualifierType, item) : item);
        }
        return set;
    }

    @Nullable
    private static PsiType addQualifierCastingVariants(PsiJavaReference javaReference, JavaCompletionProcessor processor, THashSet<LookupElement> set, CompletionParameters parameters) {
        PsiReferenceExpression refExpr;
        PsiExpression qualifier;
        if (javaReference instanceof PsiReferenceExpression && (qualifier = (refExpr = (PsiReferenceExpression)javaReference).getQualifierExpression()) != null) {
            Project project = qualifier.getProject();
            PairFunction evaluator = (PairFunction)refExpr.getContainingFile().getCopyableUserData(DYNAMIC_TYPE_EVALUATOR);
            PsiType type = null;
            if (evaluator != null) {
                type = (PsiType)evaluator.fun((Object)qualifier, (Object)parameters);
            }
            if (type == null) {
                type = GuessManager.getInstance(project).getControlFlowExpressionType(qualifier);
            }
            if (type != null) {
                processor.clear();
                return JavaCompletionUtil.addQualifierCastingVariants(processor, refExpr, type, set);
            }
        }
        return null;
    }

    private static PsiType addQualifierCastingVariants(JavaCompletionProcessor processor, PsiReferenceExpression refExpr, PsiType castTo, THashSet<LookupElement> set) {
        Project project = refExpr.getProject();
        PsiExpression qualifier = refExpr.getQualifierExpression();
        assert (qualifier != null);
        String newText = "((" + castTo.getCanonicalText() + ") " + qualifier.getText() + ")." + refExpr.getReferenceName();
        PsiExpression newRef = JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(newText, (PsiElement)refExpr);
        ((PsiReferenceExpression)newRef).processVariants((PsiScopeProcessor)processor);
        LookupItem castItem = PsiTypeLookupItem.createLookupItem(castTo, (PsiElement)refExpr);
        for (CompletionElement completionElement : processor.getResults()) {
            LookupItem<?> item = JavaCompletionUtil.createLookupElement(completionElement, castTo);
            if (item == null) continue;
            set.add((Object)JavaCompletionUtil.highlightIfNeeded(castTo, JavaCompletionUtil.castQualifier(project, item, (LookupElement)castItem)));
        }
        return castTo;
    }

    private static LookupElementDecorator<LookupElement> castQualifier(final Project project, LookupElement item, final LookupElement to) {
        return LookupElementDecorator.withInsertHandler((LookupElement)item, (InsertHandler)new InsertHandlerDecorator<LookupElement>(){

            public void handleInsert(InsertionContext context, LookupElementDecorator<LookupElement> item) {
                PsiElement qualifier;
                Document document = context.getEditor().getDocument();
                PsiDocumentManager.getInstance((Project)project).commitDocument(document);
                PsiFile file = context.getFile();
                PsiReferenceExpression ref = (PsiReferenceExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)context.getStartOffset(), PsiReferenceExpression.class, (boolean)false);
                if (ref != null && (qualifier = ref.getQualifier()) != null) {
                    CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)project);
                    String parenSpace = settings.SPACE_WITHIN_PARENTHESES ? " " : "";
                    document.insertString(qualifier.getTextRange().getEndOffset(), (CharSequence)(parenSpace + ")"));
                    String spaceWithin = settings.SPACE_WITHIN_CAST_PARENTHESES ? " " : "";
                    String prefix = "(" + parenSpace + "(" + spaceWithin;
                    String spaceAfter = settings.SPACE_AFTER_TYPE_CAST ? " " : "";
                    int exprStart = qualifier.getTextRange().getStartOffset();
                    document.insertString(exprStart, (CharSequence)(prefix + spaceWithin + ")" + spaceAfter));
                    CompletionUtil.emulateInsertion(context, exprStart + prefix.length(), to);
                }
                item.getDelegate().handleInsert(context);
            }
        });
    }

    private static LookupElement highlightIfNeeded(@NotNull PsiType qualifierType, @NotNull LookupElement item) {
        if (qualifierType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/JavaCompletionUtil.highlightIfNeeded must not be null");
        }
        if (item == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/completion/JavaCompletionUtil.highlightIfNeeded must not be null");
        }
        Object o = item.getObject();
        if (qualifierType instanceof PsiArrayType) {
            PsiElement parent;
            if ((o instanceof PsiField || o instanceof PsiMethod) && (parent = ((PsiElement)o).getParent()) instanceof PsiClass && parent.getContainingFile().getVirtualFile() == null) {
                return JavaCompletionUtil.highlight(item);
            }
        } else if (qualifierType instanceof PsiClassType) {
            PsiElement parent;
            PsiClass qualifierClass = ((PsiClassType)qualifierType).resolve();
            if ((o instanceof PsiField || o instanceof PsiMethod || o instanceof PsiClass) && (parent = ((PsiElement)o).getParent()) != null && parent.equals(qualifierClass)) {
                return JavaCompletionUtil.highlight(item);
            }
        }
        return item;
    }

    private static LookupElementDecorator<LookupElement> highlight(LookupElement decorator) {
        return LookupElementDecorator.withRenderer((LookupElement)decorator, (LookupElementRenderer)new LookupElementRenderer<LookupElementDecorator<LookupElement>>(){

            public void renderElement(LookupElementDecorator<LookupElement> element, LookupElementPresentation presentation) {
                element.getDelegate().renderElement(presentation);
                presentation.setItemTextBold(true);
            }
        });
    }

    private static LookupItem<?> createLookupElement(CompletionElement completionElement, PsiType qualifierType) {
        Object completion = completionElement.getElement();
        assert (!(completion instanceof LookupElement));
        LookupElement _ret = LookupItemUtil.objectToLookupItem(completion);
        if (_ret == null || !(_ret instanceof LookupItem)) {
            return null;
        }
        LookupItem ret = (LookupItem)_ret;
        PsiSubstitutor substitutor = completionElement.getSubstitutor();
        if (substitutor != null) {
            ret.setAttribute(LookupItem.SUBSTITUTOR, substitutor);
        }
        ret.putUserData(QUALIFIER_TYPE_ATTR, qualifierType);
        return ret;
    }

    public static boolean hasAccessibleConstructor(PsiType type) {
        if (type instanceof PsiArrayType) {
            return true;
        }
        PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)type);
        if (psiClass == null) {
            return false;
        }
        if (!(psiClass instanceof PsiCompiledElement)) {
            return true;
        }
        PsiMethod[] methods = psiClass.getConstructors();
        if (methods.length == 0) {
            return true;
        }
        for (PsiMethod method : methods) {
            if (method.hasModifierProperty("private")) continue;
            return true;
        }
        return false;
    }

    public static LookupItem qualify(LookupItem ret) {
        PsiMember completionElement = (PsiMember)ret.getObject();
        PsiClass containingClass = completionElement.getContainingClass();
        if (containingClass != null) {
            String className = containingClass.getName();
            ret.setLookupString(className + "." + ret.getLookupString());
        }
        return ret.forceQualify();
    }

    public static LookupItem setShowFQN(LookupItem ret) {
        PsiClass psiClass = (PsiClass)ret.getObject();
        String packageName = PsiFormatUtil.getPackageDisplayName((PsiClass)psiClass);
        String tailText = (String)ret.getAttribute(LookupItem.TAIL_TEXT_ATTR);
        ret.setAttribute(LookupItem.TAIL_TEXT_ATTR, StringUtil.notNullize((String)tailText) + " (" + packageName + ")");
        ret.setAttribute(LookupItem.TAIL_TEXT_SMALL_ATTR, "");
        return ret;
    }

    @Nullable
    static PsiElement getQualifier(PsiElement element) {
        return element instanceof PsiJavaCodeReferenceElement ? ((PsiJavaCodeReferenceElement)element).getQualifier() : null;
    }

    public static boolean containsMethodCalls(@Nullable PsiElement qualifier) {
        if (qualifier == null) {
            return false;
        }
        if (qualifier instanceof PsiMethodCallExpression) {
            return true;
        }
        return JavaCompletionUtil.containsMethodCalls(JavaCompletionUtil.getQualifier(qualifier));
    }

    @Nullable
    static ElementFilter recursionFilter(PsiElement element) {
        if (((PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"return"})).inside(PsiReturnStatement.class)).accepts((Object)element)) {
            return new ExcludeDeclaredFilter(ElementClassFilter.METHOD);
        }
        if (((PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().inside(PsiJavaPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiElement(PsiAssignmentExpression.class), PsiJavaPatterns.psiElement(PsiVariable.class)}))).andNot((ElementPattern)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"."}))).accepts((Object)element)) {
            return new AndFilter((ElementFilter)new ExcludeSillyAssignment(), (ElementFilter)new ExcludeDeclaredFilter(new ClassFilter(PsiVariable.class)));
        }
        return null;
    }
}

