/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.GeneralHighlightingPass;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.JavaHightlightInfoTypes;
import com.intellij.codeInsight.daemon.impl.RefCountHolder;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightLevelUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMessageUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMethodUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateConstructorParameterFromFieldFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateGetterOrSetterFix;
import com.intellij.codeInsight.daemon.impl.quickfix.EnableOptimizeImportsOnTheFlyFix;
import com.intellij.codeInsight.daemon.impl.quickfix.OptimizeImportsFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.daemon.impl.quickfix.RemoveUnusedParameterFix;
import com.intellij.codeInsight.daemon.impl.quickfix.RemoveUnusedVariableFix;
import com.intellij.codeInsight.daemon.impl.quickfix.SafeDeleteFix;
import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.deadCode.UnusedDeclarationInspection;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.unusedSymbol.UnusedSymbolLocalInspection;
import com.intellij.codeInspection.util.SpecialAnnotationsUtil;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.source.jsp.jspJava.JspxImportStatement;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.jsp.JspSpiUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import gnu.trove.THashSet;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class PostHighlightingPass
extends TextEditorHighlightingPass {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.PostHighlightingPass");
    private RefCountHolder myRefCountHolder;
    private final PsiFile myFile;
    @Nullable
    private final Editor myEditor;
    private final int myStartOffset;
    private final int myEndOffset;
    private Collection<HighlightInfo> myHighlights;
    private boolean myHasRedundantImports;
    private final JavaCodeStyleManager myStyleManager;
    private int myCurentEntryIndex;
    private boolean myHasMissortedImports;
    private final ImplicitUsageProvider[] myImplicitUsageProviders;
    private UnusedDeclarationInspection myDeadCodeInspection;
    private UnusedSymbolLocalInspection myUnusedSymbolInspection;
    private HighlightDisplayKey myUnusedSymbolKey;
    private boolean myDeadCodeEnabled;
    private boolean myInLibrary;
    private HighlightDisplayKey myDeadCodeKey;
    private HighlightInfoType myDeadCodeInfoType;
    private static final int USED = 1;
    private static final int UNUSED_LOCALLY = 2;
    private static final int UNUSED_GLOBALLY = 3;
    private final TObjectIntHashMap<PsiClass> unusedClassCache;

    private PostHighlightingPass(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull Document document, int startOffset, int endOffset) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/PostHighlightingPass.<init> must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/PostHighlightingPass.<init> must not be null");
        }
        if (document == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/PostHighlightingPass.<init> must not be null");
        }
        super(project, document, true);
        this.unusedClassCache = new TObjectIntHashMap();
        this.myFile = file;
        this.myEditor = editor;
        this.myStartOffset = startOffset;
        this.myEndOffset = endOffset;
        this.myStyleManager = JavaCodeStyleManager.getInstance((Project)this.myProject);
        this.myCurentEntryIndex = -1;
        this.myImplicitUsageProviders = (ImplicitUsageProvider[])Extensions.getExtensions((ExtensionPointName)ImplicitUsageProvider.EP_NAME);
    }

    PostHighlightingPass(@NotNull Project project, @NotNull PsiFile file, @NotNull Editor editor, int startOffset, int endOffset) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/PostHighlightingPass.<init> must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/PostHighlightingPass.<init> must not be null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/PostHighlightingPass.<init> must not be null");
        }
        this(project, file, editor, editor.getDocument(), startOffset, endOffset);
    }

    public PostHighlightingPass(@NotNull Project project, @NotNull PsiFile file, @NotNull Document document, int startOffset, int endOffset) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/PostHighlightingPass.<init> must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/PostHighlightingPass.<init> must not be null");
        }
        if (document == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/PostHighlightingPass.<init> must not be null");
        }
        this(project, file, null, document, startOffset, endOffset);
    }

    @Override
    public void doCollectInformation(ProgressIndicator progress) {
        VirtualFile virtualFile;
        DaemonCodeAnalyzer daemonCodeAnalyzer = DaemonCodeAnalyzer.getInstance((Project)this.myProject);
        FileStatusMap fileStatusMap = ((DaemonCodeAnalyzerImpl)daemonCodeAnalyzer).getFileStatusMap();
        ArrayList highlights = new ArrayList();
        FileViewProvider viewProvider = this.myFile.getViewProvider();
        Set relevantLanguages = viewProvider.getLanguages();
        THashSet elementSet = new THashSet();
        for (Language language : relevantLanguages) {
            PsiFile psiRoot = viewProvider.getPsi(language);
            if (!HighlightLevelUtil.shouldHighlight((PsiElement)psiRoot)) continue;
            List<PsiElement> elements = CollectHighlightsUtil.getElementsInRange((PsiElement)psiRoot, this.myStartOffset, this.myEndOffset);
            elementSet.addAll(elements);
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        this.myInLibrary = fileIndex.isInLibraryClasses(virtualFile = viewProvider.getVirtualFile()) || fileIndex.isInLibrarySource(virtualFile);
        this.myRefCountHolder = RefCountHolder.getInstance(this.myFile);
        if (!this.myRefCountHolder.retrieveUnusedReferencesInfo(new Runnable((Set)elementSet, highlights, progress, fileStatusMap){
            final /* synthetic */ Set val$elementSet;
            final /* synthetic */ List val$highlights;
            final /* synthetic */ ProgressIndicator val$progress;
            final /* synthetic */ FileStatusMap val$fileStatusMap;
            {
                this.val$elementSet = set;
                this.val$highlights = list;
                this.val$progress = progressIndicator;
                this.val$fileStatusMap = fileStatusMap;
            }

            @Override
            public void run() {
                PostHighlightingPass.this.collectHighlights(this.val$elementSet, this.val$highlights, this.val$progress);
                PostHighlightingPass.this.myHighlights = this.val$highlights;
                for (HighlightInfo info : this.val$highlights) {
                    if (info.getSeverity() != HighlightSeverity.ERROR) continue;
                    this.val$fileStatusMap.setErrorFoundFlag(PostHighlightingPass.this.myDocument, true);
                    break;
                }
            }
        })) {
            fileStatusMap.markFileScopeDirty(this.getDocument(), 4);
            GeneralHighlightingPass.cancelAndRestartDaemonLater(progress, this.myProject, this);
        }
    }

    @Override
    public void doApplyInformationToEditor() {
        if (this.myHighlights == null) {
            return;
        }
        UpdateHighlightersUtil.setHighlightersToEditor(this.myProject, this.myDocument, this.myStartOffset, this.myEndOffset, this.myHighlights, 5);
        DaemonCodeAnalyzer daemonCodeAnalyzer = DaemonCodeAnalyzer.getInstance((Project)this.myProject);
        ((DaemonCodeAnalyzerImpl)daemonCodeAnalyzer).getFileStatusMap().markFileUpToDate(this.myDocument, this.myFile, this.getId());
        if (this.timeToOptimizeImports() && this.myEditor != null) {
            this.optimizeImportsOnTheFly();
        }
    }

    private void optimizeImportsOnTheFly() {
        if (this.myHasRedundantImports || this.myHasMissortedImports) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    CommandProcessor.getInstance().runUndoTransparentAction(new Runnable(){

                        @Override
                        public void run() {
                            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                                @Override
                                public void run() {
                                    OptimizeImportsFix optimizeImportsFix = new OptimizeImportsFix();
                                    if (optimizeImportsFix.isAvailable(PostHighlightingPass.this.myProject, PostHighlightingPass.this.myEditor, PostHighlightingPass.this.myFile) && PostHighlightingPass.this.myFile.isWritable()) {
                                        PsiDocumentManager.getInstance((Project)PostHighlightingPass.this.myProject).commitAllDocuments();
                                        optimizeImportsFix.invoke(PostHighlightingPass.this.myProject, PostHighlightingPass.this.myEditor, PostHighlightingPass.this.myFile);
                                    }
                                }
                            });
                        }
                    });
                }
            });
        }
    }

    public Collection<HighlightInfo> getHighlights() {
        return this.myHighlights;
    }

    private void collectHighlights(@NotNull Collection<PsiElement> elements, @NotNull List<HighlightInfo> result, @NotNull ProgressIndicator progress) throws ProcessCanceledException {
        JspFile jspFile;
        if (elements == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/PostHighlightingPass.collectHighlights must not be null");
        }
        if (result == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/PostHighlightingPass.collectHighlights must not be null");
        }
        if (progress == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/PostHighlightingPass.collectHighlights must not be null");
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        InspectionProfile profile = InspectionProjectProfileManager.getInstance(this.myProject).getInspectionProfile();
        this.myUnusedSymbolKey = HighlightDisplayKey.find((String)"UNUSED_SYMBOL");
        boolean unusedSymbolEnabled = profile.isToolEnabled(this.myUnusedSymbolKey, (PsiElement)this.myFile);
        HighlightDisplayKey unusedImportKey = HighlightDisplayKey.find((String)"UNUSED_IMPORT");
        boolean unusedImportEnabled = profile.isToolEnabled(unusedImportKey, (PsiElement)this.myFile);
        LocalInspectionToolWrapper unusedSymbolTool = (LocalInspectionToolWrapper)profile.getInspectionTool("UNUSED_SYMBOL", (PsiElement)this.myFile);
        this.myUnusedSymbolInspection = unusedSymbolTool == null ? null : (UnusedSymbolLocalInspection)unusedSymbolTool.getTool();
        LOG.assertTrue(ApplicationManager.getApplication().isUnitTestMode() || this.myUnusedSymbolInspection != null);
        this.myDeadCodeKey = HighlightDisplayKey.find((String)"UnusedDeclaration");
        this.myDeadCodeInspection = (UnusedDeclarationInspection)profile.getInspectionTool("UnusedDeclaration", (PsiElement)this.myFile);
        this.myDeadCodeEnabled = profile.isToolEnabled(this.myDeadCodeKey, (PsiElement)this.myFile);
        if (unusedImportEnabled && JspPsiUtil.isInJspFile((PsiElement)this.myFile) && (jspFile = JspPsiUtil.getJspFile((PsiElement)this.myFile)) != null) {
            unusedImportEnabled = !JspSpiUtil.isIncludedOrIncludesSomething(jspFile);
        }
        HighlightInfoType highlightInfoType = this.myDeadCodeInfoType = this.myDeadCodeKey == null ? null : new HighlightInfoType.HighlightInfoTypeImpl(profile.getErrorLevel(this.myDeadCodeKey, (PsiElement)this.myFile).getSeverity(), HighlightInfoType.UNUSED_SYMBOL.getAttributesKey());
        if (!unusedSymbolEnabled && !unusedImportEnabled) {
            return;
        }
        for (PsiElement element : elements) {
            PsiImportStatementBase[] imports;
            progress.checkCanceled();
            if (unusedSymbolEnabled && element instanceof PsiIdentifier) {
                PsiIdentifier identifier = (PsiIdentifier)element;
                HighlightInfo info = this.processIdentifier(identifier, progress);
                if (info == null) continue;
                result.add(info);
                continue;
            }
            if (!unusedImportEnabled || !(element instanceof PsiImportList)) continue;
            for (PsiImportStatementBase statement : imports = ((PsiImportList)element).getAllImportStatements()) {
                ProgressManager.checkCanceled();
                HighlightInfo info = this.processImport(statement, unusedImportKey);
                if (info == null) continue;
                result.add(info);
            }
        }
    }

    @Nullable
    private HighlightInfo processIdentifier(PsiIdentifier identifier, ProgressIndicator progress) {
        HighlightInfo info;
        if (InspectionManagerEx.inspectionResultSuppressed((PsiElement)identifier, (LocalInspectionTool)this.myUnusedSymbolInspection)) {
            return null;
        }
        PsiElement parent = identifier.getParent();
        if (PsiUtilBase.hasErrorElementChild((PsiElement)parent)) {
            return null;
        }
        if (parent instanceof PsiLocalVariable && this.myUnusedSymbolInspection.LOCAL_VARIABLE) {
            info = this.processLocalVariable((PsiLocalVariable)parent, progress);
        } else if (parent instanceof PsiField && this.myUnusedSymbolInspection.FIELD) {
            PsiField psiField = (PsiField)parent;
            info = this.processField(psiField, identifier, progress);
        } else if (parent instanceof PsiParameter && this.myUnusedSymbolInspection.PARAMETER) {
            info = this.processParameter((PsiParameter)parent, progress);
        } else if (parent instanceof PsiMethod && this.myUnusedSymbolInspection.METHOD) {
            info = this.processMethod((PsiMethod)parent, progress);
        } else if (parent instanceof PsiClass && identifier.equals(((PsiClass)parent).getNameIdentifier()) && this.myUnusedSymbolInspection.CLASS) {
            info = this.processClass((PsiClass)parent, progress);
        } else {
            return null;
        }
        return info;
    }

    @Nullable
    private HighlightInfo processLocalVariable(PsiLocalVariable variable, ProgressIndicator progress) {
        PsiIdentifier identifier = variable.getNameIdentifier();
        if (identifier == null) {
            return null;
        }
        if (this.isImplicitUsage((PsiModifierListOwner)variable, progress)) {
            return null;
        }
        if (!this.myRefCountHolder.isReferenced((PsiNamedElement)variable)) {
            String message = JavaErrorMessages.message("local.variable.is.never.used", identifier.getText());
            HighlightInfo highlightInfo = PostHighlightingPass.createUnusedSymbolInfo((PsiElement)identifier, message, HighlightInfoType.UNUSED_SYMBOL);
            QuickFixAction.registerQuickFixAction(highlightInfo, new RemoveUnusedVariableFix((PsiVariable)variable), this.myUnusedSymbolKey);
            return highlightInfo;
        }
        boolean referenced = this.myRefCountHolder.isReferencedForRead((PsiElement)variable);
        if (!referenced && !this.isImplicitRead((PsiVariable)variable, progress)) {
            String message = JavaErrorMessages.message("local.variable.is.not.used.for.reading", identifier.getText());
            HighlightInfo highlightInfo = PostHighlightingPass.createUnusedSymbolInfo((PsiElement)identifier, message, HighlightInfoType.UNUSED_SYMBOL);
            QuickFixAction.registerQuickFixAction(highlightInfo, new RemoveUnusedVariableFix((PsiVariable)variable), this.myUnusedSymbolKey);
            return highlightInfo;
        }
        if (!(variable.hasInitializer() || (referenced = this.myRefCountHolder.isReferencedForWrite((PsiElement)variable)) || this.isImplicitWrite((PsiVariable)variable, progress))) {
            String message = JavaErrorMessages.message("local.variable.is.not.assigned", identifier.getText());
            HighlightInfo unusedSymbolInfo = PostHighlightingPass.createUnusedSymbolInfo((PsiElement)identifier, message, HighlightInfoType.UNUSED_SYMBOL);
            QuickFixAction.registerQuickFixAction(unusedSymbolInfo, new EmptyIntentionAction(UnusedSymbolLocalInspection.DISPLAY_NAME), this.myUnusedSymbolKey);
            return unusedSymbolInfo;
        }
        return null;
    }

    private boolean isImplicitUsage(PsiModifierListOwner element, ProgressIndicator progress) {
        if (UnusedSymbolLocalInspection.isInjected(element, this.myUnusedSymbolInspection)) {
            return true;
        }
        for (ImplicitUsageProvider provider : this.myImplicitUsageProviders) {
            progress.checkCanceled();
            if (!provider.isImplicitUsage((PsiElement)element)) continue;
            return true;
        }
        return false;
    }

    private boolean isImplicitRead(PsiVariable element, ProgressIndicator progress) {
        for (ImplicitUsageProvider provider : this.myImplicitUsageProviders) {
            progress.checkCanceled();
            if (!provider.isImplicitRead((PsiElement)element)) continue;
            return true;
        }
        return false;
    }

    private boolean isImplicitWrite(PsiVariable element, ProgressIndicator progress) {
        for (ImplicitUsageProvider provider : this.myImplicitUsageProviders) {
            progress.checkCanceled();
            if (!provider.isImplicitWrite((PsiElement)element)) continue;
            return true;
        }
        return false;
    }

    private static HighlightInfo createUnusedSymbolInfo(PsiElement element, String message, HighlightInfoType highlightInfoType) {
        return HighlightInfo.createHighlightInfo(highlightInfoType, element, message);
    }

    @Nullable
    private HighlightInfo processField(PsiField field, PsiIdentifier identifier, ProgressIndicator progress) {
        if (this.isImplicitUsage((PsiModifierListOwner)field, progress)) {
            return null;
        }
        if (field.hasModifierProperty("private")) {
            if (!this.myRefCountHolder.isReferenced((PsiNamedElement)field)) {
                if (HighlightUtil.isSerializationImplicitlyUsedField(field)) {
                    return null;
                }
                String message = JavaErrorMessages.message("private.field.is.not.used", identifier.getText());
                HighlightInfo highlightInfo = this.suggestionsToMakeFieldUsed(field, identifier, message);
                QuickFixAction.registerQuickFixAction(highlightInfo, HighlightMethodUtil.getFixRange((PsiElement)field), new CreateConstructorParameterFromFieldFix(field), null);
                return highlightInfo;
            }
            boolean readReferenced = this.myRefCountHolder.isReferencedForRead((PsiElement)field);
            if (!readReferenced && !this.isImplicitRead((PsiVariable)field, progress)) {
                String message = JavaErrorMessages.message("private.field.is.not.used.for.reading", identifier.getText());
                return this.suggestionsToMakeFieldUsed(field, identifier, message);
            }
            if (field.hasInitializer()) {
                return null;
            }
            boolean writeReferenced = this.myRefCountHolder.isReferencedForWrite((PsiElement)field);
            if (!writeReferenced && !this.isImplicitWrite((PsiVariable)field, progress)) {
                String message = JavaErrorMessages.message("private.field.is.not.assigned", identifier.getText());
                final HighlightInfo info = PostHighlightingPass.createUnusedSymbolInfo((PsiElement)identifier, message, HighlightInfoType.UNUSED_SYMBOL);
                QuickFixAction.registerQuickFixAction(info, new CreateGetterOrSetterFix(false, true, field), this.myUnusedSymbolKey);
                QuickFixAction.registerQuickFixAction(info, HighlightMethodUtil.getFixRange((PsiElement)field), new CreateConstructorParameterFromFieldFix(field), null);
                SpecialAnnotationsUtil.createAddToSpecialAnnotationFixes((PsiModifierListOwner)field, new Processor<String>(){

                    public boolean process(String annoName) {
                        QuickFixAction.registerQuickFixAction(info, PostHighlightingPass.this.myUnusedSymbolInspection.createQuickFix(annoName, "fields"));
                        return true;
                    }
                });
                return info;
            }
        } else if (!this.myRefCountHolder.isReferenced((PsiNamedElement)field) && this.weAreSureThereAreNoUsages((PsiMember)field, progress)) {
            return this.formatUnusedSymbolHighlightInfo("field.is.not.used", (PsiNameIdentifierOwner)field, "fields", this.myDeadCodeKey, this.myDeadCodeInfoType);
        }
        return null;
    }

    private HighlightInfo suggestionsToMakeFieldUsed(PsiField field, PsiIdentifier identifier, String message) {
        HighlightInfo highlightInfo = PostHighlightingPass.createUnusedSymbolInfo((PsiElement)identifier, message, HighlightInfoType.UNUSED_SYMBOL);
        QuickFixAction.registerQuickFixAction(highlightInfo, new RemoveUnusedVariableFix((PsiVariable)field), this.myUnusedSymbolKey);
        QuickFixAction.registerQuickFixAction(highlightInfo, new CreateGetterOrSetterFix(true, false, field), this.myUnusedSymbolKey);
        QuickFixAction.registerQuickFixAction(highlightInfo, new CreateGetterOrSetterFix(false, true, field), this.myUnusedSymbolKey);
        QuickFixAction.registerQuickFixAction(highlightInfo, new CreateGetterOrSetterFix(true, true, field), this.myUnusedSymbolKey);
        return highlightInfo;
    }

    private static boolean isOverriddenOrOverrides(PsiMethod method) {
        boolean overrides = SuperMethodsSearch.search((PsiMethod)method, null, (boolean)true, (boolean)false).findFirst() != null;
        return overrides || OverridingMethodsSearch.search((PsiMethod)method).findFirst() != null;
    }

    @Nullable
    private HighlightInfo processParameter(PsiParameter parameter, ProgressIndicator progress) {
        HighlightInfo highlightInfo;
        PsiElement declarationScope = parameter.getDeclarationScope();
        if (declarationScope instanceof PsiMethod) {
            HighlightInfo highlightInfo2;
            PsiMethod method = (PsiMethod)declarationScope;
            if (PsiUtilBase.hasErrorElementChild((PsiElement)method)) {
                return null;
            }
            if ((method.isConstructor() || method.hasModifierProperty("private") || method.hasModifierProperty("static") || !method.hasModifierProperty("abstract") && this.myUnusedSymbolInspection.REPORT_PARAMETER_FOR_PUBLIC_METHODS && !PostHighlightingPass.isOverriddenOrOverrides(method)) && !method.hasModifierProperty("native") && !HighlightMethodUtil.isSerializationRelatedMethod(method, method.getContainingClass()) && !PsiClassImplUtil.isMainMethod(method) && (highlightInfo2 = this.checkUnusedParameter(parameter, progress)) != null) {
                QuickFixAction.registerQuickFixAction(highlightInfo2, (IntentionAction)new RemoveUnusedParameterFix(parameter), this.myUnusedSymbolKey);
                return highlightInfo2;
            }
        } else if (declarationScope instanceof PsiForeachStatement && (highlightInfo = this.checkUnusedParameter(parameter, progress)) != null) {
            QuickFixAction.registerQuickFixAction(highlightInfo, new EmptyIntentionAction(UnusedSymbolLocalInspection.DISPLAY_NAME), this.myUnusedSymbolKey);
            return highlightInfo;
        }
        return null;
    }

    @Nullable
    private HighlightInfo checkUnusedParameter(PsiParameter parameter, ProgressIndicator progress) {
        if (!this.myRefCountHolder.isReferenced((PsiNamedElement)parameter) && !this.isImplicitUsage((PsiModifierListOwner)parameter, progress)) {
            PsiIdentifier identifier = parameter.getNameIdentifier();
            assert (identifier != null);
            String message = JavaErrorMessages.message("parameter.is.not.used", identifier.getText());
            return PostHighlightingPass.createUnusedSymbolInfo((PsiElement)identifier, message, HighlightInfoType.UNUSED_SYMBOL);
        }
        return null;
    }

    @Nullable
    private HighlightInfo processMethod(PsiMethod method, ProgressIndicator progress) {
        if (this.myRefCountHolder.isReferenced((PsiNamedElement)method)) {
            return null;
        }
        boolean isPrivate = method.hasModifierProperty("private");
        PsiClass containingClass = method.getContainingClass();
        HighlightInfoType highlightInfoType = HighlightInfoType.UNUSED_SYMBOL;
        HighlightDisplayKey highlightDisplayKey = this.myUnusedSymbolKey;
        if (isPrivate) {
            if (HighlightMethodUtil.isSerializationRelatedMethod(method, containingClass) || PostHighlightingPass.isIntentionalPrivateConstructor(method, containingClass)) {
                return null;
            }
            if (this.isImplicitUsage((PsiModifierListOwner)method, progress)) {
                return null;
            }
        } else {
            if (containingClass != null && method.isConstructor() && containingClass.getConstructors().length == 1 && this.isClassUnused(containingClass, progress) == 1) {
                return null;
            }
            if (this.isImplicitUsage((PsiModifierListOwner)method, progress)) {
                return null;
            }
            if (method.findSuperMethods().length != 0) {
                return null;
            }
            if (!this.weAreSureThereAreNoUsages((PsiMember)method, progress)) {
                return null;
            }
            highlightInfoType = this.myDeadCodeInfoType;
            highlightDisplayKey = this.myDeadCodeKey;
        }
        String key = isPrivate ? (method.isConstructor() ? "private.constructor.is.not.used" : "private.method.is.not.used") : (method.isConstructor() ? "constructor.is.not.used" : "method.is.not.used");
        String symbolName = HighlightMessageUtil.getSymbolName((PsiElement)method, PsiSubstitutor.EMPTY);
        String message = JavaErrorMessages.message(key, symbolName);
        PsiIdentifier identifier = method.getNameIdentifier();
        final HighlightInfo highlightInfo = PostHighlightingPass.createUnusedSymbolInfo((PsiElement)identifier, message, highlightInfoType);
        QuickFixAction.registerQuickFixAction(highlightInfo, new SafeDeleteFix((PsiElement)method), highlightDisplayKey);
        SpecialAnnotationsUtil.createAddToSpecialAnnotationFixes((PsiModifierListOwner)method, new Processor<String>(){

            public boolean process(String annoName) {
                QuickFixAction.registerQuickFixAction(highlightInfo, PostHighlightingPass.this.myUnusedSymbolInspection.createQuickFix(annoName, "methods"));
                return true;
            }
        });
        return highlightInfo;
    }

    private boolean weAreSureThereAreNoUsages(PsiMember member, ProgressIndicator progress) {
        PsiSearchHelper.SearchCostResult cheapEnough;
        if (this.myInLibrary) {
            return false;
        }
        if (!this.myDeadCodeEnabled) {
            return false;
        }
        if (this.myDeadCodeInspection.isEntryPoint((PsiElement)member)) {
            return false;
        }
        String name = member.getName();
        if (name == null) {
            return false;
        }
        SearchScope useScope = member.getUseScope();
        if (!(useScope instanceof GlobalSearchScope)) {
            return false;
        }
        GlobalSearchScope scope = (GlobalSearchScope)useScope;
        if (member instanceof PsiClass) {
            scope = scope.uniteWith(GlobalSearchScope.projectScope((Project)this.myProject));
        }
        if ((cheapEnough = this.myFile.getManager().getSearchHelper().isCheapEnoughToSearch(name, scope, this.myFile, progress)) == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES) {
            return false;
        }
        if (cheapEnough == PsiSearchHelper.SearchCostResult.ZERO_OCCURRENCES && !PostHighlightingPass.canbeReferencedViaWeirdNames(member)) {
            return true;
        }
        Query query = member instanceof PsiMethod ? MethodReferencesSearch.search((PsiMethod)((PsiMethod)member), (SearchScope)scope, (boolean)true) : ReferencesSearch.search((PsiElement)member, (SearchScope)scope, (boolean)true);
        return query.findFirst() == null;
    }

    private static boolean canbeReferencedViaWeirdNames(PsiMember member) {
        if (member instanceof PsiClass) {
            return false;
        }
        PsiFile containingFile = member.getContainingFile();
        if (!(containingFile instanceof PsiJavaFile)) {
            return true;
        }
        if (member instanceof PsiField) {
            return false;
        }
        if (member instanceof PsiMethod) {
            return PropertyUtil.isSimplePropertyAccessor((PsiMethod)((PsiMethod)member));
        }
        return false;
    }

    @Nullable
    private HighlightInfo processClass(PsiClass aClass, ProgressIndicator progress) {
        HighlightInfoType highlightInfoType;
        HighlightDisplayKey highlightDisplayKey;
        String pattern;
        int usage = this.isClassUnused(aClass, progress);
        if (usage == 1) {
            return null;
        }
        if (aClass.getContainingClass() != null && aClass.hasModifierProperty("private")) {
            pattern = aClass.isInterface() ? "private.inner.interface.is.not.used" : "private.inner.class.is.not.used";
            highlightDisplayKey = this.myUnusedSymbolKey;
            highlightInfoType = HighlightInfoType.UNUSED_SYMBOL;
        } else if (aClass.getParent() instanceof PsiDeclarationStatement) {
            pattern = "local.class.is.not.used";
            highlightDisplayKey = this.myUnusedSymbolKey;
            highlightInfoType = HighlightInfoType.UNUSED_SYMBOL;
        } else if (aClass instanceof PsiTypeParameter) {
            pattern = "type.parameter.is.not.used";
            highlightDisplayKey = this.myUnusedSymbolKey;
            highlightInfoType = HighlightInfoType.UNUSED_SYMBOL;
        } else {
            pattern = "class.is.not.used";
            highlightDisplayKey = this.myDeadCodeKey;
            highlightInfoType = this.myDeadCodeInfoType;
        }
        return this.formatUnusedSymbolHighlightInfo(pattern, (PsiNameIdentifierOwner)aClass, "classes", highlightDisplayKey, highlightInfoType);
    }

    private int isClassUnused(PsiClass aClass, ProgressIndicator progress) {
        if (aClass == null) {
            return 1;
        }
        int result = this.unusedClassCache.get((Object)aClass);
        if (result == 0) {
            result = this.isReallyUnused(aClass, progress);
            this.unusedClassCache.put((Object)aClass, result);
        }
        return result;
    }

    private int isReallyUnused(PsiClass aClass, ProgressIndicator progress) {
        if (this.isImplicitUsage((PsiModifierListOwner)aClass, progress) || this.myRefCountHolder.isReferenced((PsiNamedElement)aClass)) {
            return 1;
        }
        if (aClass.getContainingClass() != null && aClass.hasModifierProperty("private") || aClass.getParent() instanceof PsiDeclarationStatement || aClass instanceof PsiTypeParameter) {
            return 2;
        }
        if (this.weAreSureThereAreNoUsages((PsiMember)aClass, progress)) {
            return 3;
        }
        return 1;
    }

    private HighlightInfo formatUnusedSymbolHighlightInfo(@PropertyKey(resourceBundle="messages.JavaErrorMessages") String pattern, PsiNameIdentifierOwner aClass, final String element, HighlightDisplayKey highlightDisplayKey, HighlightInfoType highlightInfoType) {
        String symbolName = aClass.getName();
        String message = JavaErrorMessages.message(pattern, symbolName);
        PsiElement identifier = aClass.getNameIdentifier();
        final HighlightInfo highlightInfo = PostHighlightingPass.createUnusedSymbolInfo(identifier, message, highlightInfoType);
        QuickFixAction.registerQuickFixAction(highlightInfo, new SafeDeleteFix((PsiElement)aClass), highlightDisplayKey);
        SpecialAnnotationsUtil.createAddToSpecialAnnotationFixes((PsiModifierListOwner)aClass, new Processor<String>(){

            public boolean process(String annoName) {
                QuickFixAction.registerQuickFixAction(highlightInfo, PostHighlightingPass.this.myUnusedSymbolInspection.createQuickFix(annoName, element));
                return true;
            }
        });
        return highlightInfo;
    }

    @Nullable
    private HighlightInfo processImport(PsiImportStatementBase importStatement, HighlightDisplayKey unusedImportKey) {
        if (importStatement instanceof JspxImportStatement && ((JspxImportStatement)importStatement).isForeignFileImport()) {
            return null;
        }
        if (PsiUtilBase.hasErrorElementChild((PsiElement)importStatement)) {
            return null;
        }
        boolean isRedundant = this.myRefCountHolder.isRedundant(importStatement);
        if (!isRedundant && !(importStatement instanceof PsiImportStaticStatement)) {
            String qName;
            PsiElement resolved;
            String packageName = ((PsiClassOwner)importStatement.getContainingFile()).getPackageName();
            PsiJavaCodeReferenceElement reference = importStatement.getImportReference();
            PsiElement psiElement = resolved = reference == null ? null : reference.resolve();
            if (resolved instanceof PsiPackage) {
                isRedundant = packageName.equals(((PsiPackage)resolved).getQualifiedName());
            } else if (resolved instanceof PsiClass && !importStatement.isOnDemand() && (qName = ((PsiClass)resolved).getQualifiedName()) != null) {
                String name = ((PsiClass)resolved).getName();
                isRedundant = qName.equals(packageName + '.' + name);
            }
        }
        if (isRedundant) {
            return this.registerRedundantImport(importStatement, unusedImportKey);
        }
        int entryIndex = this.myStyleManager.findEntryIndex(importStatement);
        if (entryIndex < this.myCurentEntryIndex) {
            this.myHasMissortedImports = true;
        }
        this.myCurentEntryIndex = entryIndex;
        return null;
    }

    private HighlightInfo registerRedundantImport(PsiImportStatementBase importStatement, HighlightDisplayKey unusedImportKey) {
        HighlightInfo info = HighlightInfo.createHighlightInfo(JavaHightlightInfoTypes.UNUSED_IMPORT, (PsiElement)importStatement, InspectionsBundle.message((String)"unused.import.statement", (Object[])new Object[0]));
        QuickFixAction.registerQuickFixAction(info, new OptimizeImportsFix(), unusedImportKey);
        QuickFixAction.registerQuickFixAction(info, new EnableOptimizeImportsOnTheFlyFix(), unusedImportKey);
        this.myHasRedundantImports = true;
        return info;
    }

    private boolean timeToOptimizeImports() {
        if (!CodeInsightSettings.getInstance().OPTIMIZE_IMPORTS_ON_THE_FLY) {
            return false;
        }
        DaemonCodeAnalyzerImpl codeAnalyzer = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)this.myProject);
        PsiFile file = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myDocument);
        if (file == null || !codeAnalyzer.isHighlightingAvailable(file) || !(file instanceof PsiJavaFile) || file instanceof JspFile) {
            return false;
        }
        if (!codeAnalyzer.isErrorAnalyzingFinished(file)) {
            return false;
        }
        List<HighlightInfo> errors = DaemonCodeAnalyzerImpl.getHighlights(this.myDocument, HighlightSeverity.ERROR, this.myProject);
        return errors.isEmpty() && codeAnalyzer.canChangeFileSilently((PsiFileSystemItem)this.myFile);
    }

    private static boolean isIntentionalPrivateConstructor(PsiMethod method, PsiClass containingClass) {
        return method.isConstructor() && method.getParameterList().getParametersCount() == 0 && containingClass != null && containingClass.getConstructors().length == 1;
    }
}

