/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeNewOperatorTypeFix
implements IntentionAction {
    private final PsiType myType;
    private final PsiNewExpression myExpression;

    private ChangeNewOperatorTypeFix(PsiType type, PsiNewExpression expression) {
        this.myType = type;
        this.myExpression = expression;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("change.new.operator.type.text", this.myExpression.getText(), this.myType.getPresentableText(), this.myType instanceof PsiArrayType ? "" : "()");
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/ChangeNewOperatorTypeFix.getText must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("change.new.operator.type.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/ChangeNewOperatorTypeFix.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/ChangeNewOperatorTypeFix.isAvailable must not be null");
        }
        return this.myType.isValid() && this.myExpression.isValid() && this.myExpression.getManager().isInProject((PsiElement)this.myExpression) && !TypeConversionUtil.isPrimitiveAndNotNull((PsiType)this.myType) && (this.myType instanceof PsiArrayType || this.myExpression.getArgumentList() != null);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/ChangeNewOperatorTypeFix.invoke must not be null");
        }
        if (!CodeInsightUtilBase.prepareFileForWrite(file)) {
            return;
        }
        ChangeNewOperatorTypeFix.changeNewOperatorType(this.myExpression, this.myType, editor);
    }

    private static void changeNewOperatorType(PsiNewExpression originalExpression, PsiType toType, Editor editor) throws IncorrectOperationException {
        TextRange selection;
        PsiNewExpression newExpression;
        int caretOffset;
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)originalExpression.getProject()).getElementFactory();
        if (toType instanceof PsiArrayType) {
            caretOffset = -2;
            String text = "new " + toType.getDeepComponentType().getCanonicalText() + "[0]";
            for (int i = 1; i < toType.getArrayDimensions(); ++i) {
                text = text + "[]";
                caretOffset -= 2;
            }
            newExpression = (PsiNewExpression)factory.createExpressionFromText(text, (PsiElement)originalExpression);
            selection = new TextRange(caretOffset, caretOffset + 1);
        } else {
            newExpression = (PsiNewExpression)factory.createExpressionFromText("new " + toType.getCanonicalText() + "()", (PsiElement)originalExpression);
            PsiExpressionList argumentList = originalExpression.getArgumentList();
            if (argumentList == null) {
                return;
            }
            newExpression.getArgumentList().replace((PsiElement)argumentList);
            selection = null;
            caretOffset = -1;
        }
        PsiElement element = originalExpression.replace((PsiElement)newExpression);
        editor.getCaretModel().moveToOffset(element.getTextRange().getEndOffset() + caretOffset);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        if (selection != null) {
            selection = selection.shiftRight(element.getTextRange().getEndOffset());
            editor.getSelectionModel().setSelection(selection.getStartOffset(), selection.getEndOffset());
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    public static void register(HighlightInfo highlightInfo, PsiExpression expression, PsiType lType) {
        PsiSubstitutor substitutor;
        PsiClassType.ClassResolveResult lResolveResult;
        PsiClass lClass;
        PsiClassType.ClassResolveResult rResolveResult;
        PsiClass rClass;
        if (!((expression = PsiUtil.deparenthesizeExpression((PsiExpression)expression)) instanceof PsiNewExpression)) {
            return;
        }
        PsiType rType = expression.getType();
        PsiType newType = lType;
        if (rType instanceof PsiClassType && newType instanceof PsiClassType && (rClass = (rResolveResult = ((PsiClassType)rType).resolveGenerics()).getElement()) != null && (lClass = (lResolveResult = ((PsiClassType)newType).resolveGenerics()).getElement()) != null && (substitutor = ChangeNewOperatorTypeFix.getInheritorSubstitutorForNewExpression(lClass, rClass, lResolveResult.getSubstitutor(), (PsiElement)expression)) != null) {
            newType = JavaPsiFacade.getInstance((Project)lClass.getProject()).getElementFactory().createType(rClass, substitutor);
        }
        PsiNewExpression newExpression = (PsiNewExpression)expression;
        QuickFixAction.registerQuickFixAction(highlightInfo, new ChangeNewOperatorTypeFix(newType, newExpression));
    }

    @Nullable
    private static PsiSubstitutor getInheritorSubstitutorForNewExpression(PsiClass baseClass, PsiClass inheritor, PsiSubstitutor baseSubstitutor, PsiElement context) {
        Project project = baseClass.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        PsiResolveHelper resolveHelper = facade.getResolveHelper();
        PsiSubstitutor superSubstitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)baseClass, (PsiClass)inheritor, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        if (superSubstitutor == null) {
            return null;
        }
        PsiSubstitutor inheritorSubstitutor = PsiSubstitutor.EMPTY;
        block0: for (PsiTypeParameter inheritorParameter : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)inheritor)) {
            for (PsiTypeParameter baseParameter : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)baseClass)) {
                PsiType substitution;
                PsiType substituted = superSubstitutor.substitute(baseParameter);
                PsiType arg = baseSubstitutor.substitute(baseParameter);
                if (arg instanceof PsiWildcardType) {
                    arg = ((PsiWildcardType)arg).getBound();
                }
                if (PsiType.NULL.equals(substitution = resolveHelper.getSubstitutionForTypeParameter(inheritorParameter, substituted, arg, true, PsiUtil.getLanguageLevel((PsiElement)context)))) continue;
                if (substitution == null) {
                    return facade.getElementFactory().createRawSubstitutor((PsiTypeParameterListOwner)inheritor);
                }
                inheritorSubstitutor = inheritorSubstitutor.put(inheritorParameter, substitution);
                continue block0;
            }
        }
        return inheritorSubstitutor;
    }
}

