/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMethodUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.BringVariableIntoScopeFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassFromNewFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassFromUsageFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassKind;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateConstantFieldFromUsageFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateEnumConstantFromUsageFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFieldFromUsageFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateInnerClassFromNewFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateInnerClassFromUsageFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateLocalFromUsageFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateParameterFromUsageFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ImportClassFix;
import com.intellij.codeInsight.daemon.impl.quickfix.MoveClassToModuleFix;
import com.intellij.codeInsight.daemon.impl.quickfix.OrderEntryFix;
import com.intellij.codeInsight.daemon.impl.quickfix.RenameWrongRefFix;
import com.intellij.codeInsight.daemon.impl.quickfix.SetupJDKFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.quickfix.UnresolvedReferenceQuickFixProvider;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;

public class DefaultQuickFixProvider
extends UnresolvedReferenceQuickFixProvider<PsiJavaCodeReferenceElement> {
    @Override
    public void registerFixes(PsiJavaCodeReferenceElement ref, QuickFixActionRegistrar registrar) {
        PsiElement parent;
        registrar.register((IntentionAction)new ImportClassFix(ref));
        registrar.register((IntentionAction)SetupJDKFix.getInstnace());
        OrderEntryFix.registerFixes(registrar, (PsiReference)ref);
        MoveClassToModuleFix.registerFixes(registrar, ref);
        if (ref instanceof PsiReferenceExpression) {
            TextRange fixRange = HighlightMethodUtil.getFixRange((PsiElement)ref);
            PsiReferenceExpression refExpr = (PsiReferenceExpression)ref;
            registrar.register(fixRange, (IntentionAction)new CreateEnumConstantFromUsageFix(refExpr), null);
            registrar.register(fixRange, (IntentionAction)new CreateConstantFieldFromUsageFix(refExpr), null);
            registrar.register(fixRange, (IntentionAction)new CreateFieldFromUsageFix(refExpr), null);
            registrar.register((IntentionAction)new RenameWrongRefFix(refExpr));
            if (!ref.isQualified()) {
                registrar.register(fixRange, (IntentionAction)new BringVariableIntoScopeFix(refExpr), null);
                registrar.register(fixRange, (IntentionAction)new CreateLocalFromUsageFix(refExpr), null);
                registrar.register(fixRange, (IntentionAction)new CreateParameterFromUsageFix(refExpr), null);
            }
        }
        registrar.register((IntentionAction)new CreateClassFromUsageFix(ref, CreateClassKind.INTERFACE));
        if (PsiUtil.isLanguageLevel5OrHigher((PsiElement)ref)) {
            registrar.register((IntentionAction)new CreateClassFromUsageFix(ref, CreateClassKind.ENUM));
        }
        if ((parent = PsiTreeUtil.getParentOfType((PsiElement)ref, (Class[])new Class[]{PsiNewExpression.class, PsiMethod.class})) instanceof PsiNewExpression && !(ref.getParent() instanceof PsiTypeElement)) {
            registrar.register((IntentionAction)new CreateClassFromNewFix((PsiNewExpression)parent));
            registrar.register((IntentionAction)new CreateInnerClassFromNewFix((PsiNewExpression)parent));
        } else {
            registrar.register((IntentionAction)new CreateClassFromUsageFix(ref, CreateClassKind.CLASS));
            registrar.register((IntentionAction)new CreateInnerClassFromUsageFix(ref, CreateClassKind.CLASS));
        }
    }

    @Override
    @NotNull
    public Class<PsiJavaCodeReferenceElement> getReferenceClass() {
        if (PsiJavaCodeReferenceElement.class == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/DefaultQuickFixProvider.getReferenceClass must not return null");
        }
        return PsiJavaCodeReferenceElement.class;
    }
}

