/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class GeneralizeCatchFix
implements IntentionAction {
    private final PsiElement myElement;
    private final PsiClassType myUnhandledException;
    private PsiTryStatement myTryStatement;
    private PsiParameter myCatchParameter;

    public GeneralizeCatchFix(PsiElement element, PsiClassType unhandledException) {
        this.myElement = element;
        this.myUnhandledException = unhandledException;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("generalize.catch.text", HighlightUtil.formatType(this.myCatchParameter.getType()), HighlightUtil.formatType((PsiType)this.myUnhandledException));
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/GeneralizeCatchFix.getText must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("generalize.catch.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/GeneralizeCatchFix.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        PsiParameter[] catchBlockParameters;
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/GeneralizeCatchFix.isAvailable must not be null");
        }
        if (!(this.myElement != null && this.myElement.isValid() && this.myUnhandledException != null && this.myUnhandledException.isValid() && this.myElement.getManager().isInProject(this.myElement))) {
            return false;
        }
        for (PsiElement element = this.myElement; element != null; element = element.getParent()) {
            if (element instanceof PsiCodeBlock && element.getParent() instanceof PsiTryStatement && ((PsiTryStatement)element.getParent()).getTryBlock() == element) {
                this.myTryStatement = (PsiTryStatement)element.getParent();
                break;
            }
            if (element instanceof PsiMethod || element instanceof PsiClass && !(element instanceof PsiAnonymousClass)) break;
        }
        if (this.myTryStatement == null) {
            return false;
        }
        for (PsiParameter catchBlockParameter : catchBlockParameters = this.myTryStatement.getCatchBlockParameters()) {
            PsiType type = catchBlockParameter.getType();
            if (!this.myUnhandledException.isAssignableFrom(type)) continue;
            this.myCatchParameter = catchBlockParameter;
            break;
        }
        return this.myCatchParameter != null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/GeneralizeCatchFix.invoke must not be null");
        }
        if (!CodeInsightUtilBase.prepareFileForWrite(this.myElement.getContainingFile())) {
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myElement.getProject()).getElementFactory();
        PsiTypeElement type = factory.createTypeElement((PsiType)this.myUnhandledException);
        this.myCatchParameter.getTypeElement().replace((PsiElement)type);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

