/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.PsiMatcherImpl;
import com.intellij.psi.util.PsiMatchers;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class InsertSuperFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.InsertSuperFix");
    private final PsiMethod myConstructor;

    public InsertSuperFix(PsiMethod constructor) {
        this.myConstructor = constructor;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("insert.super.constructor.call.text", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/InsertSuperFix.getText must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("insert.super.constructor.call.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/InsertSuperFix.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/InsertSuperFix.isAvailable must not be null");
        }
        return this.myConstructor.isValid() && this.myConstructor.getBody() != null && this.myConstructor.getBody().getLBrace() != null && this.myConstructor.getManager().isInProject((PsiElement)this.myConstructor);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/InsertSuperFix.invoke must not be null");
        }
        if (!CodeInsightUtilBase.prepareFileForWrite(this.myConstructor.getContainingFile())) {
            return;
        }
        try {
            PsiStatement superCall = JavaPsiFacade.getInstance((Project)this.myConstructor.getProject()).getElementFactory().createStatementFromText("super();", null);
            PsiCodeBlock body = this.myConstructor.getBody();
            PsiJavaToken lBrace = body.getLBrace();
            body.addAfter((PsiElement)superCall, (PsiElement)lBrace);
            lBrace = (PsiJavaToken)new PsiMatcherImpl((PsiElement)body).firstChild(PsiMatchers.hasClass(PsiExpressionStatement.class)).firstChild(PsiMatchers.hasClass(PsiMethodCallExpression.class)).firstChild(PsiMatchers.hasClass(PsiExpressionList.class)).firstChild(PsiMatchers.hasClass(PsiJavaToken.class)).dot(PsiMatchers.hasText((String)"(")).getElement();
            editor.getCaretModel().moveToOffset(lBrace.getTextOffset() + 1);
            UndoUtil.markPsiFileForUndo((PsiFile)file);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }
}

