/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class ShowModulePropertiesFix
implements IntentionAction {
    private final String myModuleName;

    public ShowModulePropertiesFix(String moduleName) {
        this.myModuleName = moduleName;
    }

    public ShowModulePropertiesFix(PsiElement context) {
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)context);
        this.myModuleName = module != null ? module.getName() : null;
    }

    @NotNull
    public String getText() {
        AnAction action = ActionManager.getInstance().getAction("ModuleSettings");
        String string = action.getTemplatePresentation().getText();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/ShowModulePropertiesFix.getText must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/quickfix/ShowModulePropertiesFix.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/ShowModulePropertiesFix.isAvailable must not be null");
        }
        return this.myModuleName != null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/quickfix/ShowModulePropertiesFix.invoke must not be null");
        }
        ProjectSettingsService.getInstance(project).showModuleConfigurationDialog(this.myModuleName, null, false);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

