/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation.ui;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.generation.GenerateEqualsHelper;
import com.intellij.ide.wizard.AbstractWizard;
import com.intellij.ide.wizard.Step;
import com.intellij.ide.wizard.StepAdapter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.classMembers.MemberInfoChange;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.refactoring.classMembers.MemberInfoTooltipManager;
import com.intellij.refactoring.ui.MemberSelectionPanel;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.util.containers.HashMap;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenerateEqualsWizard
extends AbstractWizard {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.generation.ui.GenerateEqualsWizard");
    private final PsiClass myClass;
    private final MemberSelectionPanel myEqualsPanel;
    private final MemberSelectionPanel myHashCodePanel;
    private final HashMap myFieldsToHashCode;
    private final MemberSelectionPanel myNonNullPanel;
    private final HashMap<PsiElement, MemberInfo> myFieldsToNonNull;
    private final int myTestBoxedStep;
    private final int myEqualsStepCode;
    private final int myHashcodeStepCode;
    private final List<MemberInfo> myClassFields;
    private static final MyMemberInfoFilter MEMBER_INFO_FILTER = new MyMemberInfoFilter();

    public GenerateEqualsWizard(Project project, PsiClass aClass, boolean needEquals, boolean needHashCode) {
        super(CodeInsightBundle.message((String)"generate.equals.hashcode.wizard.title", (Object[])new Object[0]), project);
        LOG.assertTrue(needEquals || needHashCode);
        this.myClass = aClass;
        this.myClassFields = MemberInfo.extractClassMembers(this.myClass, MEMBER_INFO_FILTER, false);
        for (MemberInfo myClassField : this.myClassFields) {
            myClassField.setChecked(true);
        }
        int testBoxedStep = 0;
        if (needEquals) {
            this.myEqualsPanel = new MemberSelectionPanel(CodeInsightBundle.message((String)"generate.equals.hashcode.equals.fields.chooser.title", (Object[])new Object[0]), this.myClassFields, null);
            this.myEqualsPanel.getTable().setMemberInfoModel(new EqualsMemberInfoModel());
            testBoxedStep += 2;
        } else {
            this.myEqualsPanel = null;
        }
        if (needHashCode) {
            List<MemberInfo> hashCodeMemberInfos;
            if (needEquals) {
                this.myFieldsToHashCode = this.createFieldToMemberInfoMap(true);
                hashCodeMemberInfos = Collections.emptyList();
            } else {
                hashCodeMemberInfos = this.myClassFields;
                this.myFieldsToHashCode = null;
            }
            this.myHashCodePanel = new MemberSelectionPanel(CodeInsightBundle.message((String)"generate.equals.hashcode.hashcode.fields.chooser.title", (Object[])new Object[0]), hashCodeMemberInfos, null);
            this.myHashCodePanel.getTable().setMemberInfoModel(new HashCodeMemberInfoModel());
            if (needEquals) {
                this.updateHashCodeMemberInfos(this.myClassFields);
            }
            ++testBoxedStep;
        } else {
            this.myHashCodePanel = null;
            this.myFieldsToHashCode = null;
        }
        this.myTestBoxedStep = testBoxedStep;
        this.myNonNullPanel = new MemberSelectionPanel(CodeInsightBundle.message((String)"generate.equals.hashcode.non.null.fields.chooser.title", (Object[])new Object[0]), Collections.<MemberInfo>emptyList(), null);
        this.myFieldsToNonNull = this.createFieldToMemberInfoMap(false);
        for (Map.Entry entry : this.myFieldsToNonNull.entrySet()) {
            ((MemberInfo)((Object)entry.getValue())).setChecked(((PsiField)entry.getKey()).getModifierList().findAnnotation(NotNull.class.getName()) != null);
        }
        MyTableModelListener listener = new MyTableModelListener();
        if (this.myEqualsPanel != null) {
            this.myEqualsPanel.getTable().getModel().addTableModelListener(listener);
            this.addStep((Step)new InstanceofOptionStep());
            this.addStep((Step)new MyStep(this.myEqualsPanel));
            this.myEqualsStepCode = 1;
        } else {
            this.myEqualsStepCode = -1;
        }
        if (this.myHashCodePanel != null) {
            this.myHashCodePanel.getTable().getModel().addTableModelListener(listener);
            this.addStep((Step)new MyStep(this.myHashCodePanel));
            this.myHashcodeStepCode = this.myEqualsStepCode > 0 ? this.myEqualsStepCode + 1 : 1;
        } else {
            this.myHashcodeStepCode = -1;
        }
        this.addStep((Step)new MyStep(this.myNonNullPanel));
        this.init();
        this.updateStatus();
    }

    public PsiField[] getEqualsFields() {
        if (this.myEqualsPanel != null) {
            return GenerateEqualsWizard.memberInfosToFields(this.myEqualsPanel.getTable().getSelectedMemberInfos());
        }
        return null;
    }

    public PsiField[] getHashCodeFields() {
        if (this.myHashCodePanel != null) {
            return GenerateEqualsWizard.memberInfosToFields(this.myHashCodePanel.getTable().getSelectedMemberInfos());
        }
        return null;
    }

    public PsiField[] getNonNullFields() {
        return GenerateEqualsWizard.memberInfosToFields(this.myNonNullPanel.getTable().getSelectedMemberInfos());
    }

    private static PsiField[] memberInfosToFields(Collection<MemberInfo> infos) {
        ArrayList<PsiField> list = new ArrayList<PsiField>();
        for (MemberInfo info : infos) {
            list.add((PsiField)info.getMember());
        }
        return list.toArray(new PsiField[list.size()]);
    }

    protected void doNextAction() {
        if (this.getCurrentStep() == this.myEqualsStepCode && this.myEqualsPanel != null) {
            this.equalsFieldsSelected();
        } else if (this.getCurrentStep() == this.myHashcodeStepCode && this.myHashCodePanel != null) {
            Collection<MemberInfo> selectedMemberInfos = this.myHashCodePanel.getTable().getSelectedMemberInfos();
            this.updateNonNullMemberInfos(selectedMemberInfos);
        }
        super.doNextAction();
        this.updateStatus();
    }

    protected void updateStep() {
        super.updateStep();
        Component stepComponent = this.getCurrentStepComponent();
        if (stepComponent instanceof MemberSelectionPanel) {
            ((MemberSelectionPanel)stepComponent).getTable().requestFocus();
        }
    }

    protected String getHelpID() {
        return "editing.altInsert.equals";
    }

    private void equalsFieldsSelected() {
        Collection<MemberInfo> selectedMemberInfos = this.myEqualsPanel.getTable().getSelectedMemberInfos();
        this.updateHashCodeMemberInfos(selectedMemberInfos);
        this.updateNonNullMemberInfos(selectedMemberInfos);
    }

    protected void doOKAction() {
        if (this.myEqualsPanel != null) {
            this.equalsFieldsSelected();
        }
        super.doOKAction();
    }

    private HashMap<PsiElement, MemberInfo> createFieldToMemberInfoMap(boolean checkedByDefault) {
        List<MemberInfo> memberInfos = MemberInfo.extractClassMembers(this.myClass, MEMBER_INFO_FILTER, false);
        HashMap result = new HashMap();
        for (MemberInfo memberInfo : memberInfos) {
            memberInfo.setChecked(checkedByDefault);
            result.put((Object)memberInfo.getMember(), (Object)memberInfo);
        }
        return result;
    }

    private void updateHashCodeMemberInfos(Collection<MemberInfo> equalsMemberInfos) {
        if (this.myHashCodePanel == null) {
            return;
        }
        ArrayList<MemberInfo> hashCodeFields = new ArrayList<MemberInfo>();
        for (MemberInfo equalsMemberInfo : equalsMemberInfos) {
            hashCodeFields.add((MemberInfo)((Object)this.myFieldsToHashCode.get((Object)equalsMemberInfo.getMember())));
        }
        this.myHashCodePanel.getTable().setMemberInfos(hashCodeFields);
    }

    private void updateNonNullMemberInfos(Collection<MemberInfo> equalsMemberInfos) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (MemberInfo equalsMemberInfo : equalsMemberInfos) {
            PsiField field = (PsiField)equalsMemberInfo.getMember();
            if (field.getType() instanceof PsiPrimitiveType) continue;
            list.add(this.myFieldsToNonNull.get((Object)equalsMemberInfo.getMember()));
        }
        this.myNonNullPanel.getTable().setMemberInfos(list);
    }

    private void updateStatus() {
        boolean finishEnabled = true;
        boolean nextEnabled = true;
        if (this.myEqualsPanel != null & this.getCurrentStep() < this.myEqualsStepCode) {
            finishEnabled = false;
        }
        if (this.getCurrentStep() == this.myTestBoxedStep - 1) {
            boolean anyNonBoxed = false;
            for (MemberInfo classField : this.myClassFields) {
                PsiField field;
                if (!classField.isChecked() || (field = (PsiField)classField.getMember()).getType() instanceof PsiPrimitiveType) continue;
                anyNonBoxed = true;
                break;
            }
            nextEnabled = anyNonBoxed;
        }
        if (this.getCurrentStep() == this.myEqualsStepCode) {
            boolean anyChecked = false;
            for (MemberInfo classField : this.myClassFields) {
                if (!classField.isChecked()) continue;
                anyChecked = true;
                break;
            }
            finishEnabled &= anyChecked;
            nextEnabled &= anyChecked;
        }
        if (this.getCurrentStep() == this.myTestBoxedStep) {
            finishEnabled = true;
            nextEnabled = false;
        }
        this.getFinishButton().setEnabled(finishEnabled);
        this.getNextButton().setEnabled(nextEnabled);
        if (finishEnabled) {
            this.getRootPane().setDefaultButton(this.getFinishButton());
        } else if (nextEnabled) {
            this.getRootPane().setDefaultButton(this.getNextButton());
        }
    }

    public JComponent getPreferredFocusedComponent() {
        Component stepComponent = this.getCurrentStepComponent();
        if (stepComponent instanceof MemberSelectionPanel) {
            return ((MemberSelectionPanel)stepComponent).getTable();
        }
        return null;
    }

    private static class HashCodeMemberInfoModel
    implements MemberInfoModel<PsiMember, MemberInfo> {
        private final MemberInfoTooltipManager<PsiMember, MemberInfo> myTooltipManager = new MemberInfoTooltipManager<PsiMember, MemberInfo>(new MemberInfoTooltipManager.TooltipProvider<PsiMember, MemberInfo>(){

            @Override
            public String getTooltip(MemberInfo memberInfo) {
                if (HashCodeMemberInfoModel.this.isMemberEnabled(memberInfo)) {
                    return null;
                }
                if (!(memberInfo.getMember() instanceof PsiField)) {
                    return CodeInsightBundle.message((String)"generate.equals.hashcode.internal.error", (Object[])new Object[0]);
                }
                PsiType type = ((PsiField)memberInfo.getMember()).getType();
                if (!(type instanceof PsiArrayType)) {
                    return null;
                }
                return CodeInsightBundle.message((String)"generate.equals.hashcode.warning.hashcode.for.arrays.is.not.supported", (Object[])new Object[0]);
            }
        });

        private HashCodeMemberInfoModel() {
        }

        public boolean isMemberEnabled(MemberInfo member) {
            PsiMember psiMember = (PsiMember)member.getMember();
            return psiMember instanceof PsiField;
        }

        public boolean isCheckedWhenDisabled(MemberInfo member) {
            return false;
        }

        public boolean isAbstractEnabled(MemberInfo member) {
            return false;
        }

        public boolean isAbstractWhenDisabled(MemberInfo member) {
            return false;
        }

        public Boolean isFixedAbstract(MemberInfo member) {
            return null;
        }

        public int checkForProblems(@NotNull MemberInfo member) {
            if (member == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/generation/ui/GenerateEqualsWizard$HashCodeMemberInfoModel.checkForProblems must not be null");
            }
            return 0;
        }

        public void memberInfoChanged(MemberInfoChange<PsiMember, MemberInfo> event) {
        }

        public String getTooltipText(MemberInfo member) {
            return this.myTooltipManager.getTooltip(member);
        }
    }

    private static class EqualsMemberInfoModel
    implements MemberInfoModel<PsiMember, MemberInfo> {
        MemberInfoTooltipManager<PsiMember, MemberInfo> myTooltipManager = new MemberInfoTooltipManager<PsiMember, MemberInfo>(new MemberInfoTooltipManager.TooltipProvider<PsiMember, MemberInfo>(){

            @Override
            public String getTooltip(MemberInfo memberInfo) {
                if (EqualsMemberInfoModel.this.checkForProblems(memberInfo) == 0) {
                    return null;
                }
                if (!(memberInfo.getMember() instanceof PsiField)) {
                    return CodeInsightBundle.message((String)"generate.equals.hashcode.internal.error", (Object[])new Object[0]);
                }
                PsiType type = ((PsiField)memberInfo.getMember()).getType();
                if (GenerateEqualsHelper.isNestedArray(type)) {
                    return CodeInsightBundle.message((String)"generate.equals.warning.equals.for.nested.arrays.not.supported", (Object[])new Object[0]);
                }
                if (GenerateEqualsHelper.isArrayOfObjects(type)) {
                    return CodeInsightBundle.message((String)"generate.equals.warning.generated.equals.could.be.incorrect", (Object[])new Object[0]);
                }
                return null;
            }
        });

        private EqualsMemberInfoModel() {
        }

        public boolean isMemberEnabled(MemberInfo member) {
            if (!(member.getMember() instanceof PsiField)) {
                return false;
            }
            PsiType type = ((PsiField)member.getMember()).getType();
            return !GenerateEqualsHelper.isNestedArray(type);
        }

        public boolean isCheckedWhenDisabled(MemberInfo member) {
            return false;
        }

        public boolean isAbstractEnabled(MemberInfo member) {
            return false;
        }

        public boolean isAbstractWhenDisabled(MemberInfo member) {
            return false;
        }

        public Boolean isFixedAbstract(MemberInfo member) {
            return null;
        }

        public int checkForProblems(@NotNull MemberInfo member) {
            if (member == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/generation/ui/GenerateEqualsWizard$EqualsMemberInfoModel.checkForProblems must not be null");
            }
            if (!(member.getMember() instanceof PsiField)) {
                return 2;
            }
            PsiType type = ((PsiField)member.getMember()).getType();
            if (GenerateEqualsHelper.isNestedArray(type)) {
                return 2;
            }
            if (GenerateEqualsHelper.isArrayOfObjects(type)) {
                return 1;
            }
            return 0;
        }

        public void memberInfoChanged(MemberInfoChange<PsiMember, MemberInfo> event) {
        }

        public String getTooltipText(MemberInfo member) {
            return this.myTooltipManager.getTooltip(member);
        }
    }

    private static class MyMemberInfoFilter
    implements MemberInfoBase.Filter<PsiMember> {
        private MyMemberInfoFilter() {
        }

        public boolean includeMember(PsiMember element) {
            return element instanceof PsiField && !element.hasModifierProperty("static");
        }
    }

    private static class MyStep
    extends StepAdapter {
        final MemberSelectionPanel myPanel;

        public MyStep(MemberSelectionPanel panel) {
            this.myPanel = panel;
        }

        public Icon getIcon() {
            return null;
        }

        public JComponent getComponent() {
            return this.myPanel;
        }
    }

    private static class InstanceofOptionStep
    extends StepAdapter {
        private final JComponent myPanel;

        private InstanceofOptionStep() {
            NonFocusableCheckBox checkbox = new NonFocusableCheckBox(CodeInsightBundle.message((String)"generate.equals.hashcode.accept.sublcasses", (Object[])new Object[0]));
            checkbox.setSelected(CodeInsightSettings.getInstance().USE_INSTANCEOF_ON_EQUALS_PARAMETER);
            checkbox.addActionListener(new ActionListener((JCheckBox)checkbox){
                final /* synthetic */ JCheckBox val$checkbox;
                {
                    this.val$checkbox = jCheckBox;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    CodeInsightSettings.getInstance().USE_INSTANCEOF_ON_EQUALS_PARAMETER = this.val$checkbox.isSelected();
                }
            });
            this.myPanel = new JPanel((LayoutManager)new VerticalFlowLayout());
            this.myPanel.add((Component)checkbox);
            this.myPanel.add(new JLabel(CodeInsightBundle.message((String)"generate.equals.hashcode.accept.sublcasses.explanation", (Object[])new Object[0])));
        }

        public JComponent getComponent() {
            return this.myPanel;
        }

        @Nullable
        public Icon getIcon() {
            return null;
        }
    }

    private class MyTableModelListener
    implements TableModelListener {
        private MyTableModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            GenerateEqualsWizard.this.updateStatus();
        }
    }
}

