/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInsight.hint.PriorityQuestionAction;
import com.intellij.codeInsight.hint.ScrollAwareHint;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.IntentionListStep;
import com.intellij.codeInsight.intention.impl.config.IntentionManagerSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.psi.PsiFile;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.RowIcon;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Alarm;
import com.intellij.util.IncorrectOperationException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class IntentionHintComponent
extends JPanel
implements Disposable,
ScrollAwareHint {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.intention.impl.IntentionHintComponent.ListPopupRunnable");
    static final Icon ourIntentionIcon = IconLoader.getIcon((String)"/actions/realIntentionBulb.png");
    static final Icon ourBulbIcon = IconLoader.getIcon((String)"/actions/intentionBulb.png");
    static final Icon ourQuickFixIcon = IconLoader.getIcon((String)"/actions/quickfixBulb.png");
    static final Icon ourIntentionOffIcon = IconLoader.getIcon((String)"/actions/realIntentionOffBulb.png");
    static final Icon ourQuickFixOffIcon = IconLoader.getIcon((String)"/actions/quickfixOffBulb.png");
    static final Icon ourArrowIcon = IconLoader.getIcon((String)"/general/arrowDown.png");
    private static final Border INACTIVE_BORDER = null;
    private static final Insets INACTIVE_MARGIN = new Insets(0, 0, 0, 0);
    private static final Insets ACTIVE_MARGIN = new Insets(0, 0, 0, 0);
    private final Editor myEditor;
    private static final Alarm myAlarm = new Alarm();
    private final RowIcon myHighlightedIcon;
    private final JButton myButton;
    private final Icon mySmartTagIcon;
    private static final int DELAY = 500;
    private final MyComponentHint myComponentHint;
    private static final Color BACKGROUND_COLOR = new Color(255, 255, 255, 0);
    private boolean myPopupShown;
    private boolean myDisposed;
    private ListPopup myPopup;
    private final PsiFile myFile;
    private static final int LIGHTBULB_OFFSET = 20;

    public static IntentionHintComponent showIntentionHint(Project project, PsiFile file, Editor editor, ShowIntentionsPass.IntentionsInfo intentions, boolean showExpanded) {
        Point position = IntentionHintComponent.getHintPosition(editor);
        return IntentionHintComponent.showIntentionHint(project, file, editor, intentions, showExpanded, position);
    }

    public static IntentionHintComponent showIntentionHint(Project project, PsiFile file, Editor editor, @NotNull ShowIntentionsPass.IntentionsInfo intentions, boolean showExpanded, Point position) {
        if (intentions == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/codeInsight/intention/impl/IntentionHintComponent.showIntentionHint must not be null");
        }
        final IntentionHintComponent component = new IntentionHintComponent(project, file, editor, intentions);
        if (showExpanded) {
            component.showIntentionHintImpl(false, position);
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    component.showPopup();
                }
            });
        } else {
            component.showIntentionHintImpl(true, position);
        }
        Disposer.register((Disposable)project, (Disposable)component);
        return component;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    public void dispose() {
        this.myDisposed = true;
        this.myComponentHint.hide();
        super.hide();
    }

    @Override
    public void editorScrolled() {
        this.closePopup();
    }

    public synchronized Boolean updateActions(ShowIntentionsPass.IntentionsInfo intentions) {
        if (this.myPopup.isDisposed()) {
            return null;
        }
        if (!this.myFile.isValid()) {
            return null;
        }
        IntentionListStep step = (IntentionListStep)this.myPopup.getListStep();
        if (!step.updateActions(intentions)) {
            return Boolean.TRUE;
        }
        if (!this.myPopupShown) {
            return Boolean.FALSE;
        }
        return null;
    }

    public synchronized void recreate() {
        IntentionListStep step = (IntentionListStep)this.myPopup.getListStep();
        this.recreateMyPopup(step);
    }

    private void showIntentionHintImpl(boolean delay, Point position) {
        int offset = this.myEditor.getCaretModel().getOffset();
        this.myComponentHint.setShouldDelay(delay);
        HintManagerImpl hintManager = HintManagerImpl.getInstanceImpl();
        PriorityQuestionAction action = new PriorityQuestionAction(){

            public boolean execute() {
                IntentionHintComponent.this.showPopup();
                return true;
            }

            @Override
            public int getPriority() {
                return -10;
            }
        };
        if (hintManager.canShowQuestionAction(action)) {
            hintManager.showQuestionHint(this.myEditor, position, offset, offset, this.myComponentHint, action);
        }
    }

    private static Point getHintPosition(Editor editor) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return new Point();
        }
        int offset = editor.getCaretModel().getOffset();
        LogicalPosition pos = editor.offsetToLogicalPosition(offset);
        int line = pos.line;
        Point position = editor.logicalPositionToXY(new LogicalPosition(line, 0));
        int yShift = (ourIntentionIcon.getIconHeight() - editor.getLineHeight() - 1) / 2 - 1;
        int xShift = ourIntentionIcon.getIconWidth();
        LOG.assertTrue(editor.getComponent().isDisplayable());
        Rectangle visibleArea = editor.getScrollingModel().getVisibleArea();
        Point realPoint = new Point(Math.max(0, visibleArea.x - xShift), position.y + yShift - 20);
        Point location = SwingUtilities.convertPoint(editor.getContentComponent(), realPoint, editor.getComponent().getRootPane().getLayeredPane());
        return new Point(location.x, location.y);
    }

    private IntentionHintComponent(@NotNull Project project, @NotNull PsiFile file, @NotNull Editor editor, @NotNull ShowIntentionsPass.IntentionsInfo intentions) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/intention/impl/IntentionHintComponent.<init> must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/intention/impl/IntentionHintComponent.<init> must not be null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/intention/impl/IntentionHintComponent.<init> must not be null");
        }
        if (intentions == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/codeInsight/intention/impl/IntentionHintComponent.<init> must not be null");
        }
        this.myPopupShown = false;
        this.myDisposed = false;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        this.myFile = file;
        this.myEditor = editor;
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        boolean showFix = false;
        for (HighlightInfo.IntentionActionDescriptor pairs : intentions.errorFixesToShow) {
            IntentionAction fix = pairs.getAction();
            if (!IntentionManagerSettings.getInstance().isShowLightBulb(fix)) continue;
            showFix = true;
            break;
        }
        this.mySmartTagIcon = showFix ? ourQuickFixIcon : ourBulbIcon;
        this.myHighlightedIcon = new RowIcon(2);
        this.myHighlightedIcon.setIcon(this.mySmartTagIcon, 0);
        this.myHighlightedIcon.setIcon(ourArrowIcon, 1);
        this.myButton = new JButton(this.mySmartTagIcon);
        this.myButton.setFocusable(false);
        this.myButton.setMargin(INACTIVE_MARGIN);
        this.myButton.setBorderPainted(false);
        this.myButton.setContentAreaFilled(false);
        this.add((Component)this.myButton, "Center");
        this.setBorder(INACTIVE_BORDER);
        this.myButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IntentionHintComponent.this.showPopup();
            }
        });
        this.myButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                IntentionHintComponent.this.onMouseEnter();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                IntentionHintComponent.this.onMouseExit();
            }
        });
        this.myComponentHint = new MyComponentHint(this);
        IntentionListStep step = new IntentionListStep(this, intentions, this.myEditor, this.myFile, project);
        this.recreateMyPopup(step);
    }

    @Override
    public void hide() {
        Disposer.dispose((Disposable)this);
    }

    private void onMouseExit() {
        Window ancestor = SwingUtilities.getWindowAncestor(this.myPopup.getContent());
        if (ancestor == null) {
            this.myButton.setBackground(BACKGROUND_COLOR);
            this.myButton.setIcon(this.mySmartTagIcon);
            this.setBorder(INACTIVE_BORDER);
            this.myButton.setMargin(INACTIVE_MARGIN);
            this.updateComponentHintSize();
        }
    }

    private void onMouseEnter() {
        this.myButton.setBackground(HintUtil.QUESTION_COLOR);
        this.myButton.setIcon((Icon)this.myHighlightedIcon);
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        this.myButton.setMargin(ACTIVE_MARGIN);
        this.updateComponentHintSize();
        String acceleratorsText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("ShowIntentionActions"));
        if (acceleratorsText.length() > 0) {
            this.myButton.setToolTipText(CodeInsightBundle.message((String)"lightbulb.tooltip", (Object[])new Object[]{acceleratorsText}));
        }
    }

    private void updateComponentHintSize() {
        JComponent component = this.myComponentHint.getComponent();
        component.setSize(this.getPreferredSize().width, this.getHeight());
    }

    public LightweightHint getComponentHint() {
        return this.myComponentHint;
    }

    private void closePopup() {
        this.myPopup.cancel();
        this.myPopupShown = false;
    }

    private void showPopup() {
        if (this.myPopup == null || this.myPopup.isDisposed()) {
            return;
        }
        if (this.isShowing()) {
            RelativePoint swCorner = RelativePoint.getSouthWestOf((JComponent)this);
            this.myPopup.show(new RelativePoint(swCorner.getComponent(), new Point(swCorner.getPoint().x, swCorner.getPoint().y + 20)));
        } else {
            this.myPopup.showInBestPositionFor(this.myEditor);
        }
        this.myPopupShown = true;
    }

    private void recreateMyPopup(IntentionListStep step) {
        if (this.myPopup != null) {
            Disposer.dispose((Disposable)this.myPopup);
        }
        this.myPopup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)step);
        this.myPopup.addListener((JBPopupListener)new JBPopupListener.Adapter(){

            public void onClosed(LightweightWindowEvent event) {
                IntentionHintComponent.this.myPopupShown = false;
            }
        });
        Disposer.register((Disposable)this, (Disposable)this.myPopup);
        Disposer.register((Disposable)this.myPopup, (Disposable)new Disposable(){

            public void dispose() {
                ApplicationManager.getApplication().assertIsDispatchThread();
            }
        });
    }

    void canceled(IntentionListStep intentionListStep) {
        if (this.myPopup.getListStep() != intentionListStep || this.myDisposed) {
            return;
        }
        this.recreateMyPopup(intentionListStep);
    }

    public static class EnableDisableIntentionAction
    implements IntentionAction {
        private final String myActionFamilyName;
        private final IntentionManagerSettings mySettings = IntentionManagerSettings.getInstance();
        private final IntentionAction myAction;

        public EnableDisableIntentionAction(IntentionAction action) {
            this.myActionFamilyName = action.getFamilyName();
            this.myAction = action;
            LOG.assertTrue(this.myActionFamilyName != null, (Object)("action " + action.getClass() + " family returned null"));
        }

        @NotNull
        public String getText() {
            String string = this.mySettings.isEnabled(this.myAction) ? CodeInsightBundle.message((String)"disable.intention.action", (Object[])new Object[]{this.myActionFamilyName}) : CodeInsightBundle.message((String)"enable.intention.action", (Object[])new Object[]{this.myActionFamilyName});
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInsight/intention/impl/IntentionHintComponent$EnableDisableIntentionAction.getText must not return null");
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getText();
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInsight/intention/impl/IntentionHintComponent$EnableDisableIntentionAction.getFamilyName must not return null");
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/intention/impl/IntentionHintComponent$EnableDisableIntentionAction.isAvailable must not be null");
            }
            return true;
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/intention/impl/IntentionHintComponent$EnableDisableIntentionAction.invoke must not be null");
            }
            this.mySettings.setEnabled(this.myAction, !this.mySettings.isEnabled(this.myAction));
        }

        public boolean startInWriteAction() {
            return false;
        }

        public String toString() {
            return this.getText();
        }
    }

    private class MyComponentHint
    extends LightweightHint {
        private boolean myVisible;
        private boolean myShouldDelay;

        private MyComponentHint(JComponent component) {
            super(component);
            this.myVisible = false;
        }

        @Override
        public void show(final @NotNull JComponent parentComponent, final int x, final int y, final JComponent focusBackComponent) {
            if (parentComponent == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/intention/impl/IntentionHintComponent$MyComponentHint.show must not be null");
            }
            this.myVisible = true;
            if (this.myShouldDelay) {
                myAlarm.cancelAllRequests();
                myAlarm.addRequest(new Runnable(){

                    @Override
                    public void run() {
                        MyComponentHint.this.showImpl(parentComponent, x, y, focusBackComponent);
                    }
                }, 500);
            } else {
                this.showImpl(parentComponent, x, y, focusBackComponent);
            }
        }

        private void showImpl(JComponent parentComponent, int x, int y, JComponent focusBackComponent) {
            if (!parentComponent.isShowing()) {
                return;
            }
            super.show(parentComponent, x, y, focusBackComponent);
        }

        @Override
        public void hide() {
            super.hide();
            this.myVisible = false;
            myAlarm.cancelAllRequests();
        }

        @Override
        public boolean isVisible() {
            return this.myVisible || super.isVisible();
        }

        public void setShouldDelay(boolean shouldDelay) {
            this.myShouldDelay = shouldDelay;
        }
    }
}

