/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup.impl;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.hint.EditorHintListener;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupAdapter;
import com.intellij.codeInsight.lookup.LookupArranger;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.EditorFactoryAdapter;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.LightweightHint;
import com.intellij.util.Alarm;
import com.intellij.util.messages.MessageBus;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.jetbrains.annotations.NotNull;

public class LookupManagerImpl
extends LookupManager
implements ProjectComponent {
    private final Project myProject;
    protected LookupImpl myActiveLookup = null;
    protected Editor myActiveLookupEditor = null;
    private final PropertyChangeSupport myPropertyChangeSupport = new PropertyChangeSupport(this);
    private boolean myIsDisposed;

    public LookupManagerImpl(Project project, MessageBus bus) {
        this.myProject = project;
        bus.connect().subscribe(EditorHintListener.TOPIC, (Object)new EditorHintListener(){

            @Override
            public void hintShown(Project project, final LightweightHint hint, int flags) {
                Lookup lookup;
                if (project == LookupManagerImpl.this.myProject && (lookup = LookupManagerImpl.this.getActiveLookup()) != null && (flags & 4) != 0) {
                    lookup.addLookupListener(new LookupAdapter(){

                        @Override
                        public void currentItemChanged(LookupEvent event) {
                            hint.hide();
                        }

                        @Override
                        public void itemSelected(LookupEvent event) {
                            hint.hide();
                        }

                        @Override
                        public void lookupCanceled(LookupEvent event) {
                            hint.hide();
                        }
                    });
                }
            }
        });
    }

    @NotNull
    public String getComponentName() {
        if ("LookupManager" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/lookup/impl/LookupManagerImpl.getComponentName must not return null");
        }
        return "LookupManager";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public void projectOpened() {
        final EditorFactoryAdapter myEditorFactoryListener = new EditorFactoryAdapter(){

            public void editorReleased(EditorFactoryEvent event) {
                if (event.getEditor() == LookupManagerImpl.this.myActiveLookupEditor) {
                    LookupManagerImpl.this.hideActiveLookup();
                }
            }
        };
        EditorFactory.getInstance().addEditorFactoryListener((EditorFactoryListener)myEditorFactoryListener);
        Disposer.register((Disposable)this.myProject, (Disposable)new Disposable(){

            public void dispose() {
                EditorFactory.getInstance().removeEditorFactoryListener((EditorFactoryListener)myEditorFactoryListener);
            }
        });
    }

    public void projectClosed() {
        this.myIsDisposed = true;
    }

    @Override
    public Lookup showLookup(Editor editor, @NotNull LookupElement[] items, String prefix, @NotNull LookupArranger arranger) {
        if (items == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/lookup/impl/LookupManagerImpl.showLookup must not be null");
        }
        if (arranger == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/codeInsight/lookup/impl/LookupManagerImpl.showLookup must not be null");
        }
        LookupImpl lookup = this.createLookup(editor, items, prefix, arranger);
        lookup.show();
        return lookup;
    }

    @Override
    public LookupImpl createLookup(final Editor editor, @NotNull LookupElement[] items, String prefix, @NotNull LookupArranger arranger) {
        DaemonCodeAnalyzer daemonCodeAnalyzer;
        if (items == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/lookup/impl/LookupManagerImpl.createLookup must not be null");
        }
        if (arranger == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/codeInsight/lookup/impl/LookupManagerImpl.createLookup must not be null");
        }
        this.hideActiveLookup();
        final CodeInsightSettings settings = CodeInsightSettings.getInstance();
        final PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(editor.getDocument());
        final Alarm alarm = new Alarm();
        final Runnable request = new Runnable(){

            @Override
            public void run() {
                DocumentationManager.getInstance(LookupManagerImpl.this.myProject).showJavaDocInfo(editor, psiFile, false);
            }
        };
        if (settings.AUTO_POPUP_JAVADOC_INFO) {
            alarm.addRequest(request, settings.JAVADOC_INFO_DELAY);
        }
        if ((daemonCodeAnalyzer = DaemonCodeAnalyzer.getInstance((Project)this.myProject)) != null) {
            daemonCodeAnalyzer.setUpdateByTimerEnabled(false);
        }
        this.myActiveLookup = new LookupImpl(this.myProject, editor, arranger);
        this.myActiveLookupEditor = editor;
        this.myActiveLookup.addLookupListener(new LookupAdapter(){

            @Override
            public void itemSelected(LookupEvent event) {
                this.dispose();
            }

            @Override
            public void lookupCanceled(LookupEvent event) {
                this.dispose();
            }

            @Override
            public void currentItemChanged(LookupEvent event) {
                alarm.cancelAllRequests();
                if (settings.AUTO_POPUP_JAVADOC_INFO) {
                    alarm.addRequest(request, settings.JAVADOC_INFO_DELAY);
                }
            }

            private void dispose() {
                alarm.cancelAllRequests();
                if (daemonCodeAnalyzer != null) {
                    daemonCodeAnalyzer.setUpdateByTimerEnabled(true);
                }
                if (LookupManagerImpl.this.myActiveLookup == null) {
                    return;
                }
                LookupManagerImpl.this.myActiveLookup.removeLookupListener(this);
                LookupImpl lookup = LookupManagerImpl.this.myActiveLookup;
                LookupManagerImpl.this.myActiveLookup = null;
                LookupManagerImpl.this.myActiveLookupEditor = null;
                LookupManagerImpl.this.myPropertyChangeSupport.firePropertyChange("activeLookup", lookup, null);
            }
        });
        if (items.length > 0) {
            for (LookupElement item : items) {
                if (prefix != null) {
                    item.setPrefixMatcher((PrefixMatcher)new CamelHumpMatcher(prefix));
                }
                this.myActiveLookup.addItem(item);
            }
            this.myActiveLookup.refreshUi();
        } else {
            alarm.cancelAllRequests();
        }
        this.myPropertyChangeSupport.firePropertyChange("activeLookup", null, this.myActiveLookup);
        return this.myActiveLookup;
    }

    @Override
    public void hideActiveLookup() {
        if (this.myActiveLookup != null) {
            this.myActiveLookup.hide();
        }
    }

    @Override
    public Lookup getActiveLookup() {
        return this.myActiveLookup;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.myPropertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.myPropertyChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public boolean isDisposed() {
        return this.myIsDisposed;
    }
}

