/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.template.CustomLiveTemplate;
import com.intellij.codeInsight.template.impl.InvokeTemplateAction;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.codeInsight.template.impl.WrapWithCustomTemplateAction;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SurroundWithTemplateHandler
implements CodeInsightActionHandler {
    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/impl/SurroundWithTemplateHandler.invoke must not be null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/template/impl/SurroundWithTemplateHandler.invoke must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/template/impl/SurroundWithTemplateHandler.invoke must not be null");
        }
        DefaultActionGroup group = SurroundWithTemplateHandler.createActionGroup(project, editor, file);
        if (group == null) {
            return;
        }
        ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup(CodeInsightBundle.message((String)"templates.select.template.chooser.title", (Object[])new Object[0]), (ActionGroup)group, DataManager.getInstance().getDataContext((Component)editor.getContentComponent()), JBPopupFactory.ActionSelectionAid.MNEMONICS, false);
        popup.showInBestPositionFor(editor);
    }

    @Nullable
    public static DefaultActionGroup createActionGroup(Project project, Editor editor, PsiFile file) {
        if (!editor.getSelectionModel().hasSelection()) {
            editor.getSelectionModel().selectLineAtCaret();
            if (!editor.getSelectionModel().hasSelection()) {
                return null;
            }
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        List<CustomLiveTemplate> customTemplates = SurroundWithTemplateHandler.getApplicableCustomTemplates(editor, file);
        ArrayList<TemplateImpl> templates = SurroundWithTemplateHandler.getApplicableTemplates(editor, file, true);
        if (templates.isEmpty() && customTemplates.isEmpty()) {
            HintManager.getInstance().showErrorHint(editor, CodeInsightBundle.message((String)"templates.surround.no.defined", (Object[])new Object[0]));
            return null;
        }
        if (!CodeInsightUtilBase.preparePsiElementForWrite((PsiElement)file)) {
            return null;
        }
        HashSet<Character> usedMnemonicsSet = new HashSet<Character>();
        DefaultActionGroup group = new DefaultActionGroup();
        for (TemplateImpl template : templates) {
            group.add((AnAction)new InvokeTemplateAction(template, editor, project, usedMnemonicsSet));
        }
        for (CustomLiveTemplate customTemplate : customTemplates) {
            group.add((AnAction)new WrapWithCustomTemplateAction(customTemplate, editor, file, usedMnemonicsSet));
        }
        return group;
    }

    public boolean startInWriteAction() {
        return true;
    }

    public static List<CustomLiveTemplate> getApplicableCustomTemplates(Editor editor, PsiFile file) {
        ArrayList<CustomLiveTemplate> result = new ArrayList<CustomLiveTemplate>();
        int offset = editor.getCaretModel().getOffset();
        for (CustomLiveTemplate template : (CustomLiveTemplate[])CustomLiveTemplate.EP_NAME.getExtensions()) {
            if (!template.supportsWrapping() || !template.isApplicable(file, offset)) continue;
            result.add(template);
        }
        return result;
    }

    public static ArrayList<TemplateImpl> getApplicableTemplates(Editor editor, PsiFile file, boolean selection) {
        int offset;
        int startOffset = offset = editor.getCaretModel().getOffset();
        if (selection && editor.getSelectionModel().hasSelection()) {
            int selStart = editor.getSelectionModel().getSelectionStart();
            int selEnd = editor.getSelectionModel().getSelectionEnd();
            startOffset = offset == selStart ? selEnd : selStart;
        }
        ArrayList<TemplateImpl> list = new ArrayList<TemplateImpl>();
        for (TemplateImpl template : TemplateSettings.getInstance().getTemplates()) {
            if (template.isDeactivated() || template.isSelectionTemplate() != selection || !TemplateManagerImpl.isApplicable(file, offset, template) && (!selection || !TemplateManagerImpl.isApplicable(file, startOffset, template))) continue;
            list.add(template);
        }
        return list;
    }
}

