/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.zencoding;

import com.intellij.codeInsight.template.zencoding.XmlZenCodingFilter;
import com.intellij.codeInsight.template.zencoding.XmlZenCodingTemplate;
import com.intellij.codeInsight.template.zencoding.ZenCodingUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class XmlZenCodingFilterImpl
extends XmlZenCodingFilter {
    @Override
    @NotNull
    public String toString(@NotNull XmlTag tag, @NotNull PsiElement context) {
        if (tag == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/zencoding/XmlZenCodingFilterImpl.toString must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/template/zencoding/XmlZenCodingFilterImpl.toString must not be null");
        }
        FileType fileType = context.getContainingFile().getFileType();
        if (XmlZenCodingTemplate.isTrueXml(fileType)) {
            XmlZenCodingFilterImpl.closeUnclosingTags(tag);
        }
        String string = tag.getContainingFile().getText();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/template/zencoding/XmlZenCodingFilterImpl.toString must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildAttributesString(@NotNull List<Pair<String, String>> attribute2value, int numberInIteration) {
        if (attribute2value == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/zencoding/XmlZenCodingFilterImpl.buildAttributesString must not be null");
        }
        StringBuilder result = new StringBuilder();
        Iterator<Pair<String, String>> it = attribute2value.iterator();
        while (it.hasNext()) {
            Pair<String, String> pair = it.next();
            String name = (String)pair.first;
            String value = ZenCodingUtil.getValue(pair, numberInIteration);
            result.append(XmlZenCodingFilterImpl.getAttributeString(name, value));
            if (!it.hasNext()) continue;
            result.append(' ');
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/template/zencoding/XmlZenCodingFilterImpl.buildAttributesString must not return null");
        }
        return string;
    }

    @Override
    public boolean isMyContext(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/zencoding/XmlZenCodingFilterImpl.isMyContext must not be null");
        }
        return true;
    }

    @Override
    public String getSuffix() {
        return null;
    }

    @Override
    public boolean isDefaultFilter() {
        return true;
    }

    private static String getAttributeString(String name, String value) {
        return name + "=\"" + value + '\"';
    }

    private static void closeUnclosingTags(@NotNull XmlTag root) {
        if (root == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/zencoding/XmlZenCodingFilterImpl.closeUnclosingTags must not be null");
        }
        final ArrayList tagToClose = new ArrayList();
        Project project = root.getProject();
        final SmartPointerManager pointerManager = SmartPointerManager.getInstance((Project)project);
        root.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

            public void visitXmlTag(XmlTag tag) {
                if (!XmlZenCodingFilterImpl.isTagClosed(tag)) {
                    tagToClose.add(pointerManager.createLazyPointer((PsiElement)tag));
                }
            }
        });
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        for (SmartPsiElementPointer pointer : tagToClose) {
            ASTNode child;
            final XmlTag tag = (XmlTag)pointer.getElement();
            if (tag == null || (child = XmlChildRole.START_TAG_END_FINDER.findChild(tag.getNode())) == null) continue;
            final int offset = child.getTextRange().getStartOffset();
            VirtualFile file = tag.getContainingFile().getVirtualFile();
            if (file == null) continue;
            final Document document = FileDocumentManager.getInstance().getDocument(file);
            documentManager.doPostponedOperationsAndUnblockDocument(document);
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    document.replaceString(offset, tag.getTextRange().getEndOffset(), (CharSequence)"/>");
                }
            });
        }
        documentManager.commitAllDocuments();
    }

    private static boolean isTagClosed(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/template/zencoding/XmlZenCodingFilterImpl.isTagClosed must not be null");
        }
        ASTNode node = tag.getNode();
        assert (node != null);
        ASTNode emptyTagEnd = XmlChildRole.EMPTY_TAG_END_FINDER.findChild(node);
        ASTNode endTagEnd = XmlChildRole.CLOSING_TAG_START_FINDER.findChild(node);
        return emptyTagEnd != null || endTagEnd != null;
    }
}

