/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.actions;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiFile;

public class CodeInspectionOnEditorAction
extends AnAction {
    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return;
        }
        PsiFile psiFile = (PsiFile)LangDataKeys.PSI_FILE.getData(dataContext);
        if (psiFile != null) {
            CodeInspectionOnEditorAction.analyze(project, psiFile);
        }
    }

    protected static void analyze(Project project, PsiFile psiFile) {
        FileDocumentManager.getInstance().saveAllDocuments();
        InspectionManagerEx inspectionManagerEx = (InspectionManagerEx)InspectionManager.getInstance((Project)project);
        AnalysisScope scope = new AnalysisScope(psiFile);
        GlobalInspectionContextImpl inspectionContext = inspectionManagerEx.createNewGlobalContext(false);
        inspectionContext.setCurrentScope(scope);
        InspectionProfile inspectionProfile = InspectionProjectProfileManager.getInstance(project).getInspectionProfile();
        inspectionContext.setExternalProfile(inspectionProfile);
        inspectionContext.doInspections(scope, inspectionManagerEx);
    }

    public void update(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        PsiFile psiFile = (PsiFile)LangDataKeys.PSI_FILE.getData(dataContext);
        e.getPresentation().setEnabled(project != null && psiFile != null && DaemonCodeAnalyzer.getInstance((Project)project).isHighlightingAvailable(psiFile));
    }
}

