/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.actions;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class UnimplementInterfaceAction
implements IntentionAction {
    private String myName = "Interface";

    @NotNull
    public String getText() {
        String string = "Unimplement " + this.myName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/actions/UnimplementInterfaceAction.getText must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Unimplement Interface/Class" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/actions/UnimplementInterfaceAction.getFamilyName must not return null");
        }
        return "Unimplement Interface/Class";
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/actions/UnimplementInterfaceAction.isAvailable must not be null");
        }
        if (!(file instanceof PsiJavaFile)) {
            return false;
        }
        PsiReference psiReference = TargetElementUtilBase.findReference(editor);
        if (psiReference == null) {
            return false;
        }
        PsiReferenceList referenceList = (PsiReferenceList)PsiTreeUtil.getParentOfType((PsiElement)psiReference.getElement(), PsiReferenceList.class);
        if (referenceList == null) {
            return false;
        }
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)referenceList, PsiClass.class);
        if (psiClass == null) {
            return false;
        }
        if (psiClass.getExtendsList() != referenceList && psiClass.getImplementsList() != referenceList) {
            return false;
        }
        PsiElement target = psiReference.resolve();
        if (target == null || !(target instanceof PsiClass)) {
            return false;
        }
        PsiClass targetClass = (PsiClass)target;
        this.myName = targetClass.isInterface() ? "Interface" : "Class";
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiMethod[] psiMethods;
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/actions/UnimplementInterfaceAction.invoke must not be null");
        }
        if (!CodeInsightUtilBase.preparePsiElementForWrite((PsiElement)file)) {
            return;
        }
        PsiReference psiReference = file.findReferenceAt(editor.getCaretModel().getOffset());
        if (psiReference == null) {
            return;
        }
        PsiReferenceList referenceList = (PsiReferenceList)PsiTreeUtil.getParentOfType((PsiElement)psiReference.getElement(), PsiReferenceList.class);
        if (referenceList == null) {
            return;
        }
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)referenceList, PsiClass.class);
        if (psiClass == null) {
            return;
        }
        if (psiClass.getExtendsList() != referenceList && psiClass.getImplementsList() != referenceList) {
            return;
        }
        PsiElement target = psiReference.resolve();
        if (target == null || !(target instanceof PsiClass)) {
            return;
        }
        PsiClass targetClass = (PsiClass)target;
        psiReference.getElement().delete();
        for (PsiMethod psiMethod : psiMethods = targetClass.getAllMethods()) {
            PsiMethod[] implementingMethods;
            for (PsiMethod implementingMethod : implementingMethods = psiClass.findMethodsBySignature(psiMethod, false)) {
                implementingMethod.delete();
            }
        }
    }

    public boolean startInWriteAction() {
        return true;
    }
}

