/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiType;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class DfaTypeValue
extends DfaValue {
    private PsiType myType;
    private String myCanonicalText;
    private boolean myIsNullable;

    private DfaTypeValue(DfaValueFactory factory) {
        super(factory);
    }

    private DfaTypeValue(PsiType type, boolean isNullable, DfaValueFactory factory) {
        super(factory);
        this.myType = type;
        this.myIsNullable = isNullable;
        this.myCanonicalText = type.getCanonicalText();
        if (this.myCanonicalText == null) {
            this.myCanonicalText = "null";
        }
    }

    public PsiType getType() {
        return this.myType;
    }

    public boolean isNullable() {
        return this.myIsNullable;
    }

    @NonNls
    public String toString() {
        return this.myCanonicalText + ", nullable=" + this.myIsNullable;
    }

    private boolean hardEquals(DfaTypeValue aType) {
        return Comparing.equal((String)this.myCanonicalText, (String)aType.myCanonicalText) && this.myIsNullable == aType.myIsNullable;
    }

    public boolean isAssignableFrom(DfaTypeValue dfaType) {
        return dfaType != null && this.myType.isAssignableFrom(dfaType.myType);
    }

    public boolean isConvertibleFrom(DfaTypeValue dfaType) {
        return dfaType != null && this.myType.isConvertibleFrom(dfaType.myType);
    }

    public static class Factory {
        private final DfaTypeValue mySharedInstance;
        private final HashMap<String, ArrayList<DfaTypeValue>> myStringToObject;
        private final DfaValueFactory myFactory;

        Factory(DfaValueFactory factory) {
            this.myFactory = factory;
            this.mySharedInstance = new DfaTypeValue(factory);
            this.myStringToObject = new HashMap();
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public DfaTypeValue create(PsiType type, boolean nullable) {
            DfaTypeValue dfaTypeValue;
            String id;
            ArrayList<DfaTypeValue> conditions;
            this.mySharedInstance.myType = type;
            this.mySharedInstance.myCanonicalText = type.getCanonicalText();
            this.mySharedInstance.myIsNullable = nullable;
            if (this.mySharedInstance.myCanonicalText == null) {
                this.mySharedInstance.myCanonicalText = "null";
            }
            if ((conditions = (ArrayList<DfaTypeValue>)this.myStringToObject.get((Object)(id = this.mySharedInstance.toString()))) == null) {
                conditions = new ArrayList<DfaTypeValue>();
                this.myStringToObject.put((Object)id, conditions);
            } else {
                for (DfaTypeValue aType : conditions) {
                    if (!aType.hardEquals(this.mySharedInstance)) continue;
                    dfaTypeValue = aType;
                    if (dfaTypeValue == null) throw new IllegalStateException("@NotNull method com/intellij/codeInspection/dataFlow/value/DfaTypeValue$Factory.create must not return null");
                    return dfaTypeValue;
                }
            }
            DfaTypeValue result = new DfaTypeValue(type, nullable, this.myFactory);
            conditions.add(result);
            dfaTypeValue = result;
            if (dfaTypeValue != null) return dfaTypeValue;
            throw new IllegalStateException("@NotNull method com/intellij/codeInspection/dataFlow/value/DfaTypeValue$Factory.create must not return null");
        }

        public DfaTypeValue create(PsiType type) {
            return this.create(type, false);
        }
    }
}

