/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.classParsing;

import com.intellij.compiler.classParsing.FieldInfo;
import com.intellij.compiler.classParsing.MemberInfo;
import com.intellij.compiler.classParsing.MemberInfoExternalizer;
import com.intellij.compiler.classParsing.MethodInfo;
import com.intellij.compiler.classParsing.ReferenceInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;

public class MemberReferenceInfo
extends ReferenceInfo {
    private final MemberInfo myMemberInfo;

    public MemberReferenceInfo(int declaringClass, MemberInfo memberInfo) {
        super(declaringClass);
        this.myMemberInfo = memberInfo;
    }

    public MemberReferenceInfo(DataInput in) throws IOException {
        super(in);
        this.myMemberInfo = MemberInfoExternalizer.loadMemberInfo(in);
    }

    public MemberInfo getMemberInfo() {
        return this.myMemberInfo;
    }

    public boolean isFieldReference() {
        return this.myMemberInfo instanceof FieldInfo;
    }

    public boolean isMethodReference() {
        return this.myMemberInfo instanceof MethodInfo;
    }

    @Override
    public void save(DataOutput out) throws IOException {
        super.save(out);
        MemberInfoExternalizer.saveMemberInfo(out, this.myMemberInfo);
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        return this.myMemberInfo.equals(((MemberReferenceInfo)o).myMemberInfo);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.myMemberInfo.hashCode();
    }

    @Override
    @NonNls
    public String toString() {
        return "Member reference: [class name=" + this.getClassName() + ", member name = " + this.myMemberInfo.getName() + ", member descriptor=" + this.myMemberInfo.getDescriptor() + ", member signature=" + this.myMemberInfo.getGenericSignature() + "]";
    }
}

