/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CompositeScope
extends UserDataHolderBase
implements CompileScope {
    private final List<CompileScope> myScopes = new ArrayList<CompileScope>();

    public CompositeScope(CompileScope scope1, CompileScope scope2) {
        this.addScope(scope1);
        this.addScope(scope2);
    }

    public CompositeScope(CompileScope[] scopes) {
        for (CompileScope scope : scopes) {
            this.addScope(scope);
        }
    }

    private void addScope(CompileScope scope) {
        if (scope instanceof CompositeScope) {
            CompositeScope compositeScope = (CompositeScope)scope;
            for (CompileScope childScope : compositeScope.myScopes) {
                this.addScope(childScope);
            }
        } else {
            this.myScopes.add(scope);
        }
    }

    @NotNull
    public VirtualFile[] getFiles(FileType fileType, boolean inSourceOnly) {
        THashSet allFiles = new THashSet();
        for (CompileScope scope : this.myScopes) {
            VirtualFile[] files = scope.getFiles(fileType, inSourceOnly);
            if (files.length <= 0) continue;
            allFiles.addAll(Arrays.asList(files));
        }
        VirtualFile[] virtualFileArray = VfsUtil.toVirtualFileArray((Collection)allFiles);
        if (virtualFileArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/compiler/impl/CompositeScope.getFiles must not return null");
        }
        return virtualFileArray;
    }

    public boolean belongs(String url) {
        for (CompileScope scope : this.myScopes) {
            if (!scope.belongs(url)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Module[] getAffectedModules() {
        HashSet<Module> modules = new HashSet<Module>();
        for (CompileScope compileScope : this.myScopes) {
            modules.addAll(Arrays.asList(compileScope.getAffectedModules()));
        }
        Module[] moduleArray = modules.toArray(new Module[modules.size()]);
        if (moduleArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/compiler/impl/CompositeScope.getAffectedModules must not return null");
        }
        return moduleArray;
    }

    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/impl/CompositeScope.getUserData must not be null");
        }
        for (CompileScope compileScope : this.myScopes) {
            Object userData = compileScope.getUserData(key);
            if (userData == null) continue;
            return (T)userData;
        }
        return (T)super.getUserData(key);
    }
}

