/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.javaCompiler.javac;

import com.intellij.compiler.impl.javaCompiler.javac.JavacConfiguration;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import java.nio.charset.Charset;
import java.util.StringTokenizer;

public class JavacSettings {
    public boolean DEBUGGING_INFO = true;
    public boolean GENERATE_NO_WARNINGS = false;
    public boolean DEPRECATION = true;
    public String ADDITIONAL_OPTIONS_STRING = "";
    public int MAXIMUM_HEAP_SIZE = 128;
    private boolean myTestsUseExternalCompiler = false;

    public String getOptionsString(Project project) {
        StringBuilder options = new StringBuilder();
        if (this.DEBUGGING_INFO) {
            options.append("-g ");
        }
        if (this.DEPRECATION) {
            options.append("-deprecation ");
        }
        if (this.GENERATE_NO_WARNINGS) {
            options.append("-nowarn ");
        }
        boolean isEncodingSet = false;
        StringTokenizer tokenizer = new StringTokenizer(this.ADDITIONAL_OPTIONS_STRING, " \t\r\n");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if ("-g".equals(token) || "-deprecation".equals(token) || "-nowarn".equals(token)) continue;
            options.append(token);
            options.append(" ");
            if (!"-encoding".equals(token)) continue;
            isEncodingSet = true;
        }
        if (!isEncodingSet) {
            Charset ideCharset = EncodingProjectManager.getInstance((Project)project).getDefaultCharset();
            if (!Comparing.equal((Object)CharsetToolkit.getDefaultSystemCharset(), (Object)ideCharset)) {
                options.append("-encoding ");
                options.append(ideCharset.name());
            }
        }
        return options.toString();
    }

    public static JavacSettings getInstance(Project project) {
        return ((JavacConfiguration)ServiceManager.getService((Project)project, JavacConfiguration.class)).getSettings();
    }

    public boolean isTestsUseExternalCompiler() {
        return this.myTestsUseExternalCompiler;
    }

    public void setTestsUseExternalCompiler(boolean testsUseExternalCompiler) {
        this.myTestsUseExternalCompiler = testsUseExternalCompiler;
    }
}

