/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl.descriptors.data;

import com.intellij.debugger.impl.descriptors.data.DescriptorData;
import com.intellij.debugger.impl.descriptors.data.DisplayKey;
import com.intellij.debugger.impl.descriptors.data.SimpleDisplayKey;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.ui.impl.watch.LocalVariableDescriptorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.util.StringBuilderSpinAllocator;

public class LocalData
extends DescriptorData<LocalVariableDescriptorImpl> {
    private final LocalVariableProxyImpl myLocalVariable;

    public LocalData(LocalVariableProxyImpl localVariable) {
        this.myLocalVariable = localVariable;
    }

    @Override
    protected LocalVariableDescriptorImpl createDescriptorImpl(Project project) {
        return new LocalVariableDescriptorImpl(project, this.myLocalVariable);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof LocalData)) {
            return false;
        }
        return ((LocalData)object).myLocalVariable.equals(this.myLocalVariable);
    }

    @Override
    public int hashCode() {
        return this.myLocalVariable.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisplayKey<LocalVariableDescriptorImpl> getDisplayKey() {
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        try {
            SimpleDisplayKey<LocalVariableDescriptorImpl> simpleDisplayKey = new SimpleDisplayKey<LocalVariableDescriptorImpl>(builder.append(this.myLocalVariable.typeName()).append("#").append(this.myLocalVariable.name()).toString());
            return simpleDisplayKey;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)builder);
        }
    }
}

