/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl.descriptors.data;

import com.intellij.debugger.impl.descriptors.data.DescriptorData;
import com.intellij.debugger.impl.descriptors.data.DisplayKey;
import com.intellij.debugger.ui.impl.watch.MethodReturnValueDescriptorImpl;
import com.intellij.openapi.project.Project;
import com.sun.jdi.Method;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MethodReturnValueData
extends DescriptorData<MethodReturnValueDescriptorImpl> {
    @Nullable
    private final Value myReturnValue;
    @NotNull
    private final Method myMethod;

    public MethodReturnValueData(@NotNull Method method, @Nullable Value returnValue) {
        if (method == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/debugger/impl/descriptors/data/MethodReturnValueData.<init> must not be null");
        }
        this.myMethod = method;
        this.myReturnValue = returnValue;
    }

    @Nullable
    public Value getReturnValue() {
        return this.myReturnValue;
    }

    @NotNull
    public Method getMethod() {
        Method method = this.myMethod;
        if (method == null) {
            throw new IllegalStateException("@NotNull method com/intellij/debugger/impl/descriptors/data/MethodReturnValueData.getMethod must not return null");
        }
        return method;
    }

    @Override
    protected MethodReturnValueDescriptorImpl createDescriptorImpl(Project project) {
        return new MethodReturnValueDescriptorImpl(project, this.myMethod, this.myReturnValue);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodReturnValueData that = (MethodReturnValueData)o;
        if (!((Object)this.myMethod).equals(that.myMethod)) {
            return false;
        }
        return !(this.myReturnValue != null ? !this.myReturnValue.equals(that.myReturnValue) : that.myReturnValue != null);
    }

    @Override
    public int hashCode() {
        int result = this.myReturnValue != null ? this.myReturnValue.hashCode() : 0;
        result = 31 * result + ((Object)this.myMethod).hashCode();
        return result;
    }

    @Override
    public DisplayKey<MethodReturnValueDescriptorImpl> getDisplayKey() {
        return new MethodReturnValueDisplayKey(this.myMethod, this.myReturnValue);
    }

    private static final class MethodReturnValueDisplayKey
    implements DisplayKey<MethodReturnValueDescriptorImpl> {
        @NotNull
        private final Method myMethod;
        @Nullable
        private final Value myValue;

        public MethodReturnValueDisplayKey(@NotNull Method method, @Nullable Value value) {
            if (method == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/debugger/impl/descriptors/data/MethodReturnValueData$MethodReturnValueDisplayKey.<init> must not be null");
            }
            this.myMethod = method;
            this.myValue = value;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodReturnValueDisplayKey that = (MethodReturnValueDisplayKey)o;
            if (!((Object)this.myMethod).equals(that.myMethod)) {
                return false;
            }
            return !(this.myValue != null ? !this.myValue.equals(that.myValue) : that.myValue != null);
        }

        @Override
        public int hashCode() {
            int result = ((Object)this.myMethod).hashCode();
            result = 31 * result + (this.myValue != null ? this.myValue.hashCode() : 0);
            return result;
        }
    }
}

