/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.ui.classFilter.ClassFilterEditor;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class DebuggerSteppingConfigurable
implements SearchableConfigurable {
    private JCheckBox myCbStepInfoFiltersEnabled;
    private JCheckBox myCbSkipSyntheticMethods;
    private JCheckBox myCbSkipConstructors;
    private JCheckBox myCbSkipClassLoaders;
    private ClassFilterEditor mySteppingFilterEditor;
    private JCheckBox myCbSkipSimpleGetters;
    private final Project myProject;

    public DebuggerSteppingConfigurable(Project project) {
        this.myProject = project;
    }

    public void reset() {
        DebuggerSettings settings = DebuggerSettings.getInstance();
        this.myCbSkipSimpleGetters.setSelected(settings.SKIP_GETTERS);
        this.myCbSkipSyntheticMethods.setSelected(settings.SKIP_SYNTHETIC_METHODS);
        this.myCbSkipConstructors.setSelected(settings.SKIP_CONSTRUCTORS);
        this.myCbSkipClassLoaders.setSelected(settings.SKIP_CLASSLOADERS);
        this.myCbStepInfoFiltersEnabled.setSelected(settings.TRACING_FILTERS_ENABLED);
        this.mySteppingFilterEditor.setFilters(settings.getSteppingFilters());
        this.mySteppingFilterEditor.setEnabled(settings.TRACING_FILTERS_ENABLED);
    }

    public void apply() {
        this.getSettingsTo(DebuggerSettings.getInstance());
    }

    private void getSettingsTo(DebuggerSettings settings) {
        settings.SKIP_GETTERS = this.myCbSkipSimpleGetters.isSelected();
        settings.SKIP_SYNTHETIC_METHODS = this.myCbSkipSyntheticMethods.isSelected();
        settings.SKIP_CONSTRUCTORS = this.myCbSkipConstructors.isSelected();
        settings.SKIP_CLASSLOADERS = this.myCbSkipClassLoaders.isSelected();
        settings.TRACING_FILTERS_ENABLED = this.myCbStepInfoFiltersEnabled.isSelected();
        this.mySteppingFilterEditor.stopEditing();
        settings.setSteppingFilters(this.mySteppingFilterEditor.getFilters());
    }

    public boolean isModified() {
        DebuggerSettings currentSettings = DebuggerSettings.getInstance();
        DebuggerSettings debuggerSettings = currentSettings.clone();
        this.getSettingsTo(debuggerSettings);
        return !debuggerSettings.equals(currentSettings);
    }

    public String getDisplayName() {
        return DebuggerBundle.message((String)"debugger.stepping.configurable.display.name", (Object[])new Object[0]);
    }

    public Icon getIcon() {
        return null;
    }

    public String getHelpTopic() {
        return "reference.idesettings.debugger.stepping";
    }

    public String getId() {
        return this.getHelpTopic();
    }

    public Runnable enableSearch(String option) {
        return null;
    }

    public JComponent createComponent() {
        JPanel panel = new JPanel(new GridBagLayout());
        this.myCbSkipSyntheticMethods = new JCheckBox(DebuggerBundle.message((String)"label.debugger.general.configurable.skip.synthetic.methods", (Object[])new Object[0]));
        this.myCbSkipConstructors = new JCheckBox(DebuggerBundle.message((String)"label.debugger.general.configurable.skip.constructors", (Object[])new Object[0]));
        this.myCbSkipClassLoaders = new JCheckBox(DebuggerBundle.message((String)"label.debugger.general.configurable.skip.classloaders", (Object[])new Object[0]));
        this.myCbSkipSimpleGetters = new JCheckBox(DebuggerBundle.message((String)"label.debugger.general.configurable.skip.simple.getters", (Object[])new Object[0]));
        this.myCbStepInfoFiltersEnabled = new JCheckBox(DebuggerBundle.message((String)"label.debugger.general.configurable.step.filters.list.header", (Object[])new Object[0]));
        panel.add((Component)this.myCbSkipSyntheticMethods, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
        panel.add((Component)this.myCbSkipConstructors, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
        panel.add((Component)this.myCbSkipClassLoaders, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
        panel.add((Component)this.myCbSkipSimpleGetters, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
        panel.add((Component)this.myCbStepInfoFiltersEnabled, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(8, 4, 0, 0), 0, 0));
        this.mySteppingFilterEditor = new ClassFilterEditor(this.myProject);
        panel.add((Component)this.mySteppingFilterEditor, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 12, 0, 0), 0, 0));
        this.myCbStepInfoFiltersEnabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DebuggerSteppingConfigurable.this.mySteppingFilterEditor.setEnabled(DebuggerSteppingConfigurable.this.myCbStepInfoFiltersEnabled.isSelected());
            }
        });
        return panel;
    }

    public void disposeUIResources() {
    }
}

