/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.ui.breakpoints.BreakpointCategory;
import com.intellij.debugger.ui.breakpoints.ExceptionBreakpoint;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Key;
import com.sun.jdi.ReferenceType;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public class AnyExceptionBreakpoint
extends ExceptionBreakpoint {
    @NonNls
    public static final Key<AnyExceptionBreakpoint> ANY_EXCEPTION_BREAKPOINT = BreakpointCategory.lookup("breakpoint_any");

    protected AnyExceptionBreakpoint(Project project) {
        super(project, null, null);
        this.ENABLED = false;
    }

    public Key<AnyExceptionBreakpoint> getCategory() {
        return ANY_EXCEPTION_BREAKPOINT;
    }

    @Override
    public String getDisplayName() {
        return DebuggerBundle.message((String)"breakpoint.any.exception.display.name", (Object[])new Object[0]);
    }

    @Override
    public void createRequest(DebugProcessImpl debugProcess) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (!this.ENABLED || !debugProcess.isAttached() || debugProcess.areBreakpointsMuted() || !debugProcess.getRequestsManager().findRequests(this).isEmpty()) {
            return;
        }
        super.processClassPrepare(debugProcess, null);
    }

    @Override
    public void processClassPrepare(DebugProcess debugProcess, ReferenceType refType) {
    }

    @Override
    public void readExternal(Element parentNode) throws InvalidDataException {
        block2: {
            try {
                super.readExternal(parentNode);
            }
            catch (InvalidDataException e) {
                if (READ_NO_CLASS_NAME.equals(e.getMessage())) break block2;
                throw e;
            }
        }
    }
}

